@extends('layouts.app', ['title' => 'Configurar Etiquetas'])

@section('css')
<style>
    .card-etiquetas {
        margin-bottom: 20px;
    }
    
    .modelo-selecionado {
        border: 2px solid #3498db;
        box-shadow: 0 0 10px rgba(52, 152, 219, 0.3);
    }
    
    .lista-produtos {
        max-height: 500px;
        overflow-y: auto;
        border: 1px solid #eee;
        border-radius: 5px;
        padding: 10px;
    }
    
    .produto-item {
        padding: 12px;
        border-bottom: 1px solid #eee;
        display: flex;
        align-items: center;
        margin-bottom: 5px;
    }
    
    .produto-item:last-child {
        border-bottom: none;
    }
    
    .produto-item img {
        max-width: 40px;
        margin-right: 15px;
    }
    
    .produto-info {
        flex-grow: 1;
    }
    
    .produto-quantidade {
        margin-left: 10px;
        font-weight: bold;
        padding: 5px 10px;
        background-color: #f8f9fa;
        border-radius: 4px;
    }
    
    .form-section {
        margin-bottom: 20px;
        padding: 15px;
        background-color: #f8f9fa;
        border-radius: 5px;
    }
    
    .modelo-card {
        cursor: pointer;
        transition: all 0.3s ease;
        margin-bottom: 15px;
    }
    
    .modelo-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    }
    
    .modelo-titulo {
        font-weight: bold;
        padding: 10px;
        text-align: center;
        border-bottom: 1px solid #eee;
    }
    
    .modelo-info {
        padding: 15px;
    }
    
    .modelo-info p {
        margin-bottom: 5px;
    }
    
    .footer-actions {
        margin-top: 30px;
        text-align: center;
    }
</style>
@endsection

@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h4>Configurar Etiquetas</h4>
                    <a href="{{ route('produtos.emissao-etiquetas') }}" class="btn btn-secondary">
                        <i class="ri-arrow-left-line"></i> Voltar
                    </a>
                </div>
                
                <div class="alert alert-info">
                    <i class="ri-information-line me-2"></i>
                    Configure os detalhes para impressão das etiquetas dos produtos selecionados.
                </div>
                
                <form action="{{ route('produtos.gerar-etiquetas') }}" method="POST" target="_blank">
                    @csrf
                    
                    <div class="row">
                        <div class="col-md-8">
                            <!-- Configurações de Etiqueta -->
                            <div class="card card-etiquetas">
                                <div class="card-header bg-primary text-white">
                                    <h5 class="mb-0">Configurações de Impressão</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row mb-3">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="modelo_id">Selecione um modelo predefinido:</label>
                                                <select id="modelo_id" name="modelo_id" class="form-select">
                                                    <option value="">Selecione um modelo</option>
                                                    @foreach($modelos as $modelo)
                                                    <option value="{{ $modelo->id }}">{{ $modelo->nome }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="tipo">Tipo de Etiqueta:</label>
                                                <select id="tipo" name="tipo" class="form-select" required>
                                                    <option value="produto">Produto</option>
                                                    <option value="gondola">Gôndola</option>
                                                    <option value="prateleira">Prateleira</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="etiquestas_por_linha">Etiquetas por Linha:</label>
                                                <input type="number" id="etiquestas_por_linha" name="etiquestas_por_linha" class="form-control" value="2" min="1" max="10" required>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row mb-3">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="altura">Altura (mm):</label>
                                                <input type="number" id="altura" name="altura" class="form-control" value="40" min="10" max="500" required>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="largura">Largura (mm):</label>
                                                <input type="number" id="largura" name="largura" class="form-control" value="100" min="10" max="500" required>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="distancia_etiquetas_topo">Margem Interna Topo (mm):</label>
                                                <input type="number" id="distancia_etiquetas_topo" name="distancia_etiquetas_topo" class="form-control" value="10" step="0.01" min="0">
                                                <small class="text-muted">Espaço dentro da etiqueta</small>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="distancia_etiquetas_lateral">Distância Entre Etiquetas (mm):</label>
                                                <input type="number" id="distancia_etiquetas_lateral" name="distancia_etiquetas_lateral" class="form-control" value="5" step="0.01" min="0">
                                                <small class="text-muted">Espaço horizontal entre etiquetas lado a lado</small>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="distancia_etiquetas_horizontal">Distância Entre Linhas (mm):</label>
                                                <input type="number" id="distancia_etiquetas_horizontal" name="distancia_etiquetas_horizontal" class="form-control" value="5" step="0.01" min="0">
                                                <small class="text-muted">Espaço vertical entre linhas de etiquetas</small>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row mb-3">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="tamanho_fonte">Tamanho da Fonte:</label>
                                                <input type="number" id="tamanho_fonte" name="tamanho_fonte" class="form-control" value="10" min="6" max="24">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="tamanho_codigo_barras">Tamanho Código de Barras:</label>
                                                <input type="number" id="tamanho_codigo_barras" name="tamanho_codigo_barras" class="form-control" value="40" min="1" max="100">
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-12">
                                            <label>Informações da Etiqueta:</label>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" id="nome_empresa" name="nome_empresa" checked>
                                                <label class="form-check-label" for="nome_empresa">
                                                    Nome da Empresa
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" id="nome_produto" name="nome_produto" checked>
                                                <label class="form-check-label" for="nome_produto">
                                                    Nome do Produto
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" id="valor_produto" name="valor_produto" checked>
                                                <label class="form-check-label" for="valor_produto">
                                                    Valor do Produto
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" id="codigo_produto" name="codigo_produto" checked>
                                                <label class="form-check-label" for="codigo_produto">
                                                    Código do Produto
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" id="codigo_barras_numerico" name="codigo_barras_numerico" checked>
                                                <label class="form-check-label" for="codigo_barras_numerico">
                                                    Código de Barras Numérico
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <!-- Lista de Produtos Selecionados -->
                            <div class="card card-etiquetas">
                                <div class="card-header bg-success text-white">
                                    <h5 class="mb-0">Produtos Selecionados</h5>
                                </div>
                                <div class="card-body p-0">
                                    <div class="lista-produtos">
                                        @forelse($produtos as $produto)
                                        <div class="produto-item">
                                            <img src="{{ $produto->img }}" class="img-thumbnail">
                                            <div class="produto-info">
                                                <div class="fw-bold">{{ $produto->nome }}</div>
                                                <small class="text-muted">{{ $produto->codigo_barras ?? 'Sem código' }}</small>
                                            </div>
                                            <div class="produto-quantidade">
                                                {{ $produto->quantidade_etiqueta }}
                                            </div>
                                        </div>
                                        @empty
                                        <div class="p-4 text-center text-muted">
                                            <i class="ri-file-list-3-line fs-3 mb-2"></i>
                                            <p>Nenhum produto selecionado</p>
                                        </div>
                                        @endforelse
                                    </div>
                                </div>
                                <div class="card-footer text-center">
                                    <span class="text-muted">Total de produtos: {{ count($produtos) }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="footer-actions">
                        <button type="submit" class="btn btn-success btn-lg">
                            <i class="ri-printer-line me-1"></i> Gerar Etiquetas
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script>
    $(document).ready(function() {
        // Carregar modelo selecionado
        $('#modelo_id').change(function() {
            const modeloId = $(this).val();
            if (modeloId) {
                $.get(`{{ url('modelo-etiqueta') }}/${modeloId}`, function(data) {
                    console.log(data);
                    // Preencher os campos com os dados do modelo
                    $('#altura').val(data.altura);
                    $('#largura').val(data.largura);
                    $('#etiquestas_por_linha').val(data.etiquestas_por_linha);
                    
                    // Tratar os valores das distâncias - podem vir como string ou número
                    const processValue = function(value) {
                        if (typeof value === 'string') {
                            return parseFloat(value.replace(',', '.'));
                        }
                        return value;
                    };
                    
                    $('#distancia_etiquetas_topo').val(processValue(data.distancia_etiquetas_topo));
                    $('#distancia_etiquetas_lateral').val(processValue(data.distancia_etiquetas_lateral));
                    $('#distancia_etiquetas_horizontal').val(processValue(data.distancia_etiquetas_horizontal));
                    
                    $('#tamanho_fonte').val(data.tamanho_fonte);
                    $('#tamanho_codigo_barras').val(data.tamanho_codigo_barras);
                    
                    // Marcar/desmarcar checkboxes conforme o modelo
                    $('#nome_empresa').prop('checked', data.nome_empresa == 1);
                    $('#nome_produto').prop('checked', data.nome_produto == 1);
                    $('#valor_produto').prop('checked', data.valor_produto == 1);
                    $('#codigo_produto').prop('checked', data.codigo_produto == 1);
                    $('#codigo_barras_numerico').prop('checked', data.codigo_barras_numerico == 1);
                    
                    $('#tipo').val(data.tipo);
                });
            }
        });
    });
</script>
@endsection 