@php
$title = 'Fluxo de Caixa Projetado - ' . config('app.name');
@endphp
@extends('layouts.app')
@section('content')

<div class="container-fluid px-4">
    <div class="mb-2 mt-2">
        <div class="row">
            <div class="col-md-6">
                <h3 class="h4"><i class="far fa-calendar-times"></i> Relatório de Inadimplência</h3>
            </div>
            <div class="col-md-6 text-right">
                <a href="{{ route('home') }}" class="btn btn-outline-primary btn-sm"><i class="fas fa-undo"></i> Voltar</a>
                <button onclick="window.print()" class="btn btn-outline-success btn-sm"><i class="fas fa-print"></i> Imprimir</button>
                <a href="#" class="btn btn-outline-secondary btn-sm" onclick="exportarPDF()"><i class="fas fa-file-pdf"></i> Exportar PDF</a>
                <a href="#" class="btn btn-outline-secondary btn-sm" onclick="exportarExcel()"><i class="fas fa-file-excel"></i> Exportar Excel</a>
            </div>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-header">
            <form method="GET" action="{{ route('conta-receber.relatorio-inadimplencia') }}" class="row g-3">
                <div class="col-md-3">
                    <label for="dias_atraso" class="form-label">Dias de Atraso Mínimo</label>
                    <input type="number" class="form-control" id="dias_atraso" name="dias_atraso" value="{{ $dias_atraso }}">
                </div>
                <div class="col-md-3">
                    <label for="cliente_id" class="form-label">Cliente</label>
                    <select class="form-select" id="cliente_id" name="cliente_id">
                        <option value="">Todos</option>
                        @foreach($clientes as $cliente)
                            <option value="{{ $cliente->id }}" {{ $cliente_id == $cliente->id ? 'selected' : '' }}>
                                {{ $cliente->razao_social }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="categoria_id" class="form-label">Categoria</label>
                    <select class="form-select" id="categoria_id" name="categoria_id">
                        <option value="">Todas</option>
                        @foreach($categorias as $categoria)
                            <option value="{{ $categoria->id }}" {{ $categoria_id == $categoria->id ? 'selected' : '' }}>
                                {{ $categoria->nome }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">Filtrar</button>
                    <a href="{{ route('conta-receber.relatorio-inadimplencia') }}" class="btn btn-secondary">Limpar</a>
                </div>
            </form>
        </div>
        <div class="card-body">
            <div class="alert alert-info">
                <h5 class="mb-0">Total de Inadimplência: R$ {{ __moeda($totalInadimplencia) }}</h5>
            </div>

            @if(count($contasPorCliente) > 0)
                <div class="accordion" id="accordionInadimplencia">
                    @foreach($contasPorCliente as $cliente_id => $contas)
                        @php
                            $cliente = $contas->first()->cliente;
                            $totalCliente = $contas->sum('valor_integral') - $contas->sum('valor_pago');
                            $maiorAtraso = $contas->max(function($conta) {
                                return \Carbon\Carbon::parse($conta->data_vencimento)->diffInDays(now());
                            });
                        @endphp
                        <div class="accordion-item mb-2">
                            <h2 class="accordion-header" id="heading{{ $cliente_id }}">
                                <button class="accordion-button {{ $loop->first ? '' : 'collapsed' }}" type="button" 
                                    data-bs-toggle="collapse" data-bs-target="#collapse{{ $cliente_id }}" 
                                    aria-expanded="{{ $loop->first ? 'true' : 'false' }}" aria-controls="collapse{{ $cliente_id }}">
                                    <div class="row w-100">
                                        <div class="col-md-6">
                                            <strong>{{ $cliente->razao_social }}</strong>
                                        </div>
                                        <div class="col-md-3 text-end">
                                            <span class="badge bg-danger">{{ $maiorAtraso }} dias de atraso</span>
                                        </div>
                                        <div class="col-md-3 text-end">
                                            <span class="badge bg-primary">R$ {{ __moeda($totalCliente) }}</span>
                                        </div>
                                    </div>
                                </button>
                            </h2>
                            <div id="collapse{{ $cliente_id }}" class="accordion-collapse collapse {{ $loop->first ? 'show' : '' }}" 
                                aria-labelledby="heading{{ $cliente_id }}" data-bs-parent="#accordionInadimplencia">
                                <div class="accordion-body">
                                    <div class="table-responsive">
                                        <table class="table table-striped table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Descrição</th>
                                                    <th>Categoria</th>
                                                    <th>Vencimento</th>
                                                    <th>Dias Atraso</th>
                                                    <th>Valor Pendente</th>
                                                    <th>Ações</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($contas as $conta)
                                                    @php
                                                        $diasAtraso = abs(floor((strtotime(date('Y-m-d')) - strtotime($conta->data_vencimento)) / (60 * 60 * 24)));
                                                        $valorPendente = $conta->valorPendente();
                                                    @endphp
                                                    <tr>
                                                        <td>{{ $conta->descricao ?? 'Sem descrição' }}</td>
                                                        <td>{{ $conta->categoria->nome ?? 'Sem categoria' }}</td>
                                                        <td>{{ __data_pt($conta->data_vencimento) }}</td>
                                                        <td>
                                                            <span class="badge {{ $diasAtraso > 30 ? 'bg-danger' : ($diasAtraso > 15 ? 'bg-warning' : 'bg-secondary') }}">
                                                                {{ $diasAtraso }} dias
                                                            </span>
                                                        </td>
                                                        <td>R$ {{ __moeda($valorPendente) }}</td>
                                                        <td>
                                                            <a href="{{ route('conta-receber.pay', $conta->id) }}" class="btn btn-success btn-sm">
                                                                <i class="fas fa-hand-holding-usd"></i> Receber
                                                            </a>
                                                            <a href="{{ route('conta-receber.edit', $conta->id) }}" class="btn btn-primary btn-sm">
                                                                <i class="fas fa-edit"></i> Editar
                                                            </a>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="alert alert-warning">
                    Nenhuma conta vencida encontrada com os critérios selecionados.
                </div>
            @endif
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
    function exportarPDF() {
        // Para ser implementado usando biblioteca de exportação PDF
        alert('Funcionalidade de exportação PDF em desenvolvimento');
    }

    function exportarExcel() {
        // Para ser implementado usando biblioteca de exportação Excel
        alert('Funcionalidade de exportação Excel em desenvolvimento');
    }
</script>
@endsection 