<div class="row g-2">
    <div class="col-md-2">
        {!!Form::tel('valor_pago', 'Valor')
        ->attrs(['class' => 'moeda', 'id' => 'valor_pago'])
        ->value(__moeda($item->valorPendente()))
        ->required()
        !!}
    </div>

    <div class="col-md-2">
        {!!Form::date('data_recebimento', 'Data do Recebimento')
        ->value(date('Y-m-d'))
        ->required()
        !!}
    </div>

    <div class="col-md-2">
        {!!Form::select('tipo_pagamento', 'Tipo de Pagamento', ['' => 'Selecione'] + App\Models\ContaReceber::tiposPagamento())
        ->attrs(['class' => 'form-select'])
        ->required()
        ->value($item->tipo_pagamento)
        !!}
    </div>

    <div class="col-md-3 div-conta-empresa">
        {!!Form::select('conta_empresa_id', 'Conta empresa')
        ->required()
        !!}
    </div>
    
    <div id="camposRecebimentoParcial" class="col-12 mt-3" style="display: none;">
        <div class="card border-warning">
            <div class="card-header bg-warning text-white">
                <h5 class="mb-0">Informações de Pagamento Parcial</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        {!!Form::date('data_nova_vencimento', 'Nova data de vencimento')
                        ->value(date('Y-m-d', strtotime('+30 days')))
                        ->attrs(['id' => 'data_nova_vencimento'])
                        !!}
                        <small class="form-text text-muted">Data para o pagamento do valor restante</small>
                    </div>
                    
                    <div class="col-md-3">
                        <label>Valores Calculados</label>
                        <div class="input-group mb-2">
                            <span class="input-group-text">Juros</span>
                            <input type="text" class="form-control" id="juros_aplicados" name="juros_aplicados" readonly>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <label>&nbsp;</label>
                        <div class="input-group mb-2">
                            <span class="input-group-text">Multa</span>
                            <input type="text" class="form-control" id="multa_aplicada" name="multa_aplicada" readonly>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="form-check mt-4">
                            <input class="form-check-input" type="checkbox" id="isentar_multa" name="isentar_multa">
                            <label class="form-check-label" for="isentar_multa">
                                Isentar de juros e multa
                            </label>
                        </div>
                        
                        <div id="div_senha_gerente" style="display: none;">
                            <input type="password" class="form-control mt-2" id="senha_gerente" name="senha_gerente" placeholder="Senha do gerente">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-12 mt-3">
        <button type="submit" class="btn btn-success px-5">Receber</button>
    </div>
</div>

@section('js')
@parent
<script>
    $(document).ready(function() {
        // Valor original da conta
        const valorIntegral = parseFloat('{{ $item->valor_integral }}');
        const valorRecebido = parseFloat('{{ $item->valor_recebido ?? 0 }}');
        const valorPendente = valorIntegral - valorRecebido;
        
        // Configurações financeiras
        const jurosDiario = parseFloat('{{ App\Models\ConfiguracaoFinanceira::where("empresa_id", request()->empresa_id)->first()->juros_diario ?? 0.033 }}');
        const multaAtraso = parseFloat('{{ App\Models\ConfiguracaoFinanceira::where("empresa_id", request()->empresa_id)->first()->multa_atraso ?? 2 }}');
        
        // Verificar inicialmente se é pagamento parcial
        verificarPagamentoParcial();
        
        // Verificar sempre que o valor mudar
        $('#valor_pago').on('input', function() {
            verificarPagamentoParcial();
        });
        
        // Recalcular juros e multa quando a data mudar
        $('#data_nova_vencimento').on('change', function() {
            calcularJurosMulta();
        });
        
        // Quando marcar isenção de multa
        $('#isentar_multa').on('change', function() {
            if ($(this).is(':checked')) {
                $('#div_senha_gerente').slideDown();
                $('#juros_aplicados').val('0,00');
                $('#multa_aplicada').val('0,00');
            } else {
                $('#div_senha_gerente').slideUp();
                calcularJurosMulta();
            }
        });
        
        // Função para verificar se é pagamento parcial
        function verificarPagamentoParcial() {
            let valorPago = converteMoedaFloat($('#valor_pago').val());
            
            if (valorPago < valorPendente) {
                $('#camposRecebimentoParcial').slideDown();
                calcularJurosMulta();
            } else {
                $('#camposRecebimentoParcial').slideUp();
            }
        }
        
        // Função para calcular juros e multa
        function calcularJurosMulta() {
            if ($('#isentar_multa').is(':checked')) return;
            
            let valorPago = converteMoedaFloat($('#valor_pago').val());
            let valorRestante = valorPendente - valorPago;
            
            // Verificar se a conta está vencida
            const hoje = new Date();
            const dataVencimento = new Date('{{ $item->data_vencimento }}');
            
            if (dataVencimento < hoje) {
                // Calcular dias de atraso
                const diasAtraso = Math.floor((hoje - dataVencimento) / (1000 * 60 * 60 * 24));
                
                // Calcular juros
                const juros = valorRestante * (jurosDiario / 100) * diasAtraso;
                const multa = valorRestante * (multaAtraso / 100);
                
                // Atualizar campos
                $('#juros_aplicados').val(juros.toFixed(2).replace('.', ','));
                $('#multa_aplicada').val(multa.toFixed(2).replace('.', ','));
            } else {
                $('#juros_aplicados').val('0,00');
                $('#multa_aplicada').val('0,00');
            }
        }
        
        // Função para converter string de moeda para float
        function converteMoedaFloat(valor) {
            if (!valor) return 0;
            return parseFloat(valor.replace('.', '').replace(',', '.'));
        }
    });
</script>
@endsection
