<div class="row g-2">
    <div class="col-md-3">
        {!!Form::select('conta_boleto', 'Conta', ['' => 'Selecione'] + $contasBoleto->pluck('info', 'id')->all())->required()
        ->attrs(['class' => 'form-select'])
        ->value($contaPadrao != null ? $contaPadrao->id : null)
        !!}
    </div>

    <div class="col-md-2">
        {!!Form::tel('carteira', 'Carteira')->required()
        ->attrs(['readonly' => 'readonly', 'style' => 'background-color: #e9ecef;'])
        !!}
    </div>
    <div class="col-md-2">
        {!!Form::tel('convenio', 'Convênio')->required()
        ->attrs(['readonly' => 'readonly', 'style' => 'background-color: #e9ecef;'])
        !!}
    </div>

    <div class="col-md-2">
        {!!Form::select('tipo', 'Tipo', ['Cnab400' => 'Cnab400', 'Cnab240' => 'Cnab240'])->required()
        ->attrs(['class' => 'form-select', 'disabled' => 'disabled', 'style' => 'background-color: #e9ecef;'])
        !!}
        <input type="hidden" name="tipo" id="tipo_hidden">
    </div>
    <div class="col-md-2">
        {!!Form::select('usar_logo', 'Usar logo', [0 => 'Não', 1 => 'Sim'])->required()
        ->attrs(['class' => 'form-select'])
        ->value(1)
        !!}
    </div>

    @if(sizeof($contas) > 0)
    <hr>
    @foreach($contas as $conta)
    <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-md-6">
                    <h5 class="text-primary">{{ $conta->cliente->info }}</h5>
                </div>
                <div class="col-md-6 text-end">
                    <h5>Valor <strong class="text-danger">R$ {{ __moeda($conta->valor_integral) }}</strong></h5>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <input type="hidden" name="conta_id[]" value="{{ $conta->id }}">
                <div class="col-md-2">
                    {!!Form::tel('numero[]', 'Número boleto')->required()
                    ->value($proximoNumero)
                    !!}
                </div>

                <div class="col-md-2">
                    {!!Form::tel('numero_documento[]', 'Número documento')->required()
                    ->value($proximoDocumento)
                    !!}
                </div>

                <div class="col-md-2">
                    {!!Form::tel('juros[]', 'Juros')->required()
                    ->attrs(['class' => 'moeda juros'])
                    !!}
                </div>
                <div class="col-md-2">
                    {!!Form::tel('juros_apos[]', 'Juros após (dias) ')->required()
                    ->attrs(['class' => 'juros_apos', 'data-mask' => '000'])
                    !!}
                </div>
                <div class="col-md-2">
                    {!!Form::tel('multa[]', 'Multa')->required()
                    ->attrs(['class' => 'moeda multa'])
                    !!}
                </div>

                <div class="col-md-2">
                    {!!Form::tel('valor[]', 'Valor')->required()
                    ->value(__moeda($conta->valor_integral))
                    ->attrs(['class' => 'moeda'])
                    !!}
                </div>
                <div class="col-md-2 mt-2">
                    {!!Form::date('vencimento[]', 'Vencimento')->required()
                    ->value($conta->data_vencimento)
                    !!}
                </div>

                <div class="col-md-5 mt-2">
                    {!!Form::textarea('instrucoes[]', 'Instruções')
                    ->attrs(['rows' => 4, 'style' => 'width: 100%;'])
                    !!}
                </div>

                <div class="col-md-2 mt-2 div-sicredi">
                    {!!Form::text('posto', 'Posto')->required()
                    ->attrs(['class' => 'posto'])
                    !!}
                </div>
            </div>
        </div>
    </div>
    @endforeach

    @else

    <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-md-6">
                    <h5>{{ $conta->cliente->info }}</h5>
                </div>
                <div class="col-md-6 text-end">
                    <h5>Valor <strong class="text-danger">R$ {{ __moeda($conta->valor_integral) }}</strong></h5>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <input type="hidden" name="conta_id[]" value="{{ $conta->id }}">
                <div class="col-md-2">
                    {!!Form::tel('numero[]', 'Número boleto')->required()
                    ->value($proximoNumero)
                    !!}
                </div>

                <div class="col-md-2">
                    {!!Form::tel('numero_documento[]', 'Número documento')->required()
                    ->value($proximoDocumento)
                    !!}
                </div>

                <div class="col-md-2">
                    {!!Form::tel('juros[]', 'Juros')->required()
                    ->attrs(['class' => 'moeda juros'])
                    !!}
                </div>
                <div class="col-md-2">
                    {!!Form::tel('juros_apos[]', 'Juros após (dias) ')->required()
                    ->attrs(['class' => 'juros_apos', 'data-mask' => '000'])
                    !!}
                </div>
                <div class="col-md-2">
                    {!!Form::tel('multa[]', 'Multa')->required()
                    ->attrs(['class' => 'moeda multa'])
                    !!}
                </div>

                <div class="col-md-2">
                    {!!Form::tel('valor[]', 'Valor')->required()
                    ->value(__moeda($conta->valor_integral))
                    ->attrs(['class' => 'moeda'])
                    !!}
                </div>
                <div class="col-md-2 mt-2">
                    {!!Form::date('vencimento[]', 'Vencimento')->required()
                    ->value($conta->data_vencimento)
                    !!}
                </div>

                <div class="col-md-5 mt-2">
                    {!!Form::textarea('instrucoes[]', 'Instruções')
                    ->attrs(['rows' => 4, 'style' => 'width: 100%;'])
                    !!}
                </div>

                <div class="col-md-2 mt-2 div-sicredi">
                    {!!Form::text('posto', 'Posto')->required()
                    ->attrs(['class' => 'posto'])
                    !!}
                </div>
            </div>
        </div>
    </div>
    @endif

    <hr class="mt-4">
    <div class="col-12" style="text-align: right;">
        <button type="submit" class="btn btn-success px-5" id="btn-store">Salvar</button>
    </div>
</div>

@section('js')
<script type="text/javascript">
    $(function(){
        setTimeout(() => {
            $('#inp-conta_boleto').change()
        })

        // Bloquear completamente os campos
        $('#inp-carteira, #inp-convenio').on('keydown paste input change', function(e) {
            e.preventDefault();
            return false;
        });

        $('#inp-tipo').on('mousedown keydown', function(e) {
            e.preventDefault();
            return false;
        });
    })

    $('body').on('change', '#inp-conta_boleto', function () {
        let conta_boleto = $(this).val()
        if(conta_boleto){
            $.get(path_url + 'api/conta-boleto', {conta_boleto_id: conta_boleto})
            .done((res) => {
                if(res.banco == 'Sicredi'){
                    $('.div-sicredi').removeClass('d-none')
                    $('.posto').attr('required', 1)
                    $('.posto').val(res.posto).prop('readonly', true);
                    $('#inp-carteira').val('1').prop('readonly', true);
                    $('#inp-convenio').val(res.convenio).prop('readonly', true);
                }else{
                    $('.div-sicredi').addClass('d-none')
                    $('.posto').removeAttr('required')
                    $('#inp-carteira').val(res.carteira).prop('readonly', true);
                    $('#inp-convenio').val(res.convenio).prop('readonly', true);
                }
                
                $('#inp-tipo').val(res.tipo).prop('disabled', true).change();
                $('#tipo_hidden').val(res.tipo);

                // Buscar configurações financeiras
                $.get(path_url + 'api/configuracoes-financeiras')
                .done((config) => {
                    $('.juros').val(convertFloatToMoeda(config.juros_diario))
                    $('.multa').val(convertFloatToMoeda(config.multa_atraso))
                    $('.juros_apos').val(config.carencia_dias)

                    // Formatar instruções com juros e multa
                    $('input[name="valor[]"]').each(function() {
                        let valor = convertMoedaToFloat($(this).val());
                        let instrucoes = '';
                        
                        if(config.multa_atraso > 0){
                            instrucoes += `APOS VENCIMENTO COBRAR MULTA DE ${config.multa_atraso} %.\n`;
                        }
                        
                        if(config.juros_diario > 0){
                            // Calcula o valor da mora diária
                            let valorMoraDiaria = (valor * (config.juros_diario/100));
                            instrucoes += `APOS VENCIMENTO COBRAR MORA DIARIA DE R$ ${convertFloatToMoeda(valorMoraDiaria)}.\n`;
                        }
                        
                        // Adicionar instruções padrões após juros e multa
                        if(config.instrucoes_padrao_boleto){
                            // Divide as instruções padrões por ponto e adiciona quebras de linha
                            let instrucoesArray = config.instrucoes_padrao_boleto.split('.');
                            instrucoesArray.forEach(instrucao => {
                                if(instrucao.trim()) {
                                    instrucoes += `${instrucao.trim()}.\n`;
                                }
                            });
                        }

                        // Remove quebras de linha extras no final
                        instrucoes = instrucoes.trim();

                        // Encontra o campo de instruções correspondente e define o valor
                        $(this).closest('.card-body').find('textarea[name^="instrucoes"]').val(instrucoes);
                    });
                })
                .fail((err) => {
                    console.log('Erro ao buscar configurações financeiras:', err)
                })
            })
            .fail((err) => {
                console.log(err)
            })
        }
    })

    // Função para converter string em moeda para float
    function convertMoedaToFloat(valor) {
        if (!valor) return 0;
        return parseFloat(valor.replace('R$', '').replace('.', '').replace(',', '.').trim());
    }
</script>
@endsection