@extends('layouts.app', ['title' => 'Relatório de Estoque'])

@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-12">
                    <h3>Relatório de Estoque</h3>
                    <a href="{{ route('produtos.index') }}" class="btn btn-secondary">
                        <i class="ri-arrow-left-line"></i>
                        Voltar
                    </a>
                    <a href="{{ route('produtos.relatorio-estoque-pdf') }}" class="btn btn-danger">
                        <i class="ri-file-pdf-line"></i>
                        Gerar PDF
                    </a>
                </div>

                <div class="col-md-12 mt-4">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="card bg-primary text-white">
                                <div class="card-body">
                                    <h4>Total de Itens Cadastrados</h4>
                                    <h2>{{ $totalItens }}</h2>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-info text-white">
                                <div class="card-body">
                                    <h4>Quantidade Total em Estoque</h4>
                                    <h2>{{ number_format($totalQuantidade, 2, ',', '.') }}</h2>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-success text-white">
                                <div class="card-body">
                                    <h4>Valor Total de Custo</h4>
                                    <h2>R$ {{ number_format($totalValorCompra, 2, ',', '.') }}</h2>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-warning text-white">
                                <div class="card-body">
                                    <h4>Valor Total de Venda</h4>
                                    <h2>R$ {{ number_format($totalValorVenda, 2, ',', '.') }}</h2>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-12 mt-4 table-responsive">
                    <h4>Lista de Produtos</h4>
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>Imagem</th>
                                    <th>Nome</th>
                                    <th>Código de Barras</th>
                                    <th>NCM</th>
                                    <th>Categoria</th>
                                    <th>Gerencia Estoque</th>
                                    <th>Estoque</th>
                                    <th>Valor de Compra</th>
                                    <th>Valor de Venda</th>
                                    <th>Total Compra</th>
                                    <th>Total Venda</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($produtos as $produto)
                                <tr>
                                    <td><img class="img-60" src="{{ $produto->img }}"></td>
                                    <td>{{ $produto->nome }}</td>
                                    <td>{{ $produto->codigo_barras }}</td>
                                    <td>{{ $produto->ncm }}</td>
                                    <td>{{ $produto->categoria ? $produto->categoria->nome : '-' }}</td>
                                    <td>
                                        @if($produto->gerenciar_estoque)
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        @else
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        @endif
                                    </td>
                                    <td>{{ number_format($produto->estoque ? $produto->estoque->quantidade : 0, 2, ',', '.') }}</td>
                                    <td>R$ {{ number_format($produto->valor_compra, 2, ',', '.') }}</td>
                                    <td>R$ {{ number_format($produto->valor_unitario, 2, ',', '.') }}</td>
                                    <td>R$ {{ number_format(($produto->estoque ? $produto->estoque->quantidade : 0) * $produto->valor_compra, 2, ',', '.') }}</td>
                                    <td>R$ {{ number_format(($produto->estoque ? $produto->estoque->quantidade : 0) * $produto->valor_unitario, 2, ',', '.') }}</td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="11" class="text-center">Nenhum produto encontrado</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 