@extends('layouts.app', ['title' => 'Novo Produto'])
@section('content')


<div class="card mt-1">
    <div class="card-header">
        <h4>Novo Produto</h4>
        <div style="text-align: right; margin-top: -35px;">
            <a href="{{ route('produtos.index') }}" class="btn btn-danger btn-sm px-3">
                <i class="ri-arrow-left-double-fill"></i>Voltar
            </a>
        </div>
    </div>
    <div class="card-body">
        {!!Form::open()
        ->post()
        ->id('form-produto')
        ->route('produtos.store')
        ->multipart()
        !!}

        <!-- Indicador de Progresso -->
        <div class="progress-indicator" id="progress-indicator" style="display: none;">
            <h6>Progresso do Preenchimento</h6>
            <div class="progress-bar">
                <div class="progress-fill" id="progress-fill" style="width: 0%"></div>
            </div>
            <small id="progress-text">0% completo</small>
        </div>

        <div class="pl-lg-4">
            @include('produtos._forms')
        </div>
        {!!Form::close()!!}
    </div>
</div>

@include('modals._marca')
@include('modals._categoria_produto')

@endsection
