<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('fatura_contas_recebers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('conta_receber_id')->constrained('conta_recebers')->onDelete('cascade');
            $table->foreignId('empresa_id')->constrained('empresas')->onDelete('cascade');
            $table->string('tipo_pagamento', 3)->comment('01-Dinheiro, 03-Cartão Crédito, etc...');
            $table->decimal('valor', 10, 2);
            $table->date('data_vencimento')->nullable();
            $table->string('obs', 100)->nullable();
            $table->timestamps();
            
            // Índices
            $table->index('conta_receber_id');
            $table->index('empresa_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('fatura_contas_recebers');
    }
};
