<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ContaReceberHistorico extends Model
{
    use HasFactory;

    protected $table = 'conta_receber_historicos';

    protected $fillable = [
        'conta_receber_id', 'valor', 'tipo_movimento', 'tipo_pagamento', 
        'data_movimento', 'usuario_id', 'observacao'
    ];

    /**
     * Relacionamento com a conta a receber
     */
    public function contaReceber()
    {
        return $this->belongsTo(ContaReceber::class, 'conta_receber_id');
    }

    /**
     * Relacionamento com o usuário
     */
    public function usuario()
    {
        return $this->belongsTo(User::class, 'usuario_id');
    }

    /**
     * Retorna uma descrição formatada do tipo de movimento
     */
    public function getTipoMovimentoFormatadoAttribute()
    {
        $tipos = [
            'recebimento_integral' => 'Recebimento Integral',
            'recebimento_parcial' => 'Recebimento Parcial',
            'reparcelamento' => 'Reparcelamento',
            'cancelamento' => 'Cancelamento',
            'ajuste' => 'Ajuste de Valor'
        ];

        return $tipos[$this->tipo_movimento] ?? $this->tipo_movimento;
    }
} 