<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConfiguracaoFinanceira extends Model
{
    use HasFactory;
    
    protected $table = 'configuracoes_financeiras';
    
    protected $fillable = [
        'empresa_id',
        'juros_diario',
        'multa_atraso',
        'carencia_dias',
        'prazo_padrao_dias',
        'notificar_vencimento',
        'dias_notificacao_previa',
        'texto_padrao_recibo',
        'instrucoes_padrao_boleto'
    ];
    
    // Relacionamento com empresa
    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }
} 