<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AlocacaoCentroCusto extends Model
{
    use HasFactory;

    protected $table = 'alocacao_centro_custos';

    protected $fillable = [
        'conta_pagar_id',
        'conta_receber_id',
        'centro_custo_id',
        'valor',
        'porcentagem',
        'observacao'
    ];

    public function contaPagar()
    {
        return $this->belongsTo(ContaPagar::class, 'conta_pagar_id');
    }
    
    public function contaReceber()
    {
        return $this->belongsTo(ContaReceber::class, 'conta_receber_id');
    }

    public function centroCusto()
    {
        return $this->belongsTo(CentroCusto::class, 'centro_custo_id');
    }
} 