<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Carbon\Carbon;

class EmpresasInativasNotificacao extends Mailable
{
    use Queueable, SerializesModels;

    public $empresasInativas;
    public $dataLimite;

    /**
     * Create a new message instance.
     *
     * @param array $empresasInativas
     * @param Carbon $dataLimite
     * @return void
     */
    public function __construct(array $empresasInativas, Carbon $dataLimite)
    {
        $this->empresasInativas = $empresasInativas;
        $this->dataLimite = $dataLimite;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('Alerta: Empresas Inativas - NGBPrime')
            ->markdown('emails.sistema.empresas-inativas')
            ->with([
                'empresasInativas' => $this->empresasInativas,
                'dataLimite' => $this->dataLimite->format('d/m/Y'),
                'dataAtual' => now()->format('d/m/Y H:i:s')
            ]);
    }
} 