<?php

namespace App\Http\Controllers;

use App\Models\ItemComanda;
use Illuminate\Http\Request;

class ItemComandaController extends Controller
{
    public function store(Request $request)
    {
        $data = $request->validate([
            // 'empresa_id' => 'required|exists:empresas,id',
            'mesa_comanda_id' => 'required|exists:mesa_comandas,id',
            'produto_id' => 'required|exists:produtos,id',
            'quantidade' => 'required|numeric|min:0.001',
            'valor_unitario' => 'required|numeric',
            'subtotal' => 'nullable|numeric',
        ]);
        // Garantir tipos numéricos
        $data['quantidade'] = (float) $data['quantidade'];
        $data['valor_unitario'] = (float) $data['valor_unitario'];
        $data['subtotal'] = $data['quantidade'] * $data['valor_unitario'];
        \Log::info('ItemComandaController@store', [
            'quantidade' => $data['quantidade'],
            'valor_unitario' => $data['valor_unitario'],
            'subtotal_calculado' => $data['subtotal'],
            'data' => $data
        ]);
        $item = ItemComanda::create($data);
        // Atualiza status e valor da mesa
        $mesa = \App\Models\MesaComanda::find($data['mesa_comanda_id']);
        if ($mesa) {
            $mesa->status = 'ocupada';
            $mesa->total = $mesa->itens()->sum('subtotal');
            $mesa->save();
        }
        return response()->json($item, 201);
    }

    public function update(Request $request, $id)
    {
        $item = ItemComanda::findOrFail($id);
        $data = $request->validate([
            'quantidade' => 'sometimes|numeric|min:0.001',
            'valor_unitario' => 'sometimes|numeric',
            'subtotal' => 'nullable|numeric',
        ]);
        // Garantir tipos numéricos
        $quantidade = isset($data['quantidade']) ? (float) $data['quantidade'] : $item->quantidade;
        $valor_unitario = isset($data['valor_unitario']) ? (float) $data['valor_unitario'] : $item->valor_unitario;
        $data['subtotal'] = $quantidade * $valor_unitario;
        \Log::info('ItemComandaController@update', [
            'quantidade' => $quantidade,
            'valor_unitario' => $valor_unitario,
            'subtotal_calculado' => $data['subtotal'],
            'data' => $data
        ]);
        $item->update($data);
        // Atualiza status e valor da mesa
        $mesa = $item->mesaComanda;
        if ($mesa) {
            $mesa->total = $mesa->itens()->sum('subtotal');
            $mesa->save();
        }
        return response()->json($item);
    }

    public function destroy($id)
    {
        $item = ItemComanda::findOrFail($id);
        $mesa = $item->mesaComanda;
        $item->delete();
        // Atualiza status e valor da mesa
        if ($mesa) {
            $total = $mesa->itens()->sum('subtotal');
            if ($mesa->itens()->count() == 0) {
                $mesa->status = 'livre';
                $mesa->total = 0;
            } else {
                $mesa->total = $total;
            }
            $mesa->save();
        }
        return response()->json(['message' => 'Item removido com sucesso.']);
    }

    public function finalizar(Request $request, $mesaComandaId)
    {
        $request->validate([
            'itens' => 'required|array|min:1',
            'itens.*.produto_id' => 'required|exists:produtos,id',
            'itens.*.quantidade' => 'required|numeric|min:0.001',
            'itens.*.valor_unitario' => 'required|numeric',
        ]);
        foreach ($request->itens as $item) {
            \App\Models\ItemComanda::create([
                'mesa_comanda_id' => $mesaComandaId,
                'produto_id' => $item['produto_id'],
                'quantidade' => (float) $item['quantidade'],
                'valor_unitario' => (float) $item['valor_unitario'],
                'subtotal' => (float) $item['quantidade'] * (float) $item['valor_unitario'],
            ]);
        }
        // Atualiza status e valor da mesa
        $mesa = \App\Models\MesaComanda::find($mesaComandaId);
        if ($mesa) {
            $mesa->status = 'ocupada';
            $mesa->total = $mesa->itens()->sum('subtotal');
            $mesa->save();
        }
        return response()->json(['redirect' => url('/pdv?comanda=' . $mesaComandaId)]);
    }
} 