<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Ordem de Serviço</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        }

        body {
            background: #fff;
            padding: 20px;
            color: #444;
            line-height: 1.4;
            font-size: 12px;
        }

        /* Cabeçalho */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 1px solid #edf2f7;
        }

        .header img {
            max-height: 50px;
            object-fit: contain;
        }

        .company-info {
            text-align: right;
        }

        .company-info h2 {
            color: #1a202c;
            font-size: 18px;
            font-weight: 500;
            margin-bottom: 4px;
        }

        .company-info p {
            color: #718096;
            font-size: 11px;
            line-height: 1.3;
        }

        /* Seções */
        .section {
            background: #fff;
            border: 1px solid #edf2f7;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 15px;
        }

        .section h3 {
            color: #2d3748;
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 10px;
            padding-bottom: 8px;
            border-bottom: 1px solid #edf2f7;
        }

        .info-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 10px;
            font-size: 11px;
        }

        .info-item {
            margin-bottom: 4px;
        }

        .info-label {
            color: #718096;
            margin-bottom: 2px;
        }

        .info-value {
            color: #2d3748;
            font-weight: 500;
        }

        /* Tabelas */
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 11px;
            margin-bottom: 8px;
        }

        th {
            background: #f7fafc;
            padding: 8px;
            text-align: left;
            font-weight: 500;
            color: #4a5568;
            border-bottom: 1px solid #edf2f7;
        }

        td {
            padding: 6px 8px;
            color: #2d3748;
            border-bottom: 1px solid #edf2f7;
        }

        tr:last-child td {
            border-bottom: none;
        }

        /* Totais */
        .totals {
            background: #f7fafc;
            border-radius: 8px;
            padding: 12px 15px;
            margin-top: 15px;
            font-size: 11px;
        }

        .total-row {
            display: flex;
            justify-content: space-between;
            padding: 4px 0;
            color: #4a5568;
        }

        .total-row.final {
            margin-top: 8px;
            padding-top: 8px;
            border-top: 1px solid #e2e8f0;
            font-size: 14px;
            font-weight: 600;
            color: #2d3748;
        }

        /* Descrição */
        .description {
            background: #fff;
            border: 1px solid #edf2f7;
            border-radius: 8px;
            padding: 12px;
            margin: 15px 0;
            font-size: 11px;
            color: #4a5568;
        }

        /* Rodapé */
        .footer {
            margin-top: 20px;
            padding-top: 10px;
            border-top: 1px solid #edf2f7;
            text-align: center;
            color: #a0aec0;
            font-size: 10px;
        }

        .footer p {
            margin: 2px 0;
        }

        /* Utilitários */
        .text-right { text-align: right; }
        .text-muted { color: #718096; }
        .font-medium { font-weight: 500; }
        
        @media print {
            body { padding: 10px; }
            .section { break-inside: avoid; }
            .page-break { page-break-after: always; }
        }
    </style>
</head>
<body>
    <!-- Cabeçalho -->
    <div class="header">
        <div class="logo">
            @if($config->logo != null)
                <img src="{{ public_path('/uploads/logos/'. $config->logo) }}" alt="Logo">
            @else
                <img src="{{ public_path('logo.png') }}" alt="Logo">
            @endif
        </div>
        <div class="company-info">
            <h2>{{ $config->nome }}</h2>
            <p>{{ $config->rua }}, {{ $config->numero }} - {{ $config->bairro }}</p>
            <p>{{ $config->cidade->nome }}/{{ $config->cidade->uf }} - {{ $config->cpf_cnpj }}</p>
        </div>
    </div>

    <!-- Informações do Cliente -->
    <div class="section">
        <h3>Informações do Cliente</h3>
        <div class="info-grid">
            <div class="info-item">
                <div class="info-label">Nome/Razão Social</div>
                <div class="info-value">{{ $ordem->cliente->razao_social }}</div>
            </div>
            <div class="info-item">
                <div class="info-label">{{ strlen($ordem->cliente->cpf_cnpj) > 14 ? 'CNPJ' : 'CPF' }}</div>
                <div class="info-value">{{ $ordem->cliente->cpf_cnpj }}</div>
            </div>
            <div class="info-item">
                <div class="info-label">Endereço</div>
                <div class="info-value">{{ $ordem->cliente->rua }}, {{ $ordem->cliente->numero }} - {{ $ordem->cliente->bairro }}</div>
            </div>
            <div class="info-item">
                <div class="info-label">Cidade/UF</div>
                <div class="info-value">{{ $ordem->cliente->cidade->nome }}/{{ $ordem->cliente->cidade->uf }}</div>
            </div>
            <div class="info-item">
                <div class="info-label">Telefone</div>
                <div class="info-value">{{ $ordem->cliente->telefone }}</div>
            </div>
            <div class="info-item">
                <div class="info-label">Nº OS</div>
                <div class="info-value">{{ $ordem->codigo_sequencial }}</div>
            </div>
        </div>
    </div>

    <!-- Descrição -->
    @if($ordem->descricao)
    <div class="description">
        <h3>Descrição</h3>
        {!! $ordem->descricao !!}
    </div>
    @endif

    <!-- Serviços -->
    <div class="section">
        <h3>Serviços</h3>
        <table>
            <thead>
                <tr>
                    <th style="width: 45%">Serviço</th>
                    <th style="width: 15%">Qtd</th>
                    <th style="width: 20%">Status</th>
                    <th style="width: 20%" class="text-right">Subtotal</th>
                </tr>
            </thead>
            <tbody>
                @forelse($ordem->servicos as $item)
                <tr>
                    <td>{{ $item->servico->nome }}</td>
                    <td>{{ $item->quantidade }}</td>
                    <td>{{ $item->status ? 'FINALIZADO' : 'PENDENTE' }}</td>
                    <td class="text-right">{{ number_format($item->subtotal, 2, ',', '.') }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="4" class="text-center">Nenhum serviço registrado</td>
                </tr>
                @endforelse
            </tbody>
            <tfoot>
                <tr style="font-weight: bold;">
                    <td colspan="3" class="text-right">Total Serviços</td>
                    <td class="text-right">{{ number_format($ordem->servicos->sum('subtotal'), 2, ',', '.') }}</td>
                </tr>
            </tfoot>
        </table>
    </div>

    <!-- Produtos -->
    <div class="section">
        <h3>Produtos</h3>
        <table>
            <thead>
                <tr>
                    <th style="width: 45%">Produto</th>
                    <th style="width: 15%">Qtd</th>
                    <th style="width: 20%">Valor Unit.</th>
                    <th style="width: 20%" class="text-right">Subtotal</th>
                </tr>
            </thead>
            <tbody>
                @forelse($ordem->itens as $item)
                <tr>
                    <td>{{ $item->produto->nome }}</td>
                    <td>{{ $item->quantidade }}</td>
                    <td>{{ number_format($item->produto->valor_unitario, 2, ',', '.') }}</td>
                    <td class="text-right">{{ number_format($item->subtotal, 2, ',', '.') }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="4" class="text-center">Nenhum produto registrado</td>
                </tr>
                @endforelse
            </tbody>
            <tfoot>
                <tr style="font-weight: bold;">
                    <td colspan="3" class="text-right">Total Produtos</td>
                    <td class="text-right">{{ number_format($ordem->itens->sum('subtotal'), 2, ',', '.') }}</td>
                </tr>
            </tfoot>
        </table>
    </div>

    <!-- Totais -->
    <div class="totals">
        <div class="total-row">
            <span>Total Serviços</span>
            <span>{{ number_format($ordem->servicos->sum('subtotal'), 2, ',', '.') }}</span>
        </div>
        <div class="total-row">
            <span>Total Produtos</span>
            <span>{{ number_format($ordem->itens->sum('subtotal'), 2, ',', '.') }}</span>
        </div>
        <div class="total-row final">
            <span>Total OS</span>
            <span>{{ number_format($ordem->valor, 2, ',', '.') }}</span>
        </div>
    </div>

    <!-- Relatórios -->
    @if($ordem->relatorios->count() > 0)
    <div class="section">
        <h3>Relatórios</h3>
        <table>
            <thead>
                <tr>
                    <th style="width: 20%">Data</th>
                    <th style="width: 80%">Texto</th>
                </tr>
            </thead>
            <tbody>
                @foreach($ordem->relatorios as $item)
                <tr>
                    <td>{{ \Carbon\Carbon::parse($item->created_at)->format('d/m/Y') }}</td>
                    <td>{{ $item->texto }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    @endif

    <!-- Rodapé -->
    <div class="footer">
        <p>Documento gerado em {{ date('d/m/Y H:i:s') }} - {{ $config->nome }}</p>
    </div>
</body>
</html>
