@extends('layouts.app', ['title' => 'Detalhes eNPS'])

@section('css')
<style>
    .card-feedback {
        border-left: 5px solid #0d6efd;
        transition: all 0.3s;
    }
    
    .card-feedback:hover {
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        transform: translateY(-3px);
    }
    
    .feedback-detrator {
        border-color: #dc3545;
    }
    
    .feedback-neutro {
        border-color: #ffc107;
    }
    
    .feedback-promotor {
        border-color: #198754;
    }
    
    .nota-badge {
        width: 40px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        border-radius: 50%;
        font-weight: bold;
        font-size: 18px;
        display: inline-block;
        margin-right: 10px;
    }
    
    .nota-badge-detrator {
        background-color: #dc3545;
        color: white;
    }
    
    .nota-badge-neutro {
        background-color: #ffc107;
        color: #343a40;
    }
    
    .nota-badge-promotor {
        background-color: #198754;
        color: white;
    }
    
    .feedback-quote {
        position: relative;
        padding-left: 20px;
        margin-top: 15px;
        color: #495057;
    }
    
    .feedback-quote:before {
        content: '"';
        font-size: 2.5rem;
        line-height: 0;
        position: absolute;
        top: 15px;
        left: 0;
        color: #adb5bd;
    }
</style>
@endsection

@section('content')
<div class="container my-4">
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Detalhes das Respostas eNPS</h5>
                    <div>
                        <a href="{{ route('nps.admin') }}" class="btn btn-sm btn-outline-secondary">
                            <i class="ri-arrow-left-line"></i> Voltar para o Painel
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Filtros -->
                    <form method="get" action="{{ route('nps.detalhes') }}" class="row g-3 mb-4">
                        <div class="col-md-3">
                            <label for="mes" class="form-label">Mês</label>
                            <select class="form-select" id="mes" name="mes" onchange="this.form.submit()">
                                @foreach($mesesDisponiveis as $value => $label)
                                    <option value="{{ $value }}" {{ $mes == $value ? 'selected' : '' }}>{{ $label }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label for="empresa_id" class="form-label">Empresa</label>
                            <select class="form-select" id="empresa_id" name="empresa_id" onchange="this.form.submit()">
                                <option value="">Todas as Empresas</option>
                                @foreach($empresas as $empresa)
                                    <option value="{{ $empresa->id }}" {{ $empresaId == $empresa->id ? 'selected' : '' }}>{{ $empresa->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="tipo" class="form-label">Tipo de Resposta</label>
                            <select class="form-select" id="tipo" name="tipo" onchange="this.form.submit()">
                                <option value="todos" {{ $tipoResposta == 'todos' ? 'selected' : '' }}>Todas</option>
                                <option value="detratores" {{ $tipoResposta == 'detratores' ? 'selected' : '' }}>Detratores (0-6)</option>
                                <option value="neutros" {{ $tipoResposta == 'neutros' ? 'selected' : '' }}>Neutros (7-8)</option>
                                <option value="promotores" {{ $tipoResposta == 'promotores' ? 'selected' : '' }}>Promotores (9-10)</option>
                            </select>
                        </div>
                        <div class="col-md-2 d-flex align-items-end">
                            <button type="submit" class="btn btn-primary w-100">
                                <i class="ri-filter-line"></i> Filtrar
                            </button>
                        </div>
                    </form>
                    
                    <!-- Resultados -->
                    <div class="row">
                        <div class="col-12">
                            @if($respostas->count() > 0)
                                <div class="mb-3">
                                    <h6>Total de respostas: <span class="badge bg-primary">{{ $respostas->count() }}</span></h6>
                                </div>
                                
                                <!-- Cards de feedback -->
                                <div class="row g-3">
                                    @foreach($respostas as $resposta)
                                        @php
                                            $classificacao = '';
                                            $badgeClass = '';
                                            
                                            if ($resposta->nota <= 6) {
                                                $classificacao = 'detrator';
                                                $badgeClass = 'nota-badge-detrator';
                                            } elseif ($resposta->nota <= 8) {
                                                $classificacao = 'neutro';
                                                $badgeClass = 'nota-badge-neutro';
                                            } else {
                                                $classificacao = 'promotor';
                                                $badgeClass = 'nota-badge-promotor';
                                            }
                                        @endphp
                                        
                                        <div class="col-md-6">
                                            <div class="card card-feedback feedback-{{ $classificacao }} h-100">
                                                <div class="card-body">
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <div>
                                                            <span class="nota-badge {{ $badgeClass }}">{{ $resposta->nota }}</span>
                                                            <span class="fw-bold">{{ $resposta->usuario->name ?? 'Usuário desconhecido' }}</span>
                                                        </div>
                                                        <small class="text-muted">{{ $resposta->created_at->format('d/m/Y H:i') }}</small>
                                                    </div>
                                                    
                                                    <div class="mt-2">
                                                        <small class="text-muted">Empresa: <span class="fw-bold">{{ $resposta->empresa->nome ?? 'Desconhecida' }}</span></small>
                                                    </div>
                                                    
                                                    @if($resposta->feedback)
                                                        <div class="feedback-quote">
                                                            {{ $resposta->feedback }}
                                                        </div>
                                                    @else
                                                        <div class="mt-3 text-muted fst-italic">
                                                            <small>Sem comentários adicionais</small>
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <div class="alert alert-info">
                                    <i class="ri-information-line"></i> Nenhuma resposta encontrada para os filtros selecionados.
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 