@extends('layouts.app', ['title' => 'Inventários'])
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-12 d-flex justify-content-between align-items-center mb-3">
                    <h4>Processo de Inventário</h4>
                    <a href="{{ route('processo-inventario.criar') }}" class="btn btn-primary">
                        <i class="ri-add-line"></i> Novo Inventário
                    </a>
                </div>
                <hr>
                
                @if(session('flash_success'))
                <div class="alert alert-success">
                    {{ session('flash_success') }}
                </div>
                @endif
                
                @if(session('flash_error'))
                <div class="alert alert-danger">
                    {{ session('flash_error') }}
                </div>
                @endif
                
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead class="table-light">
                            <tr>
                                <th>Nº</th>
                                <th>Referência</th>
                                <th>Tipo</th>
                                <th>Data Inicial</th>
                                <th>Data Final</th>
                                <th>Status</th>
                                <th width="180">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($inventarios as $inventario)
                            <tr>
                                <td>{{ $inventario->numero_sequencial }}</td>
                                <td>{{ $inventario->referencia }}</td>
                                <td>{{ \App\Models\Inventario::tipos()[$inventario->tipo] ?? 'Não definido' }}</td>
                                <td>{{ \Carbon\Carbon::parse($inventario->inicio)->format('d/m/Y') }}</td>
                                <td>{{ $inventario->fim ? \Carbon\Carbon::parse($inventario->fim)->format('d/m/Y') : 'Em andamento' }}</td>
                                <td>
                                    @if($inventario->status == 1)
                                        <span class="badge bg-success">Ativo</span>
                                    @elseif($inventario->status == 'ajustado')
                                        <span class="badge bg-warning">Ajustado</span>
                                    @elseif($inventario->status == 'finalizado')
                                        <span class="badge bg-primary">Finalizado</span>
                                    @else
                                        <span class="badge bg-secondary">Finalizado</span>
                                    @endif
                                </td>
                                <td>
                                    @if($inventario->status == 1 || $inventario->status == 'ajustado')
                                        <a href="{{ route('processo-inventario.selecionar', $inventario->id) }}" class="btn btn-sm btn-outline-primary" title="Selecionar Produtos">
                                            <i class="ri-checkbox-multiple-line"></i>
                                        </a>
                                        <a href="{{ route('processo-inventario.opcoes', $inventario->id) }}" class="btn btn-sm btn-outline-success" title="Opções de Contagem">
                                            <i class="ri-list-check"></i>
                                        </a>
                                        <a href="{{ route('processo-inventario.comparar', $inventario->id) }}" class="btn btn-sm btn-outline-danger" title="Analisar e Finalizar">
                                            <i class="ri-equalizer-line"></i>
                                        </a>
                                    @else
                                        <a href="{{ route('processo-inventario.print-relatorio', $inventario->id) }}" class="btn btn-sm btn-outline-info" title="Ver Relatório Final" target="_blank">
                                            <i class="ri-file-chart-line"></i>
                                        </a>
                                    @endif
                                    <a href="#" class="btn btn-sm btn-outline-danger" title="Excluir"
                                        onclick="if(confirm('Tem certeza que deseja excluir este inventário?')) { document.getElementById('form-delete-{{ $inventario->id }}').submit(); } return false;">
                                        <i class="ri-delete-bin-line"></i>
                                    </a>
                                    <form id="form-delete-{{ $inventario->id }}" action="{{ route('inventarios.destroy', $inventario->id) }}" method="POST" style="display: none;">
                                        @csrf
                                        @method('DELETE')
                                    </form>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="7" class="text-center">Nenhum inventário encontrado.</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                
                <div class="d-flex justify-content-center mt-3">
                    {{ $inventarios->links() }}
                </div>
                
                <!-- Opções de Configuração de Ordenação -->
                <div class="card mt-4 mb-4 border-primary">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="ri-list-order"></i> Configuração de Ordenação Padrão</h5>
                    </div>
                    <div class="card-body">
                        <p class="text-muted">
                            Defina como os produtos serão ordenados por padrão nas listagens de inventário.
                            @if(session('ordem_padrao'))
                                <span class="badge bg-info ms-2">
                                    Ordenação atual: 
                                    @if(session('ordem_padrao') == 'produtos.id')
                                        ID do Produto
                                    @elseif(session('ordem_padrao') == 'produtos.codigo_barras')
                                        Código de Barras
                                    @else
                                        Descrição (Nome)
                                    @endif
                                    ({{ session('direcao_ordem') == 'asc' ? 'Crescente' : 'Decrescente' }})
                                </span>
                            @endif
                        </p>
                        <form action="{{ route('processo-inventario.salvar-ordem') }}" method="POST" class="row align-items-end">
                            @csrf
                            <div class="col-md-6">
                                <label for="ordem_padrao" class="form-label">Ordenar produtos por:</label>
                                <select name="ordem_padrao" id="ordem_padrao" class="form-select">
                                    <option value="produtos.id" {{ session('ordem_padrao') == 'produtos.id' ? 'selected' : '' }}>ID do Produto</option>
                                    <option value="produtos.codigo_barras" {{ session('ordem_padrao') == 'produtos.codigo_barras' ? 'selected' : '' }}>Código de Barras</option>
                                    <option value="produtos.nome" {{ session('ordem_padrao') == 'produtos.nome' || !session('ordem_padrao') ? 'selected' : '' }}>Descrição (Nome)</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="direcao_ordem" class="form-label">Direção:</label>
                                <select name="direcao_ordem" id="direcao_ordem" class="form-select">
                                    <option value="asc" {{ session('direcao_ordem') == 'asc' || !session('direcao_ordem') ? 'selected' : '' }}>Crescente</option>
                                    <option value="desc" {{ session('direcao_ordem') == 'desc' ? 'selected' : '' }}>Decrescente</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="ri-save-line"></i> Salvar
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-md-6">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h5><i class="ri-information-line text-primary"></i> Sobre o Processo de Inventário</h5>
                                <p class="text-muted mt-3">
                                    O processo de inventário permite controlar o estoque através de contagens físicas dos produtos, 
                                    detectando diferenças e ajustando o sistema conforme necessário.
                                </p>
                                <p class="text-muted">
                                    <strong>Etapas do processo:</strong>
                                </p>
                                <ol class="text-muted">
                                    <li>Criar um novo inventário</li>
                                    <li>Selecionar os produtos a serem inventariados</li>
                                    <li>Imprimir a lista para contagem manual ou utilizar a planilha eletrônica</li>
                                    <li>Registrar as quantidades contadas no sistema</li>
                                    <li>Analisar divergências entre o estoque atual e a contagem</li>
                                    <li>Ajustar produtos selecionados ou finalizar o inventário completo</li>
                                    <li>Consultar o relatório final do inventário</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="card border-primary">
                            <div class="card-body">
                                <h5><i class="ri-lightbulb-line text-warning"></i> Dicas</h5>
                                <ul class="mt-3">
                                    <li>Realize inventários periódicos para manter seu estoque preciso</li>
                                    <li>Use a função de impressão para fazer contagens manuais em locais sem acesso ao computador</li>
                                    <li>A planilha Excel é ideal para grandes volumes de produtos</li>
                                    <li>Revise cuidadosamente as quantidades antes de ajustar o estoque</li>
                                    <li>Ao finalizar um inventário, o estoque será <strong>ZERADO</strong> e em seguida atualizado com as quantidades contadas</li>
                                    <li>A finalização do inventário é um processo <strong>irreversível</strong>, certifique-se que a contagem está correta</li>
                                    <li>O status "Ajustado" indica que alguns produtos foram ajustados individualmente, mas o inventário ainda pode ser finalizado</li>
                                    <li>Apenas inventários com status "Ativo" ou "Ajustado" podem ser editados</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 