@extends('front_box.default', ['title' => 'Nova Consignação'])
@section('content')

<style>
    /* Estilos específicos para consignação */
    .consignacao-header {
        background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
        color: white;
        padding: 1rem;
        border-radius: 8px;
        margin-bottom: 1rem;
    }
    
    .consignacao-header h4 {
        margin: 0;
        font-weight: 600;
    }
    
    .item-consignacao {
        background-color: #f8f9fa;
        border: 1px solid #dee2e6;
        border-radius: 6px;
        padding: 0.75rem;
        margin-bottom: 0.5rem;
    }
    
    .item-consignacao:hover {
        background-color: #e9ecef;
    }
    
    .btn-remove-item {
        color: #dc3545;
        border: none;
        background: none;
        padding: 0.25rem 0.5rem;
    }
    
    .btn-remove-item:hover {
        color: #c82333;
        background-color: #f8d7da;
        border-radius: 4px;
    }
    
    .total-consignacao {
        background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
        color: white;
        padding: 1rem;
        border-radius: 8px;
        text-align: center;
    }
    
    .total-consignacao h3 {
        margin: 0;
        font-weight: 700;
    }
</style>

{!! Form::open()->post()->route('consignacao.store')->id('form-consignacao') !!}
<input type="hidden" name="itens_json" id="itens_json">

@if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<div class="consignacao-header">
    <div class="row align-items-center">
        <div class="col-md-6">
            <h4><i class="ri-store-2-line me-2"></i>NOVA CONSIGNAÇÃO</h4>
        </div>
        <div class="col-md-6 text-end">
            <div class="small">
                <span class="me-3"><i class="ri-user-line me-1"></i>{{ Auth::user()->name }}</span>
                <span><i class="ri-calendar-event-line me-1"></i>{{ date('d/m/Y H:i') }}</span>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Coluna Esquerda - Dados da Consignação -->
    <div class="col-md-8">
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0"><i class="ri-user-settings-line me-2"></i>Dados da Consignação</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <label class="font-weight-bold">Cliente</label>
                        <div class="form-group">
                            <select class="form-control select2-cliente" name="cliente_id" id="cliente-select"
                                style="width: 100%;">
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        {!! Form::select('funcionario_id', 'Vendedor *', $funcionarios->pluck('nome', 'id'))->attrs(['class' => 'select2', 'required' => true]) !!}
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-md-6">
                        <label class="font-weight-bold">Data de Vencimento</label>
                        <input type="date" class="form-control" name="data_vencimento" id="data_vencimento" required>
                    </div>
                    <div class="col-md-6">
                        {!! Form::textarea('observacao', 'Observações')->attrs(['rows' => 3]) !!}
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
             <div class="card-header">
                <h5 class="mb-0"><i class="ri-list-check me-2"></i>Itens da Consignação</h5>
            </div>
            <div class="card-body">
                 <!-- Linha de Adição de Produto -->
                <div class="row align-items-end">
                    <div class="col-md-5">
                        <div class="form-group">
                            <label class="font-weight-bold">Produto</label>
                            <select class="form-control select2-prod" id="produto-select" style="width: 100%;"></select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="font-weight-bold">Quantidade</label>
                            <input type="number" class="form-control" id="quantidade" value="1" min="1">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="font-weight-bold">Valor Unitário</label>
                            <input type="text" class="form-control money" id="valor-unitario">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="font-weight-bold">Total</label>
                            <input type="text" class="form-control" id="subtotal-item" readonly>
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="form-group">
                            <button type="button" class="btn btn-primary btn-block" onclick="adicionarProdutoPeloSelect(event)">
                                <i class="fas fa-plus-circle"></i> Adicionar
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Tabela de Itens -->
                <div class="table-responsive mt-3">
                    <table class="table table-bordered table-striped">
                        <thead class="thead-light">
                            <tr>
                                <th>Produto</th>
                                <th>Qtd.</th>
                                <th>Valor Unit.</th>
                                <th>Subtotal</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody id="itens-consignacao">
                            {{-- Os itens serão adicionados aqui via JavaScript --}}
                        </tbody>
                    </table>
                </div>

                <div class="d-flex justify-content-end mt-3">
                    <h4>Total Geral: <span id="total-geral">R$ 0,00</span></h4>
                </div>
            </div>
        </div>
    </div>

    <!-- Coluna Direita - Total e Ações -->
    <div class="col-md-4">
        <div class="total-consignacao mb-3">
            <h6>TOTAL DA CONSIGNAÇÃO</h6>
            <h3 id="total-consignacao">R$ 0,00</h3>
        </div>

        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="ri-settings-3-line me-2"></i>Ações</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <button type="submit" class="btn btn-success btn-lg" id="btn-finalizar">
                        <i class="ri-check-line me-2"></i>
                        Finalizar Consignação
                    </button>
                    
                    <a href="{{ route('consignacao.index') }}" class="btn btn-secondary">
                        <i class="ri-arrow-left-line me-2"></i>
                        Voltar
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

{!! Form::close() !!}

<!-- Modal de Produtos -->
<div class="modal fade" id="modal-produtos" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Catálogo de Produtos</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row mb-3">
                    <div class="col-md-4">
                        <select id="filtro-categoria" class="form-select">
                            <option value="">Todas as categorias</option>
                            @foreach($categorias as $cat)
                                <option value="{{ $cat->id }}">{{ $cat->nome }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-4">
                        <select id="filtro-marca" class="form-select">
                            <option value="">Todas as marcas</option>
                            @if(isset($marcas))
                                @foreach($marcas as $marca)
                                    <option value="{{ $marca->id }}">{{ $marca->nome }}</option>
                                @endforeach
                            @endif
                        </select>
                    </div>
                    <div class="col-md-4">
                        <input type="text" id="filtro-produto" class="form-control" placeholder="Buscar produto...">
                    </div>
                </div>
                
                <div id="lista-produtos-modal" class="row">
                    <!-- Produtos serão carregados aqui -->
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('js')
    <script>
        $(function() {
            // Restaurar produtos do old('itens_json') se houver
            @if(old('itens_json'))
                try {
                    produtosAdicionados = JSON.parse('{!! old('itens_json') !!}');
                    atualizarTabela();
                    $('#itens_json').val('{!! old('itens_json') !!}');
                } catch (e) {
                    console.log('Erro ao restaurar produtos do old:', e);
                }
            @endif

            // Restaurar outros campos se disponíveis
            @if(old('cliente_id'))
                $('#cliente_id').val('{{ old("cliente_id") }}').trigger('change');
            @endif
            @if(old('funcionario_id'))
                $('#funcionario_id').val('{{ old("funcionario_id") }}').trigger('change');
            @endif
            @if(old('data_vencimento'))
                $('#data_vencimento').val('{{ old("data_vencimento") }}');
            @endif
            @if(old('observacao'))
                $('#observacao').val('{{ old("observacao") }}');
            @endif

            // Inicializa o Select2 para clientes
            $('.select2-cliente').select2({
                placeholder: 'Digite para buscar o cliente...',
                allowClear: true,
                minimumInputLength: 2,
                ajax: {
                    url: "{{ route('clientes.pesquisa') }}",
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            pesquisa: params.term, // term
                            empresa_id: "{{ request()->empresa_id }}"
                        };
                    },
                    processResults: function(data, params) {
                        return {
                            results: data.map(item => ({
                                id: item.id,
                                text: `${item.razao_social} (${item.cpf_cnpj})`
                            }))
                        };
                    },
                }
            });

            // Inicializa o Select2 para produtos
            $('.select2-prod').select2({
                placeholder: 'Digite para buscar o produto',
                minimumInputLength: 2,
                ajax: {
                    url: "{{ route('produtos.pesquisa') }}",
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            pesquisa: params.term, // Termo da busca
                            empresa_id: "{{ request()->empresa_id }}"
                        };
                    },
                    processResults: function(data) {
                        return {
                            results: data.map(function(produto) {
                                produto.text = produto.nome;
                                return produto;
                            })
                        };
                    },
                    cache: true
                }
            });

            // Evento para quando um produto é selecionado
            $('.select2-prod').on('select2:select', function(e) {
                var data = e.params.data;
                
                // Lógica corrigida para usar o campo 'valor_unitario'
                let valor = 0;
                if (data.valor_unitario && parseFloat(data.valor_unitario) > 0) {
                    valor = data.valor_unitario;
                }

                // Garante que o valor é um número e formata para 2 casas decimais
                $('#valor-unitario').val(parseFloat(valor).toFixed(2));
                $('#quantidade').focus();
            });

            // Formatar valor unitário ao sair do campo
            $('#valor-unitario').on('blur', function() {
                let val = $(this).val();
                // Troca apenas a vírgula por ponto
                val = val.replace(',', '.');
                if (val === '') return;
                let num = parseFloat(val);
                if (isNaN(num)) num = 0;
                // Exibe sempre com duas casas decimais, separador decimal vírgula
                $(this).val(num.toFixed(2).replace('.', ','));
            });

            // Validação de data de vencimento no submit
            $('#form-consignacao').on('submit', function(e) {
                const dataVencInput = $('#data_vencimento');
                let dataVenc = dataVencInput.val();
                
                // Se não há data de vencimento, não precisa validar
                if (!dataVenc || dataVenc.trim() === '') {
                    return true;
                }
                
                if (dataVenc && dataVenc.includes('/')) {
                    // dd/mm/yyyy → yyyy-mm-dd
                    const partes = dataVenc.split('/');
                    if (partes.length === 3) {
                        dataVenc = `${partes[2]}-${partes[1]}-${partes[0]}`;
                        dataVencInput.val(dataVenc);
                    }
                }
                
                let dataVencDate;
                if (dataVenc && dataVenc.includes('-')) {
                    // yyyy-mm-dd
                    dataVencDate = new Date(dataVenc + 'T00:00:00');
                } else if (dataVenc && dataVenc.includes('/')) {
                    // dd/mm/yyyy
                    const partes = dataVenc.split('/');
                    if (partes.length === 3) {
                        dataVencDate = new Date(`${partes[2]}-${partes[1]}-${partes[0]}T00:00:00`);
                    }
                }
                
                // Verifica se conseguiu criar uma data válida
                if (!dataVencDate || isNaN(dataVencDate.getTime())) {
                    toastr.error('Data de vencimento inválida!');
                    e.preventDefault();
                    return false;
                }
                
                const hoje = new Date();
                hoje.setHours(0,0,0,0);
                if (dataVencDate < hoje) {
                    toastr.error('A data de vencimento não pode ser anterior à data atual!');
                    e.preventDefault();
                    return false;
                }
            });

            // Definir data de vencimento para hoje por padrão ou converter para yyyy-mm-dd se vier de old()
            let dataAtualInput = $('#data_vencimento').val();
            if (!dataAtualInput) {
                // Se não houver valor, define hoje
                const hoje = new Date();
                const dia = String(hoje.getDate()).padStart(2, '0');
                const mes = String(hoje.getMonth() + 1).padStart(2, '0');
                const ano = hoje.getFullYear();
                const dataDeHoje = `${ano}-${mes}-${dia}`;
                $('#data_vencimento').val(dataDeHoje);
            } else {
                // Se vier preenchido (ex: old), converter para yyyy-mm-dd se necessário
                if (dataAtualInput.includes('/')) {
                    // dd/mm/yyyy para yyyy-mm-dd
                    const partes = dataAtualInput.split('/');
                    if (partes.length === 3) {
                        const dataFormatada = `${partes[2]}-${partes[1]}-${partes[0]}`;
                        $('#data_vencimento').val(dataFormatada);
                    }
                }
            }

            // Atualizar subtotal do item ao alterar quantidade ou valor unitário
            function atualizarSubtotalInput() {
                let qtd = parseFloat($('#quantidade').val().replace(',', '.'));
                let unit = parseFloat($('#valor-unitario').val().replace(',', '.'));
                if (isNaN(qtd) || qtd < 0) qtd = 0;
                if (isNaN(unit) || unit < 0) unit = 0;
                let subtotal = qtd * unit;
                $('#subtotal-item').val('R$ ' + formatarMoeda(subtotal));
            }
            $('#quantidade, #valor-unitario').on('input blur', atualizarSubtotalInput);
            // Atualiza ao selecionar produto também
            $('.select2-prod').on('select2:select', atualizarSubtotalInput);
            // Inicializa o valor ao carregar
            atualizarSubtotalInput();
        });

        // Função para adicionar produto selecionado pelo Select2
        function adicionarProdutoPeloSelect(event) {
            if (event) event.preventDefault();
            var produtoSelecionado = $('.select2-prod').select2('data')[0];
            if (!produtoSelecionado || !produtoSelecionado.id) {
                toastr.warning('Selecione um produto!');
                return;
            }
            adicionarProduto(produtoSelecionado);
        }

        // Lista de produtos em memória
        let produtosAdicionados = [];

        // Função para adicionar um produto à lista
        function adicionarProduto(produto) {
            const quantidade = parseFloat($('#quantidade').val().replace(',', '.'));
            const valorUnitario = parseFloat($('#valor-unitario').val().replace(',', '.'));

            if (isNaN(quantidade) || quantidade <= 0) {
                toastr.warning('Informe uma quantidade válida.');
                $('#quantidade').focus();
                return;
            }

            if (isNaN(valorUnitario) || valorUnitario < 0) {
                toastr.warning('Informe um valor unitário válido.');
                $('#valor-unitario').focus();
                return;
            }

            const produtoExistente = produtosAdicionados.find(p => p.id === produto.id);

            if (!produtoExistente) {
                const subtotal = quantidade * valorUnitario;
                produtosAdicionados.push({
                    produto_id: produto.id,
                    nome: produto.nome,
                    quantidade: quantidade,
                    valor_unitario: valorUnitario,
                    subtotal: subtotal
                });
                atualizarTabela();

                // Limpa os campos para a próxima adição
                $('.select2-prod').val(null).trigger('change');
                $('#quantidade').val(1);
                $('#valor-unitario').val('');
                $('#subtotal-item').val('R$ 0,00');
                // Fecha o Select2
                $('#produto-select').select2('close');

            } else {
                toastr.info('Produto já está na lista. Para alterar, remova-o e adicione novamente.');
            }
        }

        function atualizarTabela() {
            let total = 0;
            const tbody = $('#itens-consignacao');
            tbody.empty();

            produtosAdicionados.forEach((item, index) => {
                const newRow = `
                    <tr class="line-product">
                        <td style="width: 40%">
                            <input readonly type="text" class="form-control" value="${item.nome}">
                        </td>
                        <td style="width: 12%">
                            <input type="tel" readonly class="form-control qtd text-center" style="max-width: 70px;" value="${item.quantidade.toLocaleString('pt-BR', {minimumFractionDigits: 3})}">
                        </td>
                        <td style="width: 16%">
                            <input readonly type="tel" class="form-control value-unit text-end" value="R$ ${formatarMoeda(item.valor_unitario)}">
                        </td>
                        <td style="width: 16%">
                            <input readonly type="tel" class="form-control subtotal-item text-end" value="R$ ${formatarMoeda(item.subtotal)}">
                        </td>
                        <td class="text-center" style="width: 8%">
                            <button type="button" class="btn btn-danger btn-sm" onclick="removerProduto(${index})"><i class="ri-delete-bin-line"></i></button>
                        </td>
                    </tr>
                `;
                tbody.append(newRow);
                total += item.subtotal;
            });

            $('#total-geral').text(`R$ ${formatarMoeda(total)}`);
            $('#valor_total').val(total.toFixed(2));
            $('#itens_json').val(JSON.stringify(produtosAdicionados));
            // Atualiza o card verde do total
            $('#total-consignacao').text(`R$ ${formatarMoeda(total)}`);
        }

        function atualizarSubtotal(element, index) {
            let novaQtd = parseFloat($(element).val().replace(',', '.'));
            if (isNaN(novaQtd) || novaQtd < 0) {
                novaQtd = 0;
            }
            let item = produtosAdicionados[index];
            item.quantidade = novaQtd;
            item.subtotal = item.quantidade * item.valor_unitario;
            atualizarTabela();
        }

        // Função para alterar quantidade
        function alterarQuantidade(index, delta) {
            let item = produtosAdicionados[index];
            let novaQtd = parseFloat(item.quantidade) + delta;
            if (novaQtd < 0.001) novaQtd = 0.001; 
            item.quantidade = novaQtd;
            item.subtotal = item.quantidade * item.valor_unitario;
            atualizarTabela();
        }

        function removerProduto(index) {
            produtosAdicionados.splice(index, 1);
            atualizarTabela();
        }

        // Função para formatar moeda no padrão brasileiro
        function formatarMoeda(valor) {
            return Number(valor).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
        }
    </script>
@endsection 