<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMesaComandasTable extends Migration
{
    public function up()
    {
        Schema::create('mesa_comandas', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('empresa_id');
            $table->integer('numero')->unique();
            $table->enum('status', ['livre', 'ocupada'])->default('livre');
            $table->string('nome_cliente')->nullable();
            $table->decimal('valor_total', 10, 2)->nullable();
            $table->timestamp('abertura')->nullable();
            $table->timestamp('fechamento')->nullable();
            $table->timestamps();

            $table->foreign('empresa_id')->references('id')->on('empresas');
        });
    }

    public function down()
    {
        Schema::dropIfExists('mesa_comandas');
    }
} 