<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Doctrine\DBAL\Schema\AbstractSchemaManager;
use Doctrine\DBAL\Schema\Table;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Vamos simplificar a abordagem e verificar se a tabela já tem as colunas necessárias
        // e apenas adicionar as colunas sem tentar adicionar as chaves estrangeiras
        Schema::table('conta_receber_historicos', function (Blueprint $table) {
            if (!Schema::hasColumn('conta_receber_historicos', 'conta_receber_id')) {
                $table->unsignedBigInteger('conta_receber_id')->after('id');
            }
            
            if (!Schema::hasColumn('conta_receber_historicos', 'usuario_id')) {
                $table->unsignedBigInteger('usuario_id')->nullable()->after('data_movimento');
            }
            
            // Não vamos adicionar chaves estrangeiras nesta migração, pois elas já foram
            // adicionadas na migração que criou a tabela
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Não fazemos nada aqui para evitar remover chaves que podem
        // ter sido adicionadas por outra migração
    }
};
