<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddStatusToItemNfces extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('item_nfces', function (Blueprint $table) {
            $table->tinyInteger('status')->default(0)->comment('0=Normal, 1=Devolvido, 2=Trocado');
            $table->decimal('quantidade_devolvida', 10, 3)->default(0);
            $table->foreignId('item_substituto_id')->nullable()->comment('ID do item que substituiu este em caso de troca');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('item_nfces', function (Blueprint $table) {
            $table->dropColumn('status');
            $table->dropColumn('quantidade_devolvida');
            $table->dropColumn('item_substituto_id');
        });
    }
} 