<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Revenda extends Model
{
    use HasFactory;
    
    protected $fillable = [
        'nome',
        'cpf_cnpj',
        'nome_fantasia',
        'ie',
        'endereco',
        'numero',
        'bairro',
        'cidade_id',
        'cep',
        'telefone',
        'celular',
        'email',
        'observacao',
        'status'
    ];
    
    public function cidade()
    {
        return $this->belongsTo(Cidade::class);
    }
    
    public function planoEmpresas()
    {
        return $this->hasMany(PlanoEmpresa::class);
    }
    
    public function financeiroPlanos()
    {
        return $this->hasMany(FinanceiroPlano::class);
    }
} 