<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MenuAccessLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'usuario_id',
        'empresa_id',
        'rota',
        'menu',
        'submenu',
        'url',
        'ip',
        'user_agent'
    ];

    public function usuario()
    {
        return $this->belongsTo(User::class, 'usuario_id');
    }

    public function empresa()
    {
        return $this->belongsTo(Empresa::class, 'empresa_id');
    }
}
