<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class TentativasLoginNotificacao extends Mailable
{
    use Queueable, SerializesModels;

    public $dados;

    /**
     * Create a new message instance.
     *
     * @param array $dados
     * @return void
     */
    public function __construct(array $dados)
    {
        $this->dados = $dados;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('ALERTA DE SEGURANÇA: Tentativas de Login Suspeitas - NGBPrime')
            ->markdown('emails.sistema.tentativas-login')
            ->with([
                'dados' => $this->dados
            ]);
    }
} 