@extends('relatorios.default', ['title' => 'Relatório de Contas a Receber'])

@section('css')
<style type="text/css">
    .summary-container {
        display: flex;
        flex-wrap: nowrap;
        justify-content: space-between;
        gap: 6px;
        width: 100%;
        margin-bottom: 10px;
    }

    .summary-box {
        flex: 1 1 0;
        background-color: #f9fbfc;
        border-left: 4px solid #ccc;
        border-radius: 4px;
        padding: 6px 8px;
        font-size: 8px;
        text-align: center;
        box-shadow: 0 1px 2px rgba(0,0,0,0.05);
        min-width: 0; /* força ajuste automático */
    }

    .summary-box.recebido { border-left-color: #28a745; }
    .summary-box.areceber { border-left-color: #3366cc; }
    .summary-box.vencido { border-left-color: #dc3545; }

    .summary-title {
        font-weight: bold;
        color: #333;
        margin-bottom: 4px;
        text-transform: uppercase;
        font-size: 8px;
    }

    .summary-value {
        font-size: 10px;
        font-weight: bold;
    }

    .summary-box.recebido .summary-value { color: #28a745; }
    .summary-box.areceber .summary-value { color: #3366cc; }
    .summary-box.vencido .summary-value { color: #dc3545; }

    .accounts-table {
        width: 100%;
        border-collapse: collapse;
        font-size: 8px;
    }

    .accounts-table th, .accounts-table td {
        padding: 3px 5px;
        border: 1px solid #ddd;
    }

    .accounts-table th {
        background-color: #f1f1f1;
        font-weight: bold;
        color: #2c3e50;
        text-transform: uppercase;
    }

    .accounts-table tr:nth-child(even) {
        background-color: #fbfbfb;
    }

    .status-badge {
        display: inline-block;
        padding: 2px 5px;
        font-size: 7px;
        font-weight: bold;
        border-radius: 3px;
        white-space: nowrap;
    }

    .status-pending {
        background-color: #fff3cd;
        color: #856404;
    }

    .status-received {
        background-color: #d4edda;
        color: #155724;
    }

    .status-reparcelado {
        background-color: #d1ecf1;
        color: #0c5460;
    }

    .location-name {
        font-size: 7px;
        color: #3366cc;
        background-color: #e9f2ff;
        padding: 1px 5px;
        border-radius: 2px;
    }

    .text-right { text-align: right; }
    .text-center { text-align: center; }
</style>
@endsection

@section('content')

@php
    $totalRecebido = $data->where('status', '>', 0)->where('status', '!=', 3)->sum('valor_integral');
    $totalAReceber = $data->where('status', 0)->sum('valor_integral');
    $totalVencidas = $data->where('status', 0)->where('data_vencimento', '<', date('Y-m-d'))->sum('valor_integral');
@endphp

<div class="summary-container">
    <div class="summary-box recebido">
        <div class="summary-title">Recebido</div>
        <div class="summary-value">{{ __moeda($totalRecebido) }}</div>
    </div>

    <div class="summary-box areceber">
        <div class="summary-title">A Receber</div>
        <div class="summary-value">{{ __moeda($totalAReceber) }}</div>
    </div>

    <div class="summary-box vencido">
        <div class="summary-title">Vencidas</div>
        <div class="summary-value">{{ __moeda($totalVencidas) }}</div>
    </div>
</div>

<table class="accounts-table">
    <thead>
        <tr>
            <th style="width: 32%">Cliente</th>
            <th style="width: 15%" class="text-right">Valor</th>
            <th style="width: 15%" class="text-center">Vencimento</th>
            <th style="width: 12%" class="text-center">Status</th>
            @if(__countLocalAtivo() > 1)
            <th style="width: 12%">Local</th>
            @endif
        </tr>
    </thead>
    <tbody>
        @foreach($data as $item)
        <tr>
            <td>{{ $item->cliente?->razao_social ?? 'Cliente não identificado' }}</td>
            <td class="text-right">{{ __moeda($item->valor_integral) }}</td>
            <td class="text-center">{{ __data_pt($item->data_vencimento, 0) }}</td>
            <td class="text-center">
                @switch($item->status)
                    @case(0)
                        <span class="status-badge status-pending">Pendente</span>
                        @break
                    @case(3)
                        <span class="status-badge status-reparcelado">Reparcelada</span>
                        @break
                    @default
                        <span class="status-badge status-received">Recebido</span>
                @endswitch
            </td>
            @if(__countLocalAtivo() > 1)
            <td><span class="location-name">{{ $item->localizacao->descricao }}</span></td>
            @endif
        </tr>
        @endforeach
    </tbody>
</table>

@endsection
