@extends('layouts.app', ['title' => 'Lista de Pré Vendas'])
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body" style="padding-bottom: 80px;">
                <div class="col-md-2">
                    @can('pre_venda_create')
                    <a href="{{ route('pre-venda.create') }}" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i>
                        Nova Pré venda
                    </a>
                    @endcan
                </div>
                <hr>
                {!!Form::open()->fill(request()->all())->get()!!}
                <div class="row">
                    <div class="col-md-4">
                        {!!Form::select('cliente_id', 'Pesquisar por nome')->attrs(['class' => 'select2'])!!}
                    </div>
                    <div class="col-md-2">
                        {!!Form::text('codigo', 'Pesquisar por código')!!}
                    </div>
                    <div class="col-md-2">
                        {!!Form::date('start_date', 'Data inicial')!!}
                    </div>
                    <div class="col-md-2">
                        {!!Form::date('end_date', 'Data final')!!}
                    </div>
                    <div class="col-md-2">
                        {!!Form::select('status', 'Estado', ['1' => 'Não recebidas', '-1' => 'Recebidas'])->attrs(['class' => 'form-select'])!!}
                    </div>
                    @if(__countLocalAtivo() > 1)
                    <div class="col-md-2">
                        {!!Form::select('local_id', 'Local', ['' => 'Selecione'] + __getLocaisAtivoUsuario()->pluck('descricao', 'id')->all())->attrs(['class' => 'select2'])!!}
                    </div>
                    @endif
                    <div class="col-md-3 text-left ">
                        <br>
                        <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                        <a id="clear-filter" class="btn btn-danger" href="{{ route('pre-venda.index') }}"><i class="ri-eraser-fill"></i>Limpar</a>
                    </div>
                </div>
                {!! Form::close() !!}
                <div class="col-12 mt-3">
                    <div class="table-responsive" style="min-height: 400px;">
                        <table class="table table-striped table-centered mb-0 w-100">
                            <thead class="table-dark">
                                <tr>
                                    <th>Código</th>
                                    <th>Cliente</th>
                                    @if(__countLocalAtivo() > 1)
                                    <th>Local</th>
                                    @endif
                                    <th>Data</th>
                                    <th>Valor</th>
                                    <th>Status</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($data as $item)
                                <tr @can('nfce_create') ondblclick="finalizar('{{$item->id}}')" @endcan>
                                    <td width="200">{{ $item->codigo }}</td>
                                    <td width="600">{{ $item->cliente_id ? $item->cliente->razao_social : 'Consumidor Final' }}</td>
                                    @if(__countLocalAtivo() > 1)
                                    <td class="text-danger">{{ $item->localizacao->descricao }}</td>
                                    @endif
                                    <td width="200">{{ __data_pt($item->created_at) }}</td>
                                    <td width="200">{{ __moeda($item->valor_total) }}</td>
                                    <td width="150">
                                        @if($item->status == false)
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        @else
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        @endif
                                    </td>
                                    <td style="width: 320px">
                                        <form action="{{ route('pre-venda.destroy', $item->id) }}" method="post" id="form-{{$item->id}}">
                                            @method('delete')
                                            @csrf
                                            
                                            {{-- Botão de impressão da pré-venda (sempre disponível) --}}
                                            <a class="btn btn-info btn-sm" title="Reimprimir Pré-Venda" target="_blank" href="{{ route('pre-venda.imprimir', $item->codigo) }}">
                                                <i class="ri-printer-line"></i>
                                            </a>
                                            
                                            @if($item->status == 1)
                                            @can('pre_venda_delete')
                                            <button type="button" class="btn btn-delete-prevenda btn-sm btn-danger" title="Excluir Pré-Venda">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                            @endcan
                                            @can('nfce_create')
                                            <button type="button" class="btn btn-dark btn-sm" title="Finalizar" onclick="finalizar('{{$item->id}}')">
                                                <i class="ri-coins-fill"></i>
                                            </button>
                                            @endcan
                                            @endif
                                            
                                            @if($item->status == 0 && $item->venda_id != null && $item->tipo_finalizado == 'nfe')
                                            <a type="button" class="btn btn-light info btn-sm" title="Ver NFe" href="{{ route('nfe.show', $item->venda_id) }}">
                                                <i class="ri-eye-line"></i>
                                            </a>
                                            <a class="btn btn-primary btn-sm" title="Imprimir NFe" target="_blank" href="{{ route('nfe.imprimir', [$item->venda_id]) }}">
                                                <i class="ri-printer-line"></i>
                                            </a>
                                            @endif
                                            
                                            @if($item->status == 0 && $item->venda_id != null && $item->tipo_finalizado == 'nfce')
                                            <a type="button" class="btn btn-light info btn-sm" title="Ver NFCe" href="{{ route('nfce.show', $item->venda_id) }}">
                                                <i class="ri-eye-line"></i>
                                            </a>
                                            <a class="btn btn-success btn-sm" title="Imprimir Cupom" target="_blank" href="{{ route('frontbox.imprimir-nao-fiscal', [$item->venda_id]) }}">
                                                <i class="ri-printer-line"></i>
                                            </a>
                                            @if($item->nfce && $item->nfce->estado == 'aprovado')
                                            <a class="btn btn-primary btn-sm" title="Imprimir NFCe" target="_blank" href="{{ route('nfce.imprimir', [$item->venda_id]) }}">
                                                <i class="ri-printer-line"></i>
                                            </a>
                                            @endif
                                            @endif
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <br>
                    {!! $data->appends(request()->all())->links() !!}
                </div>
            </div>
        </div>
    </div>
</div>
@include('modals._finalizar_pre_venda', ['not_submit' => true])
@endsection

@push('css')
<style>
    @media (max-width: 768px) {
        .table th, .table td {
            white-space: nowrap;
        }
        .btn-sm {
            font-size: 0.75rem;
        }
    }
    .dropdown-menu {
        position: absolute !important;
        z-index: 1050;
        max-height: 300px;
        overflow-y: auto;
    }
    .table-responsive {
        min-height: 600px;
    }
    .card-body {
        padding-bottom: 80px;
    }
    .btn-sm.py-0.px-1 {
        font-size: 0.75rem;
        display: inline-block;
        min-width: 80px;
        text-align: center;
        margin: 0 auto;
        border-radius: 3px;
        font-weight: 500;
    }
    .row.g-2 > [class^='col-'] {
        margin-bottom: 8px;
    }
    .row.g-2 {
        gap: 8px 0;
    }
    .card-destaque {
        box-shadow: 0 2px 8px rgba(0,0,0,0.08), 0 0px 0px rgba(0,0,0,0.01);
        border: 1.5px solid #e0e0e0;
        border-radius: 10px;
        transition: box-shadow 0.2s;
        background: #fff;
        color: #222;
    }
    .card-destaque:hover {
        box-shadow: 0 4px 16px rgba(0,0,0,0.13);
        border-color: #bdbdbd;
    }
    .card-destaque h4, .card-destaque h6 { color: inherit; }
    .card-recebimentos {
        background: #43a047 !important;
        border-color: #388e3c !important;
        color: #fff !important;
    }
    .card-recebimentos i { color: #fff !important; }
    .card-descontos {
        background: #1976d2 !important;
        border-color: #1565c0 !important;
        color: #fff !important;
    }
    .card-descontos i { color: #fff !important; }
    .card-trocos {
        background: #fbc02d !important;
        border-color: #f9a825 !important;
        color: #fff !important;
    }
    .card-trocos i { color: #fff !important; }
    .card-cancelamentos {
        background: #c62828 !important;
        border-color: #b71c1c !important;
        color: #fff !important;
    }
    .card-cancelamentos i { color: #fff !important; }
    .card-valores {
        background: #6a1b9a !important;
        border-color: #45277a !important;
        color: #fff !important;
    }
    .card-valores i { color: #fff !important; }
    
    /* Estilos para os botões de ação */
    .btn-sm {
        margin: 1px;
        min-width: 32px;
        height: 32px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }
    
    .btn-info.btn-sm {
        background-color: #17a2b8;
        border-color: #17a2b8;
    }
    
    .btn-info.btn-sm:hover {
        background-color: #138496;
        border-color: #117a8b;
    }
    
    /* Tooltip personalizado para os botões */
    [title] {
        position: relative;
    }
    
    /* Responsividade para os botões */
    @media (max-width: 768px) {
        .btn-sm {
            min-width: 28px;
            height: 28px;
            font-size: 0.7rem;
        }
    }
</style>
@endpush

@section('js')
<script src="/js/pre_venda.js"></script>
@endsection


