<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>OP {{ $op->numero }}</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #000; padding: 6px; }
        th { background: #f0f0f0; }
        .text-end { text-align: right; }
        .mb-10 { margin-bottom: 10px; }
    </style>
</head>
<body>
    <table style="border:0; margin-bottom: 8px;">
        <tr>
            <td style="border:0; width: 70%; vertical-align: middle;">
                <div style="display:flex; align-items:center;">
                    @php
                        use Illuminate\Support\Str;
                        use Illuminate\Support\Facades\File;
                        $img = $empresa?->img;
                        $logo = public_path('/imgs/no-image.png');
                        if ($img) {
                            if (Str::startsWith($img, ['http://', 'https://'])) {
                                $logo = $img; // remote URL (requires isRemoteEnabled)
                            } else {
                                $candidate = public_path($img);
                                $logo = File::exists($candidate) ? $candidate : public_path('/imgs/no-image.png');
                            }
                        }
                    @endphp
                    <img src="{{ $logo }}" alt="Logo" style="height:50px; width:auto; border-radius:4px; margin-right:10px;">
                    <div>
                        <div style="font-weight:700; font-size:16px;">{{ $empresa?->nome_fantasia ?? $empresa?->nome }}</div>
                        <div style="font-size:11px; color:#444;">CNPJ: {{ $empresa?->cpf_cnpj }} • IE: {{ $empresa?->ie }}</div>
                        <div style="font-size:11px; color:#444;">{{ $empresa?->rua }} {{ $empresa?->numero }}, {{ $empresa?->bairro }} • CEP: {{ $empresa?->cep }}</div>
                    </div>
                </div>
            </td>
            <td style="border:0; width: 30%; text-align: right;">
                <div style="font-size:22px; font-weight:700;">OP: {{ $op->numero }}</div>
                <div style="font-size:11px; color:#555;">Data: {{ $op->data_producao ? __data_pt($op->data_producao, 0) : '-' }}</div>
            </td>
        </tr>
    </table>
    <br><br>
    <h3 style="margin: 6px 0 10px 0;">Ordem de Produção</h3>
    <table class="mb-10">
        <tr>
            <th style="width:20%">Situação</th>
            <td>{{ $op->situacao === 'finalizado' ? 'Finalizado' : 'Em Produção' }}</td>
            <th style="width:20%">Data Produção</th>
            <td>{{ $op->data_producao ? __data_pt($op->data_producao, 0) : '-' }}</td>
        </tr>
        <tr>
            <th>Previsão Entrega</th>
            <td>{{ $op->data_prevista_entrega ? __data_pt($op->data_prevista_entrega, 0) : '-' }}</td>
            <th>Cliente/Destinatário</th>
            <td>{{ optional($op->cliente)->nome_fantasia ?? optional($op->cliente)->razao_social ?? '-' }}</td>
        </tr>
        <tr>
            <th>Usuário responsável</th>
            <td>{{ optional($op->creator)->name ?? '-' }}</td>
            <th>Finalizado por</th>
            <td>{{ optional($op->finisher)->name ?? '-' }} @if($op->finished_at) em {{ __data_pt($op->finished_at) }} @endif</td>
        </tr>
    </table>

    <div class="mb-10">
        <strong>Observação:</strong>
        <div>{{ $op->observacao }}</div>
    </div>

    <table>
        <thead>
            <tr>
                <th style="width: 60%">Produto</th>
                <th style="width: 10%">UN</th>
                <th style="width: 15%" class="text-end">Quantidade</th>
                <th style="width: 15%">Obs. Item</th>
            </tr>
        </thead>
        <tbody>
            @php($total = 0)
            @foreach($op->itens as $it)
                @php($qt = (float)($it->quantidade ?? 0))
                @php($total += $qt)
                <tr>
                    <td>{{ optional($it->produto)->nome }}</td>
                    <td>{{ optional($it->produto)->unidade }}</td>
                    <td class="text-end">{{ number_format($qt, 3, ',', '.') }}</td>
                    <td>{{ $it->observacao }}</td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <th colspan="2" class="text-end">Total</th>
                <th class="text-end">{{ number_format($total, 3, ',', '.') }}</th>
                <th></th>
            </tr>
        </tfoot>
    </table>

    <table style="border:0; width:100%; margin-top: 80px;">
        <tr>
            <td style="border:0; width:33%; text-align:center; vertical-align: bottom;">
                <div style="border-top:1px solid #000; height: 5px;"></div>
                <div style="font-size:11px; margin-top:4px;">ENC. PRODUÇÃO</div>
            </td>
            <td style="border:0; width:34%; text-align:center; vertical-align: bottom;">
                <div style="border-top:1px solid #000; height: 5px;"></div>
                <div style="font-size:11px; margin-top:4px;">MOTORISTA</div>
            </td>
            <td style="border:0; width:33%; text-align:center; vertical-align: bottom;">
                <div style="border-top:1px solid #000; height: 5px;"></div>
                <div style="font-size:11px; margin-top:4px;">CLIENTE</div>
            </td>
        </tr>
    </table>
</body>
</html>
