<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Relatório de Produções - Impressão</title>
    <link href="/css/app.css" rel="stylesheet" />
    <style>
        @media print {
            .no-print { display:none !important; }
            .card { border: none; }
        }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 6px; }
        th { background: #f3f3f3; }
        .text-end { text-align: right; }
    </style>
</head>
<body>
<div class="container mt-3">
    <div class="d-flex justify-content-between align-items-center">
        <div class="d-flex align-items-center">
            <img src="{{ $empresa?->img }}" alt="Logo" style="height:48px;width:auto;border-radius:4px;margin-right:10px;">
            <div>
                <div style="font-weight:700;font-size:16px;">{{ $empresa?->nome_fantasia ?? $empresa?->nome }}</div>
                <div style="font-size:12px;color:#666;">CNPJ: {{ $empresa?->cpf_cnpj }} • IE: {{ $empresa?->ie }}</div>
                <div style="font-size:12px;color:#666;">{{ $empresa?->rua }} {{ $empresa?->numero }}, {{ $empresa?->bairro }} • CEP: {{ $empresa?->cep }}</div>
            </div>
        </div>
        <div class="no-print" style="text-align: right; margin-bottom: 10px;">
            <button onclick="window.print()" class="btn btn-dark btn-sm">Imprimir</button>
        </div>
    </div>
    <hr>
    <h3>Relatório de Produções</h3>
    <table>
        <thead>
            <tr>
                <th style="width:15%">Número</th>
                <th style="width:15%">Data produção</th>
                <th style="width:30%">Produto</th>
                <th style="width:10%">UN</th>
                <th style="width:15%" class="text-end">Quantidade</th>
                <th style="width:15%">Cliente / Situação / Usuário</th>
            </tr>
        </thead>
        <tbody>
            @php($total = 0)
            @php($currentNumero = null)
            @foreach($rows as $row)
                @php($total += (float)$row->quantidade)
                @php($numeroOp = 'OP-'.str_pad((string)($row->codigo_sequencial ?? 0), 5, '0', STR_PAD_LEFT))
                @if($currentNumero !== $numeroOp)
                    @php($currentNumero = $numeroOp)
                    <tr style="background:#f7f7f7;">
                        <td colspan="2"><strong>{{ $numeroOp }}</strong> • {{ $row->data_producao ? __data_pt($row->data_producao, 0) : '' }}</td>
                        <td colspan="2"><strong>Cliente:</strong> {{ $row->cliente }}</td>
                        <td colspan="2">
                            <strong>Situação:</strong> {{ $row->situacao === 'finalizado' ? 'Finalizado' : 'Em Produção' }}
                            &nbsp;•&nbsp;
                            <strong>Usuário:</strong> {{ $row->usuario }}
                        </td>
                    </tr>
                    <tr style="background:#fcfcfc;">
                        <td></td>
                        <td></td>
                        <td><strong>Produto</strong></td>
                        <td><strong>UN</strong></td>
                        <td class="text-end"><strong>Quantidade</strong></td>
                        <td></td>
                    </tr>
                @endif
                <tr>
                    <td></td>
                    <td></td>
                    <td>{{ $row->produto }}</td>
                    <td>{{ $row->unidade }}</td>
                    <td class="text-end">{{ number_format($row->quantidade, 3, ',', '.') }}</td>
                    <td></td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <th colspan="4" class="text-end">Total</th>
                <th class="text-end">{{ number_format($total, 3, ',', '.') }}</th>
                <th></th>
            </tr>
        </tfoot>
    </table>
</div>
</body>
</html>
