@extends('layouts.app', ['title' => 'Relatório de Produções'])
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-lg-12">
                    {!!Form::open()->fill(request()->all())->get()!!}
                    @php($empresaId = request()->empresa_id ?? session('empresa_id') ?? optional(Auth::user())->empresa_id)
                    <input type="hidden" name="empresa_id" value="{{ $empresaId }}">
                    <div class="row mt-3 g-2">
                        <div class="col-md-2">
                            {!!Form::date('start_date', 'Data inicial')!!}
                        </div>
                        <div class="col-md-2">
                            {!!Form::date('end_date', 'Data final')!!}
                        </div>
                        <div class="col-md-3">
                            {!!Form::select('situacao', 'Situação', ['' => 'Todas', 'em_producao' => 'Em Produção', 'finalizado' => 'Finalizado'])->attrs(['class' => 'form-select'])!!}
                        </div>
                        <div class="col-md-3">
                            {!!Form::select('cliente_id', 'Cliente')->options(($clientes ?? collect())->prepend('Todos', '')->toArray())->attrs(['class' => 'form-select'])!!}
                        </div>
                        <div class="col-md-2">
                            {!!Form::select('produto_id', 'Produto')->options(($produtos ?? collect())->prepend('Todos', '')->toArray())->attrs(['class' => 'form-select'])!!}
                        </div>
                        <div class="col-md-12 text-left">
                            <br>
                            <button class="btn btn-primary" type="submit"><i class="ri-search-line"></i> Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="{{ route('ordem-producao.relatorio', ['empresa_id' => $empresaId]) }}"><i class="ri-eraser-fill"></i> Limpar</a>
                            @php($params = array_merge(request()->all(), ['empresa_id' => $empresaId]))
                            <a class="btn btn-dark" href="{{ route('ordem-producao.relatorio.print', $params) }}" target="_blank"><i class="ri-printer-line"></i> Imprimir</a>
                            <a class="btn btn-primary" href="{{ route('ordem-producao.relatorio.pdf', $params) }}"><i class="ri-file-pdf-2-line"></i> PDF</a>
                            <a class="btn btn-success" href="{{ route('ordem-producao.relatorio.excel', $params) }}"><i class="ri-file-excel-2-line"></i> Excel</a>
                            <a class="btn btn-outline-success" href="{{ route('ordem-producao.relatorio.export', $params) }}"><i class="ri-file-text-line"></i> CSV</a>
                        </div>
                    </div>
                    {!!Form::close()!!}
                </div>
                <div class="col-12 mt-3">
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th style="width: 15%">Número</th>
                                    <th style="width: 15%">Data produção</th>
                                    <th style="width: 30%">Produto</th>
                                    <th style="width: 10%">UN</th>
                                    <th style="width: 15%" class="text-end">Quantidade</th>
                                    <th style="width: 15%">Cliente / Situação / Usuário</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php($total = 0)
                                @php($currentNumero = null)
                                @php($groupTotal = 0)
                                @forelse($data as $row)
                                    @php($total += (float)$row->quantidade)
                                    @php($numeroOp = 'OP-'.str_pad((string)($row->codigo_sequencial ?? 0), 5, '0', STR_PAD_LEFT))
                                    @if($currentNumero !== $numeroOp)
                                        @if(!is_null($currentNumero))
                                            <tr class="table-secondary">
                                                <td colspan="4" class="text-end"><strong>Total {{ $currentNumero }}</strong></td>
                                                <td class="text-end"><strong>{{ number_format($groupTotal, 3, ',', '.') }}</strong></td>
                                                <td></td>
                                            </tr>
                                        @endif
                                        @php($currentNumero = $numeroOp)
                                        @php($groupTotal = 0)
                                        <tr class="table-secondary">
                                            <td colspan="2"><strong>{{ $numeroOp }}</strong> • {{ $row->data_producao ? __data_pt($row->data_producao, 0) : '' }}</td>
                                            <td colspan="2"><strong>Cliente:</strong> {{ $row->cliente }}</td>
                                            <td colspan="2">
                                                <strong>Situação:</strong> {{ $row->situacao === 'finalizado' ? 'Finalizado' : 'Em Produção' }}
                                                &nbsp;•&nbsp;
                                                <strong>Usuário:</strong> {{ $row->usuario }}
                                            </td>
                                        </tr>
                                        <tr class="table-light">
                                            <td></td>
                                            <td></td>
                                            <td><strong>Produto</strong></td>
                                            <td><strong>UN</strong></td>
                                            <td class="text-end"><strong>Quantidade</strong></td>
                                            <td></td>
                                        </tr>
                                    @endif
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td>{{ $row->produto }}</td>
                                        <td>{{ $row->unidade }}</td>
                                        <td class="text-end">{{ number_format($row->quantidade, 3, ',', '.') }}</td>
                                        <td></td>
                                    </tr>
                                    @php($groupTotal += (float)$row->quantidade)
                                @empty
                                    <tr>
                                        <td colspan="6" class="text-center">Nada encontrado</td>
                                    </tr>
                                @endforelse
                                @if(!is_null($currentNumero))
                                    <tr class="table-secondary">
                                        <td colspan="4" class="text-end"><strong>Total {{ $currentNumero }}</strong></td>
                                        <td class="text-end"><strong>{{ number_format($groupTotal, 3, ',', '.') }}</strong></td>
                                        <td></td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                        <div class="mt-3">
                            <strong>Total produzido:</strong> {{ number_format($totalQuantidade, 3, ',', '.') }}
                        </div>
                    </div>
                </div>
                {!! $data->appends(request()->all())->links() !!}
            </div>
        </div>
    </div>
</div>
@endsection
