@extends('layouts.app', ['title' => 'Editar Ordem de Produção - ' . (isset($op->numero) ? $op->numero : ('OP-' . str_pad($op->codigo_sequencial ?? 0, 5, '0', STR_PAD_LEFT)))])
@section('content')

<div class="card mt-1">
    <div class="card-header">
        <h4>Editar Ordem de Produção: {{ isset($op->numero) ? $op->numero : ('OP-' . str_pad($op->codigo_sequencial ?? 0, 5, '0', STR_PAD_LEFT)) }}</h4>
        <div style="text-align: right; margin-top: -35px;">
            <a href="{{ route('ordem-producao.index') }}" class="btn btn-danger btn-sm px-3">
                <i class="ri-arrow-left-double-fill"></i>Voltar
            </a>
        </div>
    </div>
    <div class="card-body">
        {!!Form::open()
        ->put()
        ->route('ordem-producao.update', [$op->id])
        ->multipart()
        ->fill($op->toArray())
        !!}
        <div class="pl-lg-4">
            @include('ordem_producao._forms', [
                'clientes' => $clientes,
                'clientesOptions' => $clientesOptions ?? null,
                'produtos' => $produtos,
                'produtosJs' => $produtosJs ?? null,
                'data' => []
            ])
        </div>
        {!!Form::close()!!}

    </div>
</div>

@endsection
