@section('css')
<style type="text/css">
    h4{
        color: #558FF2;
    }
    h6 strong{
        color: #558FF2;
    }
</style>
@endsection

<div class="row g-2">
    <div class="col-md-12">
        <div class="alert alert-info">
            <i class="ri-information-line"></i>
            <strong>Informação:</strong> Os dados fiscais e de endereço serão herdados da empresa principal. 
            Você só precisa definir a descrição e status desta localização.
        </div>
    </div>

    <div class="col-md-6">
        {!!Form::text('descricao', 'Descrição do Local')
        ->attrs(['class' => 'form-control', 'placeholder' => 'Ex: Filial Centro, Depósito Norte, etc.'])
        ->value(isset($item) ? $item->descricao : 'BL000' . $count)
        ->required()
        !!}
        <small class="text-muted">Nome identificador desta localização</small>
    </div>

    <div class="col-md-3">
        {!!Form::select('status', 'Status', [1 => 'Ativo', 0 => 'Desativado'])
        ->attrs(['class' => 'form-select'])
        ->value(isset($item) ? $item->status : 1)
        !!}
    </div>

    <div class="col-md-3">
        <label class="form-label">Empresa</label>
        <input type="text" class="form-control" value="{{ $empresa->nome ?? 'Empresa Principal' }}" readonly>
        <input type="hidden" name="empresa_id" value="{{ $empresa->id ?? request()->empresa_id }}">
        <small class="text-muted">Dados herdados da empresa</small>
    </div>

    <div class="col-md-12 mt-3">
        <div class="card border-secondary">
            <div class="card-header bg-light">
                <h6 class="mb-0"><i class="ri-building-line"></i> Dados que serão herdados da empresa principal:</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <strong>CNPJ/CPF:</strong> {{ $empresa->cpf_cnpj ?? 'Não informado' }}
                    </div>
                    <div class="col-md-4">
                        <strong>Nome:</strong> {{ $empresa->nome ?? 'Não informado' }}
                    </div>
                    <div class="col-md-4">
                        <strong>Endereço:</strong> {{ $empresa->rua ?? 'Não informado' }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-12 mt-4">
        <hr>
        <div style="text-align: right;">
            <a href="{{ route('localizacao.index') }}" class="btn btn-secondary me-2">
                <i class="ri-arrow-left-line"></i> Cancelar
            </a>
            <button type="submit" class="btn btn-success">
                <i class="ri-save-line"></i> Salvar Localização
            </button>
        </div>
    </div>
</div>

@section('js')
<script>
$(document).ready(function() {
    // Auto-gerar descrição baseada no contador
    let count = {{ $count ?? 1 }};
    if (!$('#descricao').val() || $('#descricao').val().startsWith('BL000')) {
        $('#descricao').val('Localização ' + String(count).padStart(2, '0'));
    }
});
</script>
@endsection