<!doctype html>
    <html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <!-- Meta tags SEO -->
        <meta name="description" content="Acesse o {{ env('APP_NAME') }} - Sistema ERP completo para gestão empresarial. Faça seu cadastro gratuito e comece a usar hoje mesmo.">
        <meta name="keywords" content="login {{ env('APP_NAME') }}, cadastro {{ env('APP_NAME') }}, sistema erp, gestão empresarial">
        <meta name="author" content="{{ env('APP_NAME') }}">
        <meta name="robots" content="noindex, nofollow">

        <!-- CSRF Token -->
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ $title }} | {{ env("APP_NAME") }} - Sistema ERP</title>

        <!-- Fonts -->
        <link rel="dns-prefetch" href="//fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">

        <!-- Scripts -->

        <link href="/assets/css/app.min.css" rel="stylesheet" type="text/css" id="app-style" />
        <link href="/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
        <script src="/assets/js/config.js"></script>
        <link rel="shortcut icon" href="/logo_2.png">
        <link rel="icon" type="image/png" sizes="32x32" href="/logo_2.png">
        <link rel="icon" type="image/png" sizes="16x16" href="/logo_2.png">
        <link rel="apple-touch-icon" sizes="180x180" href="/logo_2.png">

        <!-- PWA: Manifest e ícone -->
        <link rel="manifest" href="{{ asset('manifest.json') }}">
        <link rel="icon" href="{{ asset('logo_1.png') }}">
        <meta name="theme-color" content="#667eea">

        <!-- PWA: Registrar Service Worker -->
        <script>
            if ('serviceWorker' in navigator) {
                window.addEventListener('load', async () => {
                    try {
                        const registration = await navigator.serviceWorker.register("serviceworker.js");
                        console.log("✅ Service Worker registrado:", registration.scope);
                    } catch (error) {
                        console.error("❌ Erro ao registrar Service Worker:", error);
                    }
                });
            }
        </script>  

        @yield('css')

        <!-- Google tag (gtag.js) -->
        <script async src="https://www.googletagmanager.com/gtag/js?id=AW-1004691493"></script>
        <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());

        gtag('config', 'AW-1004691493');
        </script>
    </head>
    <body class="authentication-bg pb-0">

        @if(session()->has('flash_success'))
        <div class="container">
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <strong>Sucesso!</strong> {{ session()->get('flash_success') }}

            </div>
        </div>
        @endif

        @if(session()->has('flash_error'))
        <div class="container">
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <strong>Sucesso!</strong> {{ session()->get('flash_error') }}

            </div>
        </div>
        @endif

        @yield('content')
        
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>

        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ENjdO4Dr2bkBIFxQpeoTz1HIcje39Wm4jDKdf19U8gI4ddQ3GYNS7NTKfAdVQSZe" crossorigin="anonymous"></script>

        <script src="/assets/js/vendor.min.js"></script>

        <!-- App js -->
        <script src="/assets/js/app.min.js"></script>

        <script src='https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.js'></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.15/jquery.mask.min.js"></script>
        <!-- <script type="text/javascript" src="/js/main.js"></script> -->

        @yield('js')

    </body>
    </html>
