@extends('layouts.app', ['title' => 'Resultado da Finalização do Inventário'])
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-12">
                    <h4 class="mb-3">
                        @if(isset($log_processo['status_final']) && $log_processo['status_final'] == 'concluido')
                            <i class="ri-check-double-line text-success"></i> Inventário Finalizado com Sucesso
                        @else
                            <i class="ri-error-warning-line text-danger"></i> Erro na Finalização do Inventário
                        @endif
                    </h4>
                    
                    @if(session('flash_success'))
                    <div class="alert alert-success">
                        {{ session('flash_success') }}
                    </div>
                    @endif
                    
                    @if(session('flash_error'))
                    <div class="alert alert-danger">
                        {{ session('flash_error') }}
                    </div>
                    @endif
                </div>
                
                <hr class="mt-3">
                
                <div class="row mb-4">
                    <div class="col-md-12">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h5><i class="ri-information-line text-primary"></i> Informações do Inventário</h5>
                                <div class="row mt-3">
                                    <div class="col-md-4">
                                        <p><strong>Referência:</strong> {{ $inventario->referencia }}</p>
                                        <p><strong>Número:</strong> {{ $inventario->numero_sequencial }}</p>
                                    </div>
                                    <div class="col-md-4">
                                        <p><strong>Início:</strong> {{ \Carbon\Carbon::parse($inventario->inicio)->format('d/m/Y') }}</p>
                                        <p><strong>Fim:</strong> {{ $inventario->fim ? \Carbon\Carbon::parse($inventario->fim)->format('d/m/Y') : 'Em andamento' }}</p>
                                    </div>
                                    <div class="col-md-4">
                                        <p><strong>Status:</strong> 
                                            @if($inventario->status == 'finalizado')
                                                <span class="badge bg-success">Finalizado</span>
                                            @elseif($inventario->status == 0)
                                                <span class="badge bg-success">Finalizado</span>
                                            @else
                                                <span class="badge bg-warning">{{ $inventario->status }}</span>
                                            @endif
                                        </p>
                                        <p><strong>Total de Produtos:</strong> {{ $log_processo['total_produtos'] ?? 0 }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row mb-4">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-body">
                                <h5><i class="ri-time-line text-primary"></i> Log de Processamento</h5>
                                <div class="table-responsive mt-3">
                                    <table class="table table-bordered">
                                        <tbody>
                                            <tr>
                                                <th width="200">Início do Processamento</th>
                                                <td>{{ $log_processo['inicio'] }}</td>
                                            </tr>
                                            <tr>
                                                <th>Fim do Processamento</th>
                                                <td>{{ $log_processo['fim'] }}</td>
                                            </tr>
                                            <tr>
                                                <th>Status Final</th>
                                                <td>
                                                    @if(isset($log_processo['status_final']) && $log_processo['status_final'] == 'concluido')
                                                        <span class="badge bg-success">Concluído com Sucesso</span>
                                                    @else
                                                        <span class="badge bg-danger">Erro no Processamento</span>
                                                    @endif
                                                </td>
                                            </tr>
                                            @if(isset($log_processo['erro_fatal']))
                                            <tr>
                                                <th>Erro Fatal</th>
                                                <td class="text-danger">{{ $log_processo['erro_fatal'] }}</td>
                                            </tr>
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <ul class="nav nav-tabs mb-3" id="processTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="zeragem-tab" data-bs-toggle="tab" data-bs-target="#zeragem" type="button" role="tab" aria-controls="zeragem" aria-selected="true">
                                    Etapa 1: Zeragem do Estoque
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="atualizacao-tab" data-bs-toggle="tab" data-bs-target="#atualizacao" type="button" role="tab" aria-controls="atualizacao" aria-selected="false">
                                    Etapa 2: Atualização do Estoque
                                </button>
                            </li>
                            @if(!empty($log_processo['erros']))
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="erros-tab" data-bs-toggle="tab" data-bs-target="#erros" type="button" role="tab" aria-controls="erros" aria-selected="false">
                                    Erros
                                </button>
                            </li>
                            @endif
                        </ul>
                        
                        <div class="tab-content" id="processTabContent">
                            <!-- Tab de Zeragem -->
                            <div class="tab-pane fade show active" id="zeragem" role="tabpanel" aria-labelledby="zeragem-tab">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead class="table-light">
                                            <tr>
                                                <th>ID</th>
                                                <th>Produto</th>
                                                <th>Estoque Anterior</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse($log_processo['zeragem'] as $item)
                                            <tr>
                                                <td>{{ $item['produto_id'] }}</td>
                                                <td>{{ $item['produto_nome'] }}</td>
                                                <td class="text-end">{{ number_format($item['quantidade_anterior'] ?? 0, 2, ',', '.') }}</td>
                                                <td>
                                                    @if($item['status'] == 'sucesso')
                                                        <span class="badge bg-success">Sucesso</span>
                                                    @else
                                                        <span class="badge bg-danger">Erro</span>
                                                        <small class="d-block text-danger">{{ $item['erro'] ?? '' }}</small>
                                                    @endif
                                                </td>
                                            </tr>
                                            @empty
                                            <tr>
                                                <td colspan="4" class="text-center">Nenhum produto processado nesta etapa.</td>
                                            </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            
                            <!-- Tab de Atualização -->
                            <div class="tab-pane fade" id="atualizacao" role="tabpanel" aria-labelledby="atualizacao-tab">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead class="table-light">
                                            <tr>
                                                <th>ID</th>
                                                <th>Produto</th>
                                                <th>Nova Quantidade</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse($log_processo['atualizacao'] as $item)
                                            <tr>
                                                <td>{{ $item['produto_id'] }}</td>
                                                <td>{{ $item['produto_nome'] }}</td>
                                                <td class="text-end">{{ number_format($item['quantidade_nova'] ?? 0, 2, ',', '.') }}</td>
                                                <td>
                                                    @if($item['status'] == 'sucesso')
                                                        <span class="badge bg-success">Sucesso</span>
                                                    @else
                                                        <span class="badge bg-danger">Erro</span>
                                                        <small class="d-block text-danger">{{ $item['erro'] ?? '' }}</small>
                                                    @endif
                                                </td>
                                            </tr>
                                            @empty
                                            <tr>
                                                <td colspan="4" class="text-center">Nenhum produto processado nesta etapa.</td>
                                            </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            
                            <!-- Tab de Erros -->
                            @if(!empty($log_processo['erros']))
                            <div class="tab-pane fade" id="erros" role="tabpanel" aria-labelledby="erros-tab">
                                <div class="alert alert-danger">
                                    <h5><i class="ri-error-warning-line"></i> Erros durante o processamento</h5>
                                    <ul class="mb-0 mt-2">
                                        @foreach($log_processo['erros'] as $erro)
                                            <li>{{ $erro }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-md-12 d-flex justify-content-between">
                        <a href="{{ route('processo-inventario.index') }}" class="btn btn-secondary">
                            <i class="ri-arrow-left-line"></i> Voltar para Inventários
                        </a>
                        <a href="{{ route('processo-inventario.print-relatorio', $inventario->id) }}" class="btn btn-primary" target="_blank">
                            <i class="ri-file-pdf-line"></i> Gerar Relatório Final
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 