<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Relatório de Inventário</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 0;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            padding: 10px;
            border-bottom: 1px solid #ccc;
        }
        .header h1 {
            font-size: 18px;
            margin: 0;
            padding: 0;
        }
        .header h2 {
            font-size: 14px;
            margin: 5px 0;
            padding: 0;
            font-weight: normal;
        }
        .info-section {
            margin-bottom: 20px;
            border: 1px solid #ddd;
            padding: 10px;
        }
        .info-section h3 {
            margin-top: 0;
            padding-bottom: 5px;
            border-bottom: 1px solid #eee;
            font-size: 14px;
        }
        .info-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 10px;
        }
        .info-item {
            margin-bottom: 5px;
        }
        .resumo-grid {
            display: grid;
            grid-template-columns: 1fr 1fr 1fr 1fr;
            gap: 10px;
            margin-bottom: 15px;
        }
        .resumo-card {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: center;
        }
        .resumo-card h3 {
            margin: 0;
            font-size: 20px;
        }
        .resumo-card p {
            margin: 5px 0 0;
            color: #666;
            font-size: 11px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        table thead th {
            padding: 8px;
            background-color: #f2f2f2;
            border: 1px solid #ddd;
            font-size: 11px;
            text-align: left;
        }
        table tbody td {
            padding: 8px;
            border: 1px solid #ddd;
            font-size: 10px;
        }
        table tbody tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .text-success {
            color: #28a745;
        }
        .text-danger {
            color: #dc3545;
        }
        .footer {
            margin-top: 20px;
            font-size: 10px;
            text-align: center;
            font-style: italic;
        }
        .page-break {
            page-break-after: always;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>RELATÓRIO DE INVENTÁRIO</h1>
        <h2>{{ $inventario->referencia }}</h2>
    </div>
    
    <div class="info-section">
        <h3>Informações do Inventário</h3>
        <div class="info-grid">
            <div>
                <div class="info-item"><strong>Número:</strong> {{ $inventario->numero_sequencial }}</div>
                <div class="info-item"><strong>Referência:</strong> {{ $inventario->referencia }}</div>
                <div class="info-item"><strong>Tipo:</strong> {{ \App\Models\Inventario::tipos()[$inventario->tipo] ?? 'Não definido' }}</div>
            </div>
            <div>
                <div class="info-item"><strong>Data de Início:</strong> {{ \Carbon\Carbon::parse($inventario->inicio)->format('d/m/Y') }}</div>
                <div class="info-item"><strong>Data de Fim:</strong> {{ $inventario->fim ? \Carbon\Carbon::parse($inventario->fim)->format('d/m/Y') : 'Em andamento' }}</div>
                <div class="info-item"><strong>Data do Ajuste:</strong> {{ $inventario->data_ajuste ? \Carbon\Carbon::parse($inventario->data_ajuste)->format('d/m/Y H:i') : 'Não ajustado' }}</div>
                <div class="info-item"><strong>Responsável:</strong> {{ $inventario->usuario ? $inventario->usuario->name : 'Não definido' }}</div>
            </div>
        </div>
    </div>
    
    <div class="info-section">
        <h3>Resumo da Análise</h3>
        <div class="resumo-grid">
            <div class="resumo-card">
                <h3>{{ $resumo['total_itens'] }}</h3>
                <p>Total de Produtos</p>
            </div>
            <div class="resumo-card">
                <h3>{{ $resumo['itens_contados'] }}</h3>
                <p>Produtos Contados</p>
            </div>
            <div class="resumo-card">
                <h3>{{ $resumo['divergencias'] }}</h3>
                <p>Divergências Encontradas</p>
            </div>
            <div class="resumo-card">
                <h3>{{ $resumo['percentual_divergencia'] }}%</h3>
                <p>Percentual de Divergência</p>
            </div>
        </div>
    </div>
    
    <div class="info-section">
        <h3>Produtos com Divergência</h3>
        @if(count($divergentes) > 0)
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Código de Barras</th>
                        <th>Produto</th>
                        <th>Estoque Atual</th>
                        <th>Quantidade Contada</th>
                        <th>Divergência</th>
                        <th>% Diferença</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($divergentes as $item)
                    <tr>
                        <td>{{ $item['produto_id'] }}</td>
                        <td>{{ $item['codigo_barras'] }}</td>
                        <td>{{ $item['produto_nome'] }}</td>
                        <td class="text-right">{{ number_format($item['estoque_atual'], 2, ',', '.') }}</td>
                        <td class="text-right">{{ number_format($item['quantidade_contada'], 2, ',', '.') }}</td>
                        <td class="text-right @if($item['divergencia'] > 0) text-success @elseif($item['divergencia'] < 0) text-danger @endif">
                            {{ number_format($item['divergencia'], 2, ',', '.') }}
                        </td>
                        <td class="text-right">{{ $item['percentual'] }}%</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        @else
            <p class="text-center">Não foram encontradas divergências neste inventário.</p>
        @endif
    </div>
    
    <div class="info-section">
        <h3>Lista Completa de Produtos</h3>
        @if(count($analise) > 0)
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Código de Barras</th>
                        <th>Produto</th>
                        <th>Estoque Atual</th>
                        <th>Quantidade Contada</th>
                        <th>Divergência</th>
                        <th>Observação</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($analise as $item)
                    <tr>
                        <td>{{ $item['produto_id'] }}</td>
                        <td>{{ $item['codigo_barras'] }}</td>
                        <td>{{ $item['produto_nome'] }}</td>
                        <td class="text-right">{{ number_format($item['estoque_atual'], 2, ',', '.') }}</td>
                        <td class="text-right">{{ number_format($item['quantidade_contada'], 2, ',', '.') }}</td>
                        <td class="text-right @if($item['divergencia'] > 0) text-success @elseif($item['divergencia'] < 0) text-danger @endif">
                            {{ number_format($item['divergencia'], 2, ',', '.') }}
                        </td>
                        <td>{{ $item['observacao'] }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        @else
            <p class="text-center">Não há produtos neste inventário.</p>
        @endif
    </div>
    
    <div class="footer">
        <p>Relatório gerado em {{ date('d/m/Y H:i') }}</p>
        <p>Este relatório apresenta os resultados do inventário e as divergências encontradas entre o estoque atual e as quantidades contadas.</p>
    </div>
</body>
</html> 