@extends('layouts.app', ['title' => 'Importação de Inventário'])
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-12">
                    <h4 class="mb-3">Importação de Inventário - Inventário #{{ $inventario->numero_sequencial }}</h4>
                    <p class="text-muted">
                        Utilize este formulário para importar dados de contagem a partir da planilha Excel. 
                        A planilha deve seguir o modelo padrão com as colunas: ID, Código de Barras, Descrição, Quantidade Contada e Observação.
                    </p>
                </div>
                <hr class="mt-3">
                
                @if(session('flash_success'))
                <div class="alert alert-success">
                    {{ session('flash_success') }}
                </div>
                @endif
                
                @if(session('flash_error'))
                <div class="alert alert-danger">
                    {{ session('flash_error') }}
                </div>
                @endif
                
                @if(session('erros_importacao'))
                <div class="alert alert-warning">
                    <h5>Detalhes dos erros de importação:</h5>
                    <ul>
                        @foreach(session('erros_importacao') as $erro)
                        <li>{{ $erro }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif

                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h5><i class="ri-information-line text-primary"></i> Informações do Inventário</h5>
                                <div class="mt-3">
                                    <p><strong>Referência:</strong> {{ $inventario->referencia }}</p>
                                    <p><strong>Tipo:</strong> {{ \App\Models\Inventario::tipos()[$inventario->tipo] ?? 'Não definido' }}</p>
                                    <p><strong>Total de Produtos:</strong> {{ count($itens) }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="card bg-light border">
                            <div class="card-body">
                                <h5>Instruções para importação</h5>
                                <ol>
                                    <li>Baixe o <a href="{{ route('processo-inventario.gerar-modelo', $inventario->id) }}" class="btn btn-sm btn-outline-primary">
                                        <i class="ri-file-download-line"></i> Modelo de Planilha</a></li>
                                    <li>Preencha o arquivo com as quantidades contadas</li>
                                    <li>Salve a planilha e faça o upload utilizando o formulário abaixo</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            
                <form action="{{ route('processo-inventario.upload-excel', $inventario->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <div class="col-md-8">
                            <div class="mb-3">
                                <label for="arquivo" class="form-label">Arquivo de Inventário <span class="text-danger">*</span></label>
                                <input type="file" class="form-control" id="arquivo" name="arquivo" required
                                    accept=".xlsx,.xls,.csv">
                                <small class="text-muted">
                                    Formatos aceitos: Excel (.xlsx, .xls) ou CSV
                                </small>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <!-- Opção de ajuste de estoque removida -->
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <button type="submit" class="btn btn-primary">
                                <i class="ri-upload-2-line"></i> Importar Contagem
                            </button>
                            <a href="{{ route('processo-inventario.opcoes', $inventario->id) }}" class="btn btn-secondary">
                                <i class="ri-arrow-left-line"></i> Voltar para Opções
                            </a>
                        </div>
                    </div>
                </form>
                
                <div class="row mt-4">
                    <div class="col-md-12">
                        <div class="card border-info">
                            <div class="card-header bg-info text-white">
                                <h5 class="mb-0">Modelo da Planilha</h5>
                            </div>
                            <div class="card-body">
                                <p>
                                    A planilha de importação contém as seguintes colunas:
                                </p>
                                <ol>
                                    <li><strong>ID:</strong> Identificador único do produto no sistema (não alterar)</li>
                                    <li><strong>Código de Barras:</strong> O código de barras do produto (se disponível)</li>
                                    <li><strong>Descrição:</strong> O nome do produto</li>
                                    <li><strong>Quantidade Contada:</strong> Campo a ser preenchido com a quantidade contada</li>
                                    <li><strong>Observação:</strong> Campo opcional para observações sobre o item</li>
                                </ol>
                                <p class="mb-0 text-danger">
                                    <i class="ri-error-warning-line"></i> 
                                    <strong>Importante:</strong> Não altere a estrutura da planilha nem remova produtos. Apenas preencha as colunas de quantidade e observação.
                                </p>
                                <p class="mt-3 text-info">
                                    <i class="ri-information-line"></i>
                                    <strong>Nota:</strong> Após a importação, você verá uma tela com todos os itens importados. 
                                    Para fazer ajustes nas quantidades, utilize a tela de conferência que estará disponível após a visualização dos dados.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 