@extends('layouts.app', ['title' => 'Home'])
@if(!__isContador())
@section('css')
<link href="/assets/css/dashboard-animations.css" rel="stylesheet" type="text/css" />
<style>
.pulse-birthday {
    animation: pulse-birthday 1s infinite;
    color: #e91e63 !important;
    font-size: 1.2rem !important;
}
@keyframes pulse-birthday {
    0% { transform: scale(1); box-shadow: 0 0 0 0 rgba(233,30,99, 0.7); }
    70% { transform: scale(1.2); box-shadow: 0 0 0 10px rgba(233,30,99, 0); }
    100% { transform: scale(1); box-shadow: 0 0 0 0 rgba(233,30,99, 0); }
}
</style>
@endsection

@section('content')
<div class="mt-3">
    <!-- <div class="row mb-3">
        <div class="col-lg-2 col-md-4 col-6 mb-2">
            <div class="card shadow-sm border-0 p-2 h-100 d-flex flex-row align-items-center" style="min-width:150px; min-height:100px;">
                <div class="me-2">
                    <i class="ri-bar-chart-grouped-line text-primary" style="font-size:2rem;"></i>
                </div>
                <div>
                    <div class="fw-bold text-muted small mb-1">Total Vendas</div>
                    <div class="fs-5 fw-bold">{{ $totalNfeCount + $totalNfceCount }}</div>
                    <div class="text-muted" style="font-size:0.85rem;">unidades</div>
                </div>
            </div>
        </div>
        <div class="col-lg-2 col-md-4 col-6 mb-2">
            <div class="card shadow-sm border-0 p-2 h-100 d-flex flex-row align-items-center" style="min-width:150px; min-height:100px;">
                <div class="me-2">
                    <i class="ri-cash-line text-success" style="font-size:2rem;"></i>
                </div>
                <div>
                    <div class="fw-bold text-muted small mb-1">Vendas Efetuadas</div>
                    <div class="fs-5 fw-bold">R$ {{ number_format($totalVendasMes, 2, ',', '.') }}</div>
                    <div class="text-success small">
                        @if($totalVendasMes > 0)
                            <i class="ri-arrow-up-line"></i> {{ number_format(7.1, 1) }}%
                        @else
                            <span class="text-muted">Sem variação</span>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-2 col-md-4 col-6 mb-2">
            <div class="card shadow-sm border-0 p-2 h-100 d-flex flex-row align-items-center" style="min-width:150px; min-height:100px;">
                <div class="me-2">
                    <i class="ri-file-list-3-line text-info" style="font-size:2rem;"></i>
                </div>
                <div>
                    <div class="fw-bold text-muted small mb-1">NFe Emitidas</div>
                    <div class="fs-5 fw-bold">{{ $nfeCount }}</div>
                    <div class="text-muted" style="font-size:0.85rem;">Valor: <span class="fw-bold">R$ {{ number_format($nfeTotal, 2, ',', '.') }}</span></div>
                </div>
            </div>
        </div>
        <div class="col-lg-2 col-md-4 col-6 mb-2">
            <div class="card shadow-sm border-0 p-2 h-100 d-flex flex-row align-items-center" style="min-width:150px; min-height:100px;">
                <div class="me-2">
                    <i class="ri-shopping-bag-3-line text-warning" style="font-size:2rem;"></i>
                </div>
                <div>
                    <div class="fw-bold text-muted small mb-1">NFCe Emitidas</div>
                    <div class="fs-5 fw-bold">{{ $nfceCount }}</div>
                    <div class="text-muted" style="font-size:0.85rem;">Valor: <span class="fw-bold">R$ {{ number_format($nfceTotal, 2, ',', '.') }}</span></div>
                </div>
            </div>
        </div>
        <div class="col-lg-2 col-md-4 col-6 mb-2">
            <div class="card shadow-sm border-0 p-2 h-100 d-flex flex-row align-items-center" style="min-width:150px; min-height:100px;">
                <div class="me-2">
                    <i class="ri-bank-card-line text-danger" style="font-size:2rem;"></i>
                </div>
                <div>
                    <div class="fw-bold text-muted small mb-1">Despesas</div>
                    <div class="fs-5 fw-bold">R$ {{ number_format($totalComprasMes, 2, ',', '.') }}</div>
                    <div class="text-danger small">
                        @if($totalComprasMes > 0)
                            <i class="ri-arrow-down-line"></i> {{ number_format(2.3, 1) }}%
                        @else
                            <span class="text-muted">Sem variação</span>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div> -->
    <div class="row">

        @if(__isAdmin())
        <!-- Dashboard Ultramoderno -->
        <div class="dashboard-header animated">
            <header class="dashboard-header">
                <h1 class="dashboard-title">Dashboard</h1>
                <p class="dashboard-subtitle">Bem-vindo ao sistema {{ env("APP_NAME") }}. Aqui você pode gerenciar todas as suas operações em tempo real.</p>
                <div class="dashboard-period-info">
                    <span class="period-label">Período atual: </span>
                    <span class="period-value" id="current-period-display">Este Mês</span>
                    <span class="period-date" id="period-date-range"></span>
                </div>
            </header>
            

        <div class="dashboard-filters">
            <!-- Inputs ocultos para passagem de dados -->
            <input type="hidden" id="empresa_id" value="{{ auth()->user()->empresa_id ?? '' }}">
            <input type="hidden" id="usuario_id" value="{{ auth()->user()->id ?? '' }}">
            <input type="hidden" id="inp-periodo" value="{{ request('periodo', 'today') }}">
            <input type="hidden" id="inp-local_id" value="{{ request('local_id', '') }}">
            
            <button class="date-range-btn {{ request('periodo', 'today') == 'today' ? 'active' : '' }}" data-range="today">Hoje</button>
            <button class="date-range-btn {{ request('periodo') == 'week' ? 'active' : '' }}" data-range="week">Esta semana</button>
            <button class="date-range-btn {{ request('periodo') == 'month' ? 'active' : '' }}" data-range="month">Este mês</button>
            <button class="date-range-btn {{ request('periodo') == 'year' ? 'active' : '' }}" data-range="year">Este ano</button>
            <button class="date-range-btn {{ request('periodo') == 'custom' ? 'active' : '' }}" data-range="custom">Personalizado</button>
            <input type="text" id="customDateRange" placeholder="Selecione um período" class="form-control custom-date-input {{ request('periodo') == 'custom' ? 'visible' : 'hidden' }}">
        </div>

        <div class="row mb-3 justify-content-center">
            <div class="col-lg-2 col-md-4 col-6 mb-2">
                <div class="card shadow-sm border-0 p-2 h-100 d-flex flex-column align-items-center text-center" style="min-width:150px; min-height:100px;">
                    <i class="ri-bar-chart-grouped-line text-primary mb-1" style="font-size:2rem;"></i>
                    <div class="fw-bold text-muted small mb-1">Total Vendas</div>
                    <div class="fs-5 fw-bold">{{ $totalNfeCount + $totalNfceCount }}</div>
                    <div class="text-muted" style="font-size:0.85rem;">unidades</div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-6 mb-2">
                <div class="card shadow-sm border-0 p-2 h-100 d-flex flex-column align-items-center text-center" style="min-width:150px; min-height:100px;">
                    <i class="ri-cash-line text-success mb-1" style="font-size:2rem;"></i>
                    <div class="fw-bold text-muted small mb-1">Vendas Efetuadas</div>
                    <div class="fs-5 fw-bold">R$ {{ number_format($totalVendasMes, 2, ',', '.') }}</div>
                    <div class="text-success small">
                        @if($totalVendasMes > 0)
                            <i class="ri-arrow-up-line"></i> {{ number_format(7.1, 1) }}%
                        @else
                            <span class="text-muted">Sem variação</span>
                        @endif
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-6 mb-2">
                <div class="card shadow-sm border-0 p-2 h-100 d-flex flex-column align-items-center text-center" style="min-width:150px; min-height:100px;">
                    <i class="ri-file-list-3-line text-info mb-1" style="font-size:2rem;"></i>
                    <div class="fw-bold text-muted small mb-1">NFe Emitidas</div>
                    <div class="fs-5 fw-bold">{{ $nfeCount }}</div>
                    <div class="text-muted" style="font-size:0.85rem;">Valor: <span class="fw-bold">R$ {{ number_format($nfeTotal, 2, ',', '.') }}</span></div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-6 mb-2">
                <div class="card shadow-sm border-0 p-2 h-100 d-flex flex-column align-items-center text-center" style="min-width:150px; min-height:100px;">
                    <i class="ri-shopping-bag-3-line text-warning mb-1" style="font-size:2rem;"></i>
                    <div class="fw-bold text-muted small mb-1">NFCe Emitidas</div>
                    <div class="fs-5 fw-bold">{{ $nfceCount }}</div>
                    <div class="text-muted" style="font-size:0.85rem;">Valor: <span class="fw-bold">R$ {{ number_format($nfceTotal, 2, ',', '.') }}</span></div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-6 mb-2">
                <div class="card shadow-sm border-0 p-2 h-100 d-flex flex-column align-items-center text-center" style="min-width:150px; min-height:100px;">
                    <i class="ri-bank-card-line text-danger mb-1" style="font-size:2rem;"></i>
                    <div class="fw-bold text-muted small mb-1">Despesas</div>
                    <div class="fs-5 fw-bold">R$ {{ number_format($totalComprasMes, 2, ',', '.') }}</div>
                    <div class="text-danger small">
                        @if($totalComprasMes > 0)
                            <i class="ri-arrow-down-line"></i> {{ number_format(2.3, 1) }}%
                        @else
                            <span class="text-muted">Sem variação</span>
                        @endif
                    </div>
                </div>
            </div>
        </div>



    <div class="dashboard-container">
            <!-- Cards com gradiente -->
            <div class="dashboard-quarter animate-on-scroll animate-fade-up delay-1">
                <div class="diagonal-gradient-card primary">
                    <i class="ri-money-dollar-circle-line card-icon"></i>
                    <div>
                        <div class="card-title">Contas a Receber</div>
                        <div class="card-value total-receber">R$ 0,00</div>
                    </div>
                    <div class="card-footer">
                        <i class="ri-calendar-line"></i> 
                        <span>Próximos 30 dias</span>
                    </div>
                </div>
            </div>

            <div class="dashboard-quarter animate-on-scroll animate-fade-up delay-2">
                <div class="diagonal-gradient-card danger">
                    <i class="ri-bank-card-line card-icon"></i>
                    <div>
                        <div class="card-title">Contas a Pagar</div>
                        <div class="card-value total-pagar">R$ 0,00</div>
                    </div>
                    <div class="card-footer">
                        <i class="ri-calendar-line"></i> 
                        <span>Próximos 30 dias</span>
                                    </div>
                                </div>
                            </div>

            <div class="dashboard-quarter animate-on-scroll animate-fade-up delay-3">
                <div class="diagonal-gradient-card warning">
                    <i class="ri-box-3-line card-icon"></i>
                    <div>
                        <div class="card-title">Total de Produtos</div>
                        <div class="card-value total-produtos">0</div>
                    </div>
                    <div class="card-footer">
                        <i class="ri-database-2-line"></i> 
                        <span>Total no sistema</span>
                                    </div>
                                </div>
                            </div>

            <div class="dashboard-quarter animate-on-scroll animate-fade-up delay-4">
                <div class="diagonal-gradient-card info">
                    <i class="ri-account-box-fill card-icon"></i>
                    <div>
                        <div class="card-title">Total de Clientes</div>
                        <div class="card-value total-clientes">0</div>
                    </div>
                    <div class="card-footer">
                        <i class="ri-team-line"></i> 
                        <span>Total no sistema</span>
                            </div>
                        </div>
                    </div>

            <!-- Gráfico principal - Vendas -->
            <div class="dashboard-half animate-on-scroll animate-fade-up delay-1">
                <div class="chart-card-3d">
                    <div class="card-header">
                        <h5>Análise de Vendas Mensal</h5>
                        <div class="card-header-right">
                            <div class="card-header-action" data-bs-toggle="tooltip" data-bs-placement="top" title="Atualizar">
                                <i class="ri-refresh-line"></i>
                                    </div>
                            <div class="card-header-action" data-bs-toggle="tooltip" data-bs-placement="top" title="Expandir">
                                <i class="ri-fullscreen-line"></i>
                                    </div>
                            <div class="card-header-action" data-bs-toggle="tooltip" data-bs-placement="top" title="Mais opções">
                                <i class="ri-more-2-fill"></i>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="chart-container" id="salesChart" data-sales='@json($somaVendasMesesAnteriores)'></div>
                    </div>
                </div>
                </div>

            <!-- Gráfico de Receitas -->
            <div class="dashboard-half animate-on-scroll animate-fade-up delay-2">
                <div class="chart-card-3d">
                            <div class="card-header">
                        <h5>Compras Mensal</h5>
                        <div class="card-header-right">
                            <div class="card-header-action" data-bs-toggle="tooltip" data-bs-placement="top" title="Atualizar">
                                <i class="ri-refresh-line"></i>
                            </div>
                            <div class="card-header-action" data-bs-toggle="tooltip" data-bs-placement="top" title="Expandir">
                                <i class="ri-fullscreen-line"></i>
                            </div>
                            <div class="card-header-action" data-bs-toggle="tooltip" data-bs-placement="top" title="Mais opções">
                                <i class="ri-more-2-fill"></i>
                            </div>
                        </div>
                            </div>
                            <div class="card-body">
                        <div class="chart-container" id="revenueChart" data-revenue='@json($somaComprasMesesAnteriores)'></div>
                            </div>
                        </div>
                    </div>
                    
            <!-- Cards estatísticos detalhados -->
            <div class="dashboard-third animate-on-scroll animate-fade-up delay-1">
                <div class="stat-card-ultramodern primary">
                    <div class="stat-icon">
                        <i class="ri-line-chart-line"></i>
                    </div>
                    <div class="stat-title">Vendas {{ $mes }}</div>
                    <div class="stat-value">R$ {{ number_format($totalVendasMes, 2, ',', '.') }}</div>
                    <div class="stat-description">Valor total de vendas no mês atual</div>
                    <div class="stat-change">
                        <i class="ri-arrow-up-line"></i>
                        <span class="stat-change-value stat-change-up">+{{ number_format($totalVendasMes > 0 ? 7.1 : 0, 1) }}%</span>
                    </div>
                    <div class="stat-chart" data-sparkline="25,49,55,78,38,66,69,80,65,59"></div>
                </div>
            </div>
                            
            <div class="dashboard-third animate-on-scroll animate-fade-up delay-2">
                <div class="stat-card-ultramodern success">
                    <div class="stat-icon">
                        <i class="ri-shopping-bag-2-fill"></i>
                    </div>
                    <div class="stat-title">Compras {{ $mes }}</div>
                    <div class="stat-value">R$ {{ number_format($totalComprasMes, 2, ',', '.') }}</div>
                    <div class="stat-description">Valor total de compras no mês atual</div>
                    <div class="stat-change">
                        <i class="ri-arrow-up-line"></i>
                        <span class="stat-change-value stat-change-up">+{{ number_format($totalComprasMes > 0 ? 3.5 : 0, 1) }}%</span>
                    </div>
                    <div class="stat-chart" data-sparkline="20,45,30,60,42,55,45,65,38,53"></div>
                </div>
            </div>

            <div class="dashboard-third animate-on-scroll animate-fade-up delay-3">
                <div class="stat-card-ultramodern info">
                    <div class="stat-icon">
                        <i class="ri-file-list-3-line"></i>
                    </div>
                    <div class="stat-title">Volume de Emissões</div>
                    <div class="stat-value">R$ {{ number_format($totalEmitidoMes, 2, ',', '.') }}</div>
                    <div class="stat-description">Valor total de notas emitidas</div>
                    <div class="stat-change">
                        <i class="ri-arrow-up-line"></i>
                        <span class="stat-change-value stat-change-up">+{{ number_format($totalEmitidoMes > 0 ? 4.8 : 0, 1) }}%</span>
                    </div>
                    <div class="stat-chart" data-sparkline="35,55,40,70,52,80,55,75,45,60"></div>
                </div>
                </div>

            <!-- Últimas atividades e gráfico de categorias -->
            <div class="dashboard-third animate-on-scroll animate-fade-up delay-1">
                <div class="activity-card">
                    <div class="card-header">
                        <h5>Clientes Aniversariantes do Mês</h5>
                    </div>
                    <div class="card-body custom-scrollbar" style="max-height: 380px; overflow-y: auto;">
                        @if($aniversariantesMes->count() > 0)
                            @foreach($aniversariantesMes as $cli)
                                <div class="activity-item">
                                    <div class="activity-icon info">
                                        <i class="ri-cake-2-line @if(\Carbon\Carbon::parse($cli->data_aniversario)->format('d') == date('d')) pulse-birthday @endif"></i>
                                    </div>
                                    <div class="activity-content">
                                        <div class="activity-title">{{ $cli->razao_social }}</div>
                                        <div class="activity-subtitle">{{ $cli->telefone }}</div>
                                        <div class="activity-meta">
                                            <span><i class="ri-calendar-event-line"></i> {{ \Carbon\Carbon::parse($cli->data_aniversario)->format('d/m') }}</span>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @else
                            <div class="text-center text-muted">Nenhum aniversariante neste mês.</div>
                        @endif
                    </div>
                </div>
            </div>

            <div class="dashboard-third animate-on-scroll animate-fade-up delay-2">
                <div class="chart-card-3d">
                            <div class="card-header">
                        <h5>Distribuição de Vendas Mensal</h5>
                        <div class="card-header-right">
                            <div class="card-header-action" data-bs-toggle="tooltip" data-bs-placement="top" title="Atualizar">
                                <i class="ri-refresh-line"></i>
                            </div>
                        </div>
                            </div>
                            <div class="card-body">
                        <div class="chart-container" id="categoriesChart" 
                             data-labels='["NFe", "NFCe", "CTe", "MDFe"]'
                             data-values='[{{ $totalNfeCount }}, {{ $totalNfceCount }}, {{ $totalCteCount }}, {{ $totalMdfeCount }}]'></div>
                    </div>
                </div>
            </div>
            
            <div class="dashboard-third animate-on-scroll animate-fade-up delay-3">
                <div class="ultramodern-card">
                    <div class="card-header">
                        <h5>Resumo de Vendas Anteriores</h5>
                        <div class="card-header-right">
                            <div class="card-header-action" data-bs-toggle="tooltip" data-bs-placement="top" title="Ver todas">
                                <i class="ri-arrow-right-line"></i>
                            </div>
                        </div>
                    </div>
                    <div class="card-body custom-scrollbar" style="max-height: 380px; overflow-y: auto;">
                        <div class="list-group">
                            @foreach($somaVendasMesesAnteriores as $key => $s)
                            <div class="list-group-item d-flex align-items-center p-3 rounded-2 mb-2">
                                <div class="flex-grow-1">
                                    <h6 class="mb-1">{{ $key }}</h6>
                                    <p class="text-muted small mb-0">R$ {{ number_format($s, 2, ',', '.') }}</p>
                                    <div class="mt-2">
                                        <span class="badge bg-soft-success text-success rounded-pill">Concluído</span>
                                        <small class="text-muted ms-2">Total mensal</small>
                                    </div>
                            </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Notícias e alertas -->
            <!-- @if($empresa->plano)
            <div class="dashboard-full-width animate-on-scroll animate-fade-up delay-2">
                <div class="ultramodern-card card-info">
                    <div class="card-header">
                        <h5>Informações do Plano</h5>
                        <div class="card-header-right">
                            <div class="card-header-action" data-bs-toggle="tooltip" data-bs-placement="top" title="Configurações">
                                <i class="ri-settings-3-line"></i>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                                <div class="col-md-3">
                                    <div class="dashboard-notification success">
                                        <div class="d-flex align-items-center">
                                            <i class="ri-file-list-3-line me-2 fs-5"></i>
                                            <div>
                                                <h6 class="mb-1">NFe</h6>
                                                <p class="mb-0 small">Limite {{ $empresa->plano->plano->maximo_nfes }}</p>
                                            </div>
                                            <div class="ms-auto">
                                                <span class="badge bg-soft-success text-success rounded-pill">{{ $totalNfeCount }} usados</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-md-3">
                                    <div class="dashboard-notification info">
                                        <div class="d-flex align-items-center">
                                            <i class="ri-file-paper-2-line me-2 fs-5"></i>
                                            <div>
                                                <h6 class="mb-1">NFCe</h6>
                                                <p class="mb-0 small">Limite {{ $empresa->plano->plano->maximo_nfces }}</p>
                                            </div>
                                            <div class="ms-auto">
                                                <span class="badge bg-soft-info text-info rounded-pill">{{ $totalNfceCount }} usados</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="dashboard-notification warning">
                                        <div class="d-flex align-items-center">
                                            <i class="ri-truck-line me-2 fs-5"></i>
                                            <div>
                                                <h6 class="mb-1">CTe</h6>
                                                <p class="mb-0 small">Limite {{ $empresa->plano->plano->maximo_ctes }}</p>
                                            </div>
                                            <div class="ms-auto">
                                                <span class="badge bg-soft-warning text-warning rounded-pill">{{ $totalCteCount }} usados</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            <div class="col-md-3">
                                <div class="dashboard-notification primary">
                                    <div class="d-flex align-items-center">
                                        <i class="ri-road-map-line me-2 fs-5"></i>
                                        <div>
                                            <h6 class="mb-1">MDFe</h6>
                                            <p class="mb-0 small">Limite {{ $empresa->plano->plano->maximo_mdfes }}</p>
                                        </div>
                                        <div class="ms-auto">
                                            <span class="badge bg-soft-primary text-primary rounded-pill">{{ $totalMdfeCount }} usados</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        @if($msgPlano != "")
                        <div class="row mt-3">
                            <div class="col-12">
                                <div class="dashboard-notification danger">
                                    <div class="d-flex align-items-center">
                                        <i class="ri-error-warning-line me-2 fs-5"></i>
                                        <div>
                                            <h6 class="mb-1">Alerta de Plano</h6>
                                            <p class="mb-0">{{ $msgPlano }}</p>
                                        </div>
                                        <div class="ms-auto">
                                            <a href="{{ route('payment.index') }}" class="btn btn-danger btn-sm">Contratar Plano</a>
                                         </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
            @endif -->

                <!-- Relatórios Financeiros -->
                @can('conta_receber_view')
            <div class="dashboard-full-width animate-on-scroll animate-fade-up delay-3">
                <div class="ultramodern-card">
                        <div class="card-header">
                        <h5>Relatórios Financeiros</h5>
                        <div class="card-header-right">
                            <div class="card-header-action" data-bs-toggle="tooltip" data-bs-placement="top" title="Mais opções">
                                <i class="ri-more-2-fill"></i>
                            </div>
                        </div>
                        </div>
                        <div class="card-body">
                            <div class="row g-2">
                                <div class="col-12 col-sm-6 col-md-4">
                                    <a href="{{ route('conta-receber.relatorio-inadimplencia') }}" class="btn btn-danger btn-lg w-100 mb-2">
                                        <i class="far fa-calendar-times me-1"></i> Relatório de Inadimplência
                                    </a>
                                    <p class="text-muted small">Visualize todos os clientes com contas em atraso agrupados por cliente.</p>
                                </div>
                                <div class="col-12 col-sm-6 col-md-4">
                                    <a href="{{ route('conta-receber.relatorio-projecao') }}" class="btn btn-primary btn-lg w-100 mb-2">
                                        <i class="fas fa-chart-line me-1"></i> Fluxo de Caixa Projetado
                                    </a>
                                    <p class="text-muted small">Acompanhe a projeção de entradas e saídas financeiras futuras.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @endcan
        </div>

        @else
        <div class="card">
            <div class="card-body">
                <h3>Painel</h3>

                <h5>Olá, <strong class="text-success">{{ get_name_user() }}</strong> seja bem vindo!</h5>

                <div class="row g-2">
                    <div class="col-6 col-md-3 mb-2">
                        <a href="{{ route('nfe.create') }}" class="btn btn-light btn-lg w-100 h-100 text-center">
                            <i class="ri-shopping-bag-line d-block mb-1 fs-3"></i>
                            Nova Venda
                        </a>
                    </div>
                    <div class="col-6 col-md-3 mb-2">
                        <a href="{{ route('frontbox.create') }}" class="btn btn-light btn-lg w-100 h-100 text-center">
                            <i class="ri-shopping-basket-2-fill d-block mb-1 fs-3"></i>
                            Abrir PDV
                        </a>
                    </div>
                    <div class="col-6 col-md-3 mb-2">
                        <a href="{{ route('produtos.create') }}" class="btn btn-light btn-lg w-100 h-100 text-center">
                            <i class="ri-price-tag-3-line d-block mb-1 fs-3"></i>
                            Novo Produto
                        </a>
                    </div>
                    <div class="col-6 col-md-3 mb-2">
                        <a href="{{ route('clientes.create') }}" class="btn btn-light btn-lg w-100 h-100 text-center">
                            <i class="ri-user-add-line d-block mb-1 fs-3"></i>
                            Novo Cliente
                        </a>
                    </div>
                </div>
            </div>
        </div>
        @endif
    </div>
</div>

@endsection

@if(__isAdmin())
@section('js')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/l10n/pt.js"></script>
<script src="/js/dashboard-modern.js"></script>
<script src="/js/theme-modern.js"></script>

<script type="text/javascript">
    $(function() {
        // Inicializando a variável global path_url para uso em todos os arquivos JS
        window.path_url = "{{ url('/') }}/";
        
        // Aplicar eventos de clique aos botões de data
        $('.date-range-btn').click(function() {
            // Remove a classe ativa de todos os botões
            $('.date-range-btn').removeClass('active');
            // Adiciona a classe ativa ao botão clicado
            $(this).addClass('active');
            
            // Obter o período do data-range
            const range = $(this).data('range');
            
            // Se for o botão personalizado, mostrar o campo de data
            if (range === 'custom') {
                $('#customDateRange').removeClass('hidden').addClass('visible');
                // Iniciar o flatpickr se não estiver iniciado
                if (!$('#customDateRange')[0].flatpickr) {
                    flatpickr('#customDateRange', {
                        mode: 'range',
                        dateFormat: 'd/m/Y',
                        locale: 'pt',
                        onClose: function(selectedDates, dateStr) {
                            // Usar a função do arquivo principal para atualizar os dados
                            window.updateDashboardData(dateStr);
                        }
                    });
                }
            } else {
                // Esconder o campo personalizado
                $('#customDateRange').removeClass('visible').addClass('hidden');
                // Usar a função do arquivo principal para atualizar os dados
                window.updateDashboardData(range);
            }
            
            return false; // Prevenir comportamento padrão
        });
    });
</script>
@endsection
@endif
@else

@include('contador.home')
@endif
