<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Cupom Não Fiscal</title>
    <style>
        /* Estilo geral */
        body {
            font-family: monospace;
            font-size: 9pt;
            width: 100%;         /* largura do cupom */
            margin: 0 auto;       /* centraliza o conteúdo horizontalmente */
            padding: 5px;
        }

        /* Cabeçalho */
        .cabecalho {
            margin-bottom: 5px;
            text-align: center;   /* cabeçalho centralizado */
        }
        .cabecalho strong {
            font-size: 11pt;
        }

        /* Itens */
        .itens table {
            width: 100%;
            border-collapse: collapse;
            margin: 0 auto;       /* centraliza tabela */
            text-align: left;     /* nomes de produtos à esquerda */
        }

        .itens th, .itens td {
            padding: 2px 0;
            font-size: 9pt;
            word-wrap: break-word;
        }

        .itens th {
            border-bottom: 1px solid #000;
        }

        .itens td.qtd,
        .itens td.valor,
        .itens td.subtotal {
            text-align: right;    /* valores à direita */
        }

        .produto-nome {
            display: block;
            word-wrap: break-word;
        }

        /* Totais */
        .totais {
            border-top: 1px solid #000;
            padding-top: 3px;
            margin-top: 5px;
            text-align: left;     /* alinhamento à esquerda */
        }
        .totais p {
            margin: 2px 0;
        }
        .totais p strong {
            display: inline-block;
            width: 100%;
            text-align: right;    /* valores alinhados à direita */
        }

        /* Rodapé */
        .rodape {
            font-size: 8pt;
            margin-top: 5px;
            text-align: center;
        }

        /* Linha horizontal */
        hr {
            border: none;
            border-top: 1px solid #000;
            margin: 5px 0;
        }

        /* Impressão */
        @media print {
            body {
                width: 80mm;
                margin: 0 auto;
            }
            tr {
                page-break-inside: avoid; /* evita quebrar itens no meio */
            }
        }
    </style>
</head>
<body>

    <!-- Cabeçalho -->
    <div class="cabecalho">
        <strong>{{ $cabecalho['nome'] }}</strong><br>
        CPF/CNPJ: {{ $cabecalho['cpf_cnpj'] }}<br>
        {{ $cabecalho['endereco'] }}<br>
        {{ $cabecalho['cidade_uf'] }}
    </div>
    <hr>

    <!-- Itens -->
    <div class="itens">
        <table>
            <thead>
                <tr>
                    <th>Produto</th>
                    <th class="qtd">Qtd</th>
                    <th class="valor">V. Unit</th>
                    <th class="subtotal">Subt</th>
                </tr>
            </thead>
            <tbody>
                @foreach($item->itens as $i)
                    <tr>
                        <td class="produto-nome">{{ $i->produto->nome ?? $i->produto_id }}</td>
                        <td class="qtd">{{ $i->quantidade }}</td>
                        <td class="valor">{{ number_format($i->valor_unitario, 2, ',', '.') }}</td>
                        <td class="subtotal">{{ number_format($i->sub_total, 2, ',', '.') }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <!-- Totais -->
    <div class="totais">
        <p>Acrescimo: <strong>{{ number_format($item->acrescimo, 2, ',', '.') }}</strong></p>
        <p>Desconto: <strong>{{ number_format($item->desconto, 2, ',', '.') }}</strong></p>
        <p>Total: <strong>{{ number_format($item->total, 2, ',', '.') }}</strong></p>
        @if($item->dinheiro_recebido > 0)
            <p>Dinheiro Recebido: <strong>{{ number_format($item->dinheiro_recebido, 2, ',', '.') }}</strong></p>
            <p>Troco: <strong>{{ number_format($item->troco, 2, ',', '.') }}</strong></p>
        @endif
    </div>
    <hr>

    <!-- Rodapé -->
    <div class="rodape">
        Emitido por: {{ $usuario->nome ?? 'Sistema' }}<br>
        {{ now()->format('d/m/Y H:i') }}
    </div>

</body>
</html>
