@extends('layouts.app', ['title' => 'Fornecedores'])
@section('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
<style>
    .btn-sm {
        width: 32px;
        height: 32px;
        padding: 6px;
        margin-right: 4px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }
    
    @media (max-width: 768px) {
        .table th, .table td {
            white-space: nowrap;
        }
        .btn-sm {
            font-size: 0.75rem;
        }
    }

    .table th, .table td {
        vertical-align: middle;
    }
</style>
@endsection
@section('content')

<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        @can('fornecedores_create')
                        <a href="{{ route('fornecedores.create') }}" class="btn btn-success">
                            <i class="ri-add-circle-fill"></i>
                            Novo Fornecedor
                        </a>
                        <a href="{{ route('fornecedores.import') }}" class="btn btn-info">
                            <i class="ri-file-upload-line"></i>
                            Upload
                        </a>
                        @endcan
                    </div>
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    {!!Form::open()->fill(request()->all())
                    ->get()
                    !!}
                    <div class="row g-2">
                        <div class="col-12 col-sm-6 col-md-4 col-lg-4">
                            {!!Form::text('razao_social', 'Pesquisar por nome')
                            !!}
                        </div>
                        <div class="col-12 col-sm-6 col-md-3 col-lg-3">
                            {!!Form::text('cpf_cnpj', 'Pesquisar por CPF/CNPJ')
                            ->attrs(['class' => 'cpf_cnpj'])
                            ->type('tel')
                            !!}
                        </div>
                        <div class="col-12 col-sm-6 col-md-3 col-lg-2 d-flex align-items-end">
                            <button class="btn btn-primary w-100" type="submit"> 
                                <i class="ri-search-line"></i> Pesquisar
                            </button>
                        </div>
                        <div class="col-12 col-sm-6 col-md-3 col-lg-2 d-flex align-items-end">
                            <a id="clear-filter" class="btn btn-danger w-100" href="{{ route('fornecedores.index') }}">
                                <i class="ri-eraser-fill"></i> Limpar
                            </a>
                        </div>
                    </div>
                    {!!Form::close()!!}
                </div>
                <div class="col-md-12 mt-4">
                    <div class="table-responsive">
                        <table class="table table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    @can('fornecedores_delete')
                                    <th>
                                        <div class="form-check form-checkbox-danger mb-2">
                                            <input class="form-check-input" type="checkbox" id="select-all-checkbox">
                                        </div>
                                    </th>
                                    @endcan
                                    <th>Razão Social</th>
                                    <th>CPF/CNPJ</th>
                                    <th>Cidade</th>
                                    <th>Endereço</th>
                                    <th>CEP</th>
                                    <th width="10%">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($data as $item)
                                <tr>
                                    @can('fornecedores_delete')
                                    <td>
                                        <div class="form-check form-checkbox-danger mb-2">
                                            <input class="form-check-input check-delete" type="checkbox" name="item_delete[]" value="{{ $item->id }}">
                                        </div>
                                    </td>
                                    @endcan
                                    <td class="text-truncate" style="max-width: 180px">{{ $item->razao_social }}</td>
                                    <td>{{ $item->cpf_cnpj }}</td>
                                    <td>{{ $item->cidade ? $item->cidade->info : '' }}</td>
                                    <td class="text-truncate" style="max-width: 150px">{{ $item->endereco }}</td>
                                    <td>{{ $item->cep }}</td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-outline-secondary btn-sm dropdown-toggle w-100" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                Ações
                                            </button>
                                            <ul class="dropdown-menu dropdown-menu-end shadow-sm small">
                                                @can('fornecedores_edit')
                                                <li>
                                                    <a class="dropdown-item text-warning" href="{{ route('fornecedores.edit', [$item->id]) }}">
                                                        <i class="ri-pencil-fill me-1"></i> Editar
                                                    </a>
                                                </li>
                                                @endcan

                                                @can('fornecedores_delete')
                                                <li>
                                                    <form action="{{ route('fornecedores.destroy', $item->id) }}" method="post" id="form-{{$item->id}}">
                                                        @method('delete')
                                                        @csrf
                                                        <button type="button" class="dropdown-item text-danger btn-delete">
                                                            <i class="ri-delete-bin-line me-1"></i> Excluir
                                                        </button>
                                                    </form>
                                                </li>
                                                @endcan

                                                <li>
                                                    <a class="dropdown-item text-primary" href="{{ route('fornecedores.historico', [$item->id]) }}">
                                                        <i class="ri-file-list-3-fill me-1"></i> Histórico
                                                    </a>
                                                </li>

                                                @can('crm_create')
                                                <li>
                                                    <button type="button" class="dropdown-item text-secondary" onclick="modalCrm('{{ $item->id }}')">
                                                        <i class="ri-user-voice-fill me-1"></i> CRM
                                                    </button>
                                                </li>
                                                @endcan
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center">Nada encontrado</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                        <div class="mt-3">
                            @can('fornecedores_delete')
                            <form action="{{ route('fornecedores.destroy-select') }}" method="post" id="form-delete-select">
                                @method('delete')
                                @csrf
                                <div></div>
                                <button type="button" class="btn btn-danger btn-sm btn-delete-all" disabled>
                                    <i class="ri-close-circle-line"></i> Remover selecionados
                                </button>
                            </form>
                            @endcan
                            {!! $data->appends(request()->all())->links() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@include('modals._crm')

@endsection
@section('js')
<script type="text/javascript" src="/js/delete_selecionados.js"></script>
<script type="text/javascript">
    function modalCrm(fornecedor_id){
        $('#fornecedor_id').val(fornecedor_id)
        $('#modal_crm').modal('show')
        montaSelect2()
    }
</script>
<script type="text/javascript" src="/js/modal_crm.js"></script>
@endsection
