@component('mail::message')
# Alerta: Empresas Inativas

O sistema **{{ env("APP_NAME") }}** identificou empresas sem atividade há mais de 30 dias.

## Detalhes do Alerta:

Foram encontradas **{{ count($empresasInativas) }}** empresas sem qualquer atividade registrada desde **{{ $dataLimite }}**.

@component('mail::table')
| ID | Razão Social | CNPJ/CPF | Data Cadastro | Dias Inativa |
| -- | ------------ | -------- | ------------- | ------------ |
@foreach($empresasInativas as $empresa)
| {{ $empresa['id'] }} | {{ $empresa['razao_social'] }} | {{ $empresa['cpf_cnpj'] }} | {{ \Carbon\Carbon::parse($empresa['created_at'])->format('d/m/Y') }} | {{ $empresa['dias_inativa'] }} |
@endforeach
@endcomponent

@component('mail::button', ['url' => url('/empresas')])
Ver Empresas no Sistema
@endcomponent

Sugerimos uma verificação com estas empresas para confirmar se estão enfrentando dificuldades com o sistema ou se precisam de suporte adicional.

Este alerta foi gerado automaticamente em {{ $dataAtual }}.

Atenciosamente,  
Equipe {{ config('app.name') }}
@endcomponent 