<html>
<head>
    <meta charset="utf-8" />
    <style>
        body { font-family: DejaVu Sans, Arial, sans-serif; font-size: 11px; }
        .center { text-align: center; }
        .right { text-align: right; }
        .bold { font-weight: bold; }
        .line { border-top: 1px dashed #000; margin: 6px 0; }
        table { width: 100%; border-collapse: collapse; }
        td { padding: 2px 0; vertical-align: top; }
        .small { font-size: 10px; }
    </style>
    <title>Cupom Não Fiscal</title>
    </head>
<body>
    <div class="center bold">
        {{ $empresa->nome ?? $empresa->razao_social ?? 'Empresa' }}<br>
        {{ $empresa->cpf_cnpj ?? '' }}<br>
        {{ $empresa->logradouro ?? '' }} {{ $empresa->numero ?? '' }} - {{ $empresa->bairro ?? '' }}<br>
        {{ $empresa->cidade ?? '' }} - {{ $empresa->uf ?? '' }}
    </div>
    <div class="line"></div>

    <div class="center bold">CUPOM {{ $isPreVenda ? 'PRÉ-VENDA' : 'NÃO FISCAL' }}</div>
    @if($cliente)
        <div class="small">Cliente: {{ $cliente->razao_social ?? $cliente->nome_fantasia ?? $venda->cliente_nome ?? '' }}</div>
        <div class="small">CPF/CNPJ: {{ $cliente->cpf_cnpj ?? $venda->cliente_cpf_cnpj ?? '' }}</div>
    @elseif(!empty($venda->cliente_nome) || !empty($venda->cliente_cpf_cnpj))
        <div class="small">Cliente: {{ $venda->cliente_nome ?? '' }}</div>
        <div class="small">CPF/CNPJ: {{ $venda->cliente_cpf_cnpj ?? '' }}</div>
    @endif

    <div class="line"></div>
    <table>
        <tbody>
        @php($total = 0)
        @foreach($itens as $i)
            @php($q = (float)($i->quantidade ?? 0))
            @php($vu = (float)($i->valor_unitario ?? 0))
            @php($st = (float)($i->sub_total ?? ($q * $vu)))
            @php($total += $st)
            <tr>
                <td colspan="2">{{ $i->produto->nome ?? $i->descricao ?? 'Item' }}</td>
            </tr>
            <tr>
                <td class="small">{{ number_format($q, 2, ',', '.') }} x {{ number_format($vu, 2, ',', '.') }}</td>
                <td class="small right">{{ number_format($st, 2, ',', '.') }}</td>
            </tr>
        @endforeach
        </tbody>
    </table>

    <div class="line"></div>
    @php($desconto = (float)($venda->desconto ?? 0))
    @php($acrescimo = (float)($venda->acrescimo ?? 0))
    @php($totalGeral = (float)($venda->total ?? ($total - $desconto + $acrescimo)))
    <table>
        <tr>
            <td class="bold">Subtotal</td>
            <td class="right">{{ number_format($total, 2, ',', '.') }}</td>
        </tr>
        @if($desconto > 0)
        <tr>
            <td class="bold">Desconto</td>
            <td class="right">- {{ number_format($desconto, 2, ',', '.') }}</td>
        </tr>
        @endif
        @if($acrescimo > 0)
        <tr>
            <td class="bold">Acréscimo</td>
            <td class="right">+ {{ number_format($acrescimo, 2, ',', '.') }}</td>
        </tr>
        @endif
        <tr>
            <td class="bold">Total</td>
            <td class="right bold">{{ number_format($totalGeral, 2, ',', '.') }}</td>
        </tr>
    </table>

    @if(!empty($faturas) && count($faturas) > 0)
        <div class="line"></div>
        <div class="bold">Pagamentos</div>
        @foreach($faturas as $f)
            <div class="small">
                {{ $f->tipo_pagamento ?? '' }} - {{ number_format((float)($f->valor ?? 0), 2, ',', '.') }}
            </div>
        @endforeach
    @endif

    @if(isset($venda->troco) && (float)$venda->troco > 0)
        <div class="small">Troco: {{ number_format((float)$venda->troco, 2, ',', '.') }}</div>
    @endif

    <div class="line"></div>
    <div class="center small">Obrigado pela preferência!</div>
</body>
</html>


