@php
$title = 'Fluxo de Caixa Projetado - ' . config('app.name');
@endphp
@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.css">
@endsection

@section('content')

<div class="container-fluid px-4">
    <div class="mb-2 mt-2">
        <div class="row">
            <div class="col-md-6">
                <h3 class="h4"><i class="fas fa-chart-line"></i> Relatório de Fluxo de Caixa Projetado</h3>
            </div>
            <div class="col-md-6 text-right">
                <a href="{{ route('home') }}" class="btn btn-outline-primary btn-sm"><i class="fas fa-undo"></i> Voltar</a>
                <button onclick="window.print()" class="btn btn-outline-success btn-sm"><i class="fas fa-print"></i> Imprimir</button>
                <a href="#" class="btn btn-outline-secondary btn-sm" onclick="exportarPDF()"><i class="fas fa-file-pdf"></i> Exportar PDF</a>
                <a href="#" class="btn btn-outline-secondary btn-sm" onclick="exportarExcel()"><i class="fas fa-file-excel"></i> Exportar Excel</a>
                <button type="button" class="btn btn-outline-info btn-sm" onclick="toggleDebug()"><i class="fas fa-bug"></i> Debug</button>
            </div>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-header">
            <form method="GET" action="{{ route('conta-receber.relatorio-projecao') }}" class="row g-3">
                <div class="col-md-3">
                    <label for="start_date" class="form-label">Data Inicial</label>
                    <input type="date" class="form-control" id="start_date" name="start_date" value="{{ $start_date }}">
                </div>
                <div class="col-md-3">
                    <label for="end_date" class="form-label">Data Final</label>
                    <input type="date" class="form-control" id="end_date" name="end_date" value="{{ $end_date }}">
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">Filtrar</button>
                    <a href="{{ route('conta-receber.relatorio-projecao') }}" class="btn btn-secondary">Limpar</a>
                </div>
            </form>
        </div>
        <div class="card-body">
            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="card bg-success text-white">
                        <div class="card-body">
                            <h5 class="card-title">Total a Receber</h5>
                            <h2 class="card-text">R$ {{ __moeda($totaisReceber) }}</h2>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card bg-danger text-white">
                        <div class="card-body">
                            <h5 class="card-title">Total a Pagar</h5>
                            <h2 class="card-text">R$ {{ __moeda($totaisPagar) }}</h2>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card {{ ($totaisReceber - $totaisPagar) >= 0 ? 'bg-primary' : 'bg-warning' }} text-white">
                        <div class="card-body">
                            <h5 class="card-title">Saldo Projetado</h5>
                            <h2 class="card-text">R$ {{ __moeda($totaisReceber - $totaisPagar) }}</h2>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="card {{ $saldoPrevistoTotal >= 0 ? 'bg-info' : 'bg-warning' }} text-white">
                        <div class="card-body">
                            <h5 class="card-title">Saldo Previsto</h5>
                            <h2 class="card-text">R$ {{ __moeda($saldoPrevistoTotal) }}</h2>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card {{ $saldoRealizadoTotal >= 0 ? 'bg-success' : 'bg-danger' }} text-white">
                        <div class="card-body">
                            <h5 class="card-title">Saldo Realizado</h5>
                            <h2 class="card-text">R$ {{ __moeda($saldoRealizadoTotal) }}</h2>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="alert alert-info mb-3">
                        <p class="mb-0"><i class="fas fa-info-circle"></i> O gráfico abaixo mostra a projeção de receitas previstas (barras verde claras) e realizadas (barras verde escuras), despesas previstas (barras vermelho claras) e realizadas (barras vermelho escuras), além dos saldos acumulado (linha azul), previsto (linha laranja) e realizado (linha verde) para o período.</p>
                    </div>
                    <div class="chart-container" style="position: relative; height:400px; width:100%">
                        <canvas id="fluxoCaixaChart"></canvas>
                    </div>
                </div>
            </div>

            <div class="table-responsive mt-4">
                <table class="table table-striped table-hover">
                    <thead>
                        <tr>
                            <th>Data</th>
                            <th class="text-end">Entradas (R$)</th>
                            <th class="text-end">Saídas (R$)</th>
                            <th class="text-end">Saldo do Dia (R$)</th>
                            <th class="text-end">Saldo Acumulado (R$)</th>
                            <th class="text-end">Saldo Previsto (R$)</th>
                            <th class="text-end">Saldo Realizado (R$)</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($datas as $data => $valores)
                            <tr>
                                <td>{{ __data_pt($data) }}</td>
                                <td class="text-end text-success">{{ __moeda($valores['receber']) }}</td>
                                <td class="text-end text-danger">{{ __moeda($valores['pagar']) }}</td>
                                <td class="text-end {{ ($valores['receber'] - $valores['pagar']) >= 0 ? 'text-success' : 'text-danger' }}">
                                    {{ __moeda($valores['receber'] - $valores['pagar']) }}
                                </td>
                                <td class="text-end {{ $valores['saldo'] >= 0 ? 'text-success' : 'text-danger' }}">
                                    {{ __moeda($valores['saldo']) }}
                                </td>
                                <td class="text-end {{ $valores['saldo_previsto'] >= 0 ? 'text-success' : 'text-danger' }}">
                                    {{ __moeda($valores['saldo_previsto']) }}
                                </td>
                                <td class="text-end {{ $valores['saldo_realizado'] >= 0 ? 'text-success' : 'text-danger' }}">
                                    {{ __moeda($valores['saldo_realizado']) }}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr class="table-dark">
                            <th>Total</th>
                            <th class="text-end">{{ __moeda($totaisReceber) }}</th>
                            <th class="text-end">{{ __moeda($totaisPagar) }}</th>
                            <th class="text-end">{{ __moeda($totaisReceber - $totaisPagar) }}</th>
                            <th></th>
                            <th class="text-end">{{ __moeda($saldoPrevistoTotal) }}</th>
                            <th class="text-end">{{ __moeda($saldoRealizadoTotal) }}</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
            
            <!-- Adicionar código de depuração com toggle -->
            <div id="debugInfo" style="display: none;">
                <div class="card mt-4">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0">Informações de Depuração</h5>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info">
                            <p><strong>Total a Receber:</strong> R$ {{ __moeda($totaisReceber) }}</p>
                            <p><strong>Total a Pagar:</strong> R$ {{ __moeda($totaisPagar) }}</p>
                            <p><strong>Saldo Previsto:</strong> R$ {{ __moeda($saldoPrevistoTotal) }}</p>
                            <p><strong>Saldo Realizado:</strong> R$ {{ __moeda($saldoRealizadoTotal) }}</p>
                            <p><strong>Total de Contas a Receber:</strong> {{ count($contasReceber) }}</p>
                            <p><strong>Total de Contas a Pagar:</strong> {{ count($contasPagar) }}</p>
                            <p><strong>Período:</strong> {{ __data_pt($start_date) }} até {{ __data_pt($end_date) }}</p>
                            
                            @if(count($contasReceber) > 0)
                            <hr>
                            <h6>Detalhes das Contas a Receber:</h6>
                            <table class="table table-sm table-bordered">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Descrição</th>
                                        <th>Data</th>
                                        <th>Valor Integral</th>
                                        <th>Valor Recebido</th>
                                        <th>Pendente</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($contasReceber as $index => $conta)
                                        @if($index < 10) <!-- Limita a exibição para os primeiros 10 itens -->
                                        <tr>
                                            <td>{{ $conta->id }}</td>
                                            <td>{{ $conta->descricao }}</td>
                                            <td>{{ __data_pt($conta->data_vencimento) }}</td>
                                            <td class="text-end">{{ __moeda($conta->valor_integral) }}</td>
                                            <td class="text-end">{{ __moeda($conta->valor_recebido ?? 0) }}</td>
                                            <td class="text-end">{{ __moeda($conta->valorPendente()) }}</td>
                                        </tr>
                                        @endif
                                    @endforeach
                                </tbody>
                            </table>
                            @if(count($contasReceber) > 10)
                                <p>... mais {{ count($contasReceber) - 10 }} contas</p>
                            @endif
                            @else
                            <hr>
                            <div class="alert alert-warning">
                                <i class="fas fa-exclamation-triangle"></i> Nenhuma conta a receber encontrada para o período selecionado.
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            <!-- Fim do código de depuração -->

            <div class="row mt-4">
                <div class="col-md-6">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Contas a Receber no Período</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-sm table-hover">
                                    <thead>
                                        <tr>
                                            <th>Cliente</th>
                                            <th>Vencimento</th>
                                            <th>Categoria</th>
                                            <th class="text-end">Valor (R$)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($contasReceber as $conta)
                                            <tr>
                                                <td>{{ $conta->cliente->razao_social ?? 'N/A' }}</td>
                                                <td>{{ __data_pt($conta->data_vencimento) }}</td>
                                                <td>{{ $conta->categoria->nome ?? 'N/A' }}</td>
                                                <td class="text-end">{{ __moeda($conta->valorPendente()) }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Contas a Pagar no Período</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-sm table-hover">
                                    <thead>
                                        <tr>
                                            <th>Fornecedor</th>
                                            <th>Vencimento</th>
                                            <th>Categoria</th>
                                            <th class="text-end">Valor (R$)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($contasPagar as $conta)
                                            <tr>
                                                <td>{{ $conta->fornecedor->razao_social ?? 'N/A' }}</td>
                                                <td>{{ __data_pt($conta->data_vencimento) }}</td>
                                                <td>{{ $conta->categoria->nome ?? 'N/A' }}</td>
                                                <td class="text-end">{{ __moeda($conta->valorPendente()) }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.js"></script>
<script>
    // Função para mostrar/ocultar a área de debug
    function toggleDebug() {
        const debugElement = document.getElementById('debugInfo');
        if (debugElement.style.display === 'none') {
            debugElement.style.display = 'block';
        } else {
            debugElement.style.display = 'none';
        }
    }
    
    // Preparar dados para o gráfico a partir de variáveis PHP
    const dadosGrafico = {
        datas: {!! json_encode(array_keys($datas)) !!},
        receber: {!! json_encode(array_values(array_map(function($valor) { return $valor['receber']; }, $datas))) !!},
        receberRealizado: {!! json_encode(array_values(array_map(function($valor) { return $valor['receber_realizado']; }, $datas))) !!},
        pagar: {!! json_encode(array_values(array_map(function($valor) { return -$valor['pagar']; }, $datas))) !!},
        pagarRealizado: {!! json_encode(array_values(array_map(function($valor) { return -$valor['pagar_realizado']; }, $datas))) !!},
        saldo: {!! json_encode(array_values(array_map(function($valor) { return $valor['saldo']; }, $datas))) !!},
        saldoPrevisto: {!! json_encode(array_values(array_map(function($valor) { return $valor['saldo_previsto']; }, $datas))) !!},
        saldoRealizado: {!! json_encode(array_values(array_map(function($valor) { return $valor['saldo_realizado']; }, $datas))) !!}
    };

    // Executar quando o documento estiver pronto
    document.addEventListener('DOMContentLoaded', function() {
        try {
            console.log("Dados do gráfico:", dadosGrafico);
            
            // Verificar se temos dados para exibir
            if (!dadosGrafico.datas || dadosGrafico.datas.length === 0) {
                console.error("Não há dados disponíveis para o gráfico");
                document.getElementById('fluxoCaixaChart').parentNode.innerHTML = 
                    '<div class="alert alert-warning">Não há dados disponíveis para exibir o gráfico no período selecionado.</div>';
                return;
            }
            
            // Formatar as datas para exibição (DD/MM)
            const datasFormatadas = dadosGrafico.datas.map(data => {
                const partes = data.split('-');
                return `${partes[2]}/${partes[1]}`;
            });
            
            // Configurar o gráfico
            const canvasElement = document.getElementById('fluxoCaixaChart');
            if (!canvasElement) {
                console.error("Elemento canvas 'fluxoCaixaChart' não encontrado");
                return;
            }
            
            const ctx = canvasElement.getContext('2d');
            if (!ctx) {
                console.error("Não foi possível obter o contexto 2d do canvas");
                return;
            }
            
            console.log("Renderizando gráfico com", datasFormatadas.length, "pontos de dados");
            
            const fluxoCaixaChart = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: datasFormatadas,
                    datasets: [
                        {
                            label: 'Receitas Previstas',
                            data: dadosGrafico.receber,
                            backgroundColor: 'rgba(40, 167, 69, 0.4)',
                            borderColor: 'rgba(40, 167, 69, 0.7)',
                            borderWidth: 1,
                            stack: 'Stack 0',
                            order: 6
                        },
                        {
                            label: 'Receitas Realizadas',
                            data: dadosGrafico.receberRealizado,
                            backgroundColor: 'rgba(40, 167, 69, 0.9)',
                            borderColor: 'rgba(40, 167, 69, 1)',
                            borderWidth: 1,
                            stack: 'Stack 0',
                            order: 5
                        },
                        {
                            label: 'Despesas Previstas',
                            data: dadosGrafico.pagar,
                            backgroundColor: 'rgba(220, 53, 69, 0.4)',
                            borderColor: 'rgba(220, 53, 69, 0.7)',
                            borderWidth: 1,
                            stack: 'Stack 1',
                            order: 4
                        },
                        {
                            label: 'Despesas Realizadas',
                            data: dadosGrafico.pagarRealizado,
                            backgroundColor: 'rgba(220, 53, 69, 0.9)',
                            borderColor: 'rgba(220, 53, 69, 1)',
                            borderWidth: 1,
                            stack: 'Stack 1',
                            order: 3
                        },
                        {
                            label: 'Saldo Acumulado',
                            data: dadosGrafico.saldo,
                            backgroundColor: 'rgba(0, 123, 255, 0.1)',
                            borderColor: 'rgba(0, 123, 255, 1)',
                            borderWidth: 3,
                            tension: 0.4,
                            type: 'line',
                            yAxisID: 'y1',
                            fill: false,
                            order: 0,
                            pointBackgroundColor: 'rgba(0, 123, 255, 1)',
                            pointRadius: 4
                        },
                        {
                            label: 'Saldo Previsto',
                            data: dadosGrafico.saldoPrevisto,
                            backgroundColor: 'rgba(255, 153, 0, 0.1)',
                            borderColor: 'rgba(255, 153, 0, 1)',
                            borderWidth: 3,
                            tension: 0.4,
                            type: 'line',
                            yAxisID: 'y1',
                            fill: false,
                            order: 1,
                            pointBackgroundColor: 'rgba(255, 153, 0, 1)',
                            pointRadius: 3,
                            borderDash: [5, 5]
                        },
                        {
                            label: 'Saldo Realizado',
                            data: dadosGrafico.saldoRealizado,
                            backgroundColor: 'rgba(40, 167, 69, 0.1)',
                            borderColor: 'rgba(40, 167, 69, 1)',
                            borderWidth: 3,
                            tension: 0.4,
                            type: 'line',
                            yAxisID: 'y1',
                            fill: false,
                            order: 2,
                            pointBackgroundColor: 'rgba(40, 167, 69, 1)',
                            pointRadius: 3,
                            borderDash: [10, 5]
                        }
                    ]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    interaction: {
                        mode: 'index',
                        intersect: false,
                    },
                    plugins: {
                        title: {
                            display: true,
                            text: 'Projeção de Fluxo de Caixa',
                            font: {
                                size: 18
                            }
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    let label = context.dataset.label || '';
                                    if (label) {
                                        label += ': ';
                                    }
                                    if (context.parsed.y !== null) {
                                        let valor = context.parsed.y;
                                        // Converter despesas para valor positivo no tooltip
                                        if (context.dataset.label === 'Despesas Previstas' || context.dataset.label === 'Despesas Realizadas') {
                                            valor = Math.abs(valor);
                                        }
                                        // Formatar como moeda brasileira
                                        label += new Intl.NumberFormat('pt-BR', {
                                            style: 'currency',
                                            currency: 'BRL'
                                        }).format(valor);
                                    }
                                    return label;
                                }
                            }
                        },
                        legend: {
                            position: 'top',
                        }
                    },
                    scales: {
                        x: {
                            title: {
                                display: true,
                                text: 'Data'
                            }
                        },
                        y: {
                            beginAtZero: true,
                            title: {
                                display: true,
                                text: 'Valores (R$)'
                            },
                            grid: {
                                drawOnChartArea: false
                            }
                        },
                        y1: {
                            position: 'right',
                            beginAtZero: false,
                            title: {
                                display: true,
                                text: 'Saldo Acumulado (R$)'
                            },
                            grid: {
                                drawOnChartArea: false
                            }
                        }
                    }
                }
            });
        } catch (error) {
            console.error("Erro ao renderizar o gráfico:", error);
            document.getElementById('fluxoCaixaChart').parentNode.innerHTML = 
                '<div class="alert alert-danger">Erro ao renderizar o gráfico. Por favor, tente novamente mais tarde.</div>';
        }
    });
    
    function exportarPDF() {
        // Para ser implementado usando biblioteca de exportação PDF
        alert('Funcionalidade de exportação PDF em desenvolvimento');
    }

    function exportarExcel() {
        // Para ser implementado usando biblioteca de exportação Excel
        alert('Funcionalidade de exportação Excel em desenvolvimento');
    }
</script>
@endsection 