<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Consignação nº {{ $consignacao->numero_consignacao }}</title>
    <style>
        body {
            font-family: Arial, Helvetica, sans-serif;
            font-size: 11px;
            margin: 0;
            padding: 0;
            color: #000;
        }
        .ticket {
            width: 100%;
            padding: 5px;
        }
        .center { text-align: center; }
        .right { text-align: right; }
        .left { text-align: left; }
        .line {
            border-top: 1px dashed #000;
            margin: 5px 0;
        }
        h1 {
            font-size: 14px;
            margin: 0;
            text-transform: uppercase;
        }
        .info {
            margin: 5px 0;
            font-size: 11px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 5px;
            font-size: 11px;
        }
        th {
            text-align: left;
            border-bottom: 1px solid #000;
            padding-bottom: 2px;
        }
        td {
            padding: 2px 0;
        }
        .total {
            font-size: 12px;
            font-weight: bold;
            margin-top: 5px;
        }
        footer {
            margin-top: 10px;
            font-size: 10px;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="ticket">
        <!-- Cabeçalho -->
        <div class="center">
            <h1>Consignação</h1>
            <strong>Nº {{ $consignacao->numero_consignacao }}</strong><br>
            <span>{{ $consignacao->data_consignacao->format('d/m/Y H:i') }}</span>
        </div>

        <div class="line"></div>

        <!-- Cliente e Vendedor -->
        <div class="info">
            <p><strong>Cliente:</strong> {{ $consignacao->cliente->nome_fantasia ?? $consignacao->cliente->razao_social ?? '---' }}</p>
            <p><strong>Vendedor:</strong> {{ $consignacao->funcionario->nome ?? '---' }}</p>
            <p><strong>Emitido por:</strong> {{ $consignacao->usuario->name ?? '---' }}</p>
            @if($consignacao->data_vencimento)
                <p><strong>Vencimento:</strong> {{ $consignacao->data_vencimento->format('d/m/Y') }}</p>
            @endif
        </div>

        <div class="line"></div>

        <!-- Itens -->
        <table>
            <thead>
                <tr>
                    <th>Produto</th>
                    <th class="right">Qtd</th>
                    <th class="right">Valor</th>
                    <th class="right">Subtotal</th>
                </tr>
            </thead>
            <tbody>
                @foreach($consignacao->itens as $item)
                <tr>
                    <td>{{ \Illuminate\Support\Str::limit($item->produto->nome, 20) }}</td>
                    <td class="right">{{ $item->quantidade }}</td>
                    <td class="right">{{ __moeda($item->valor_unitario) }}</td>
                    <td class="right">{{ __moeda($item->quantidade * $item->valor_unitario) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <div class="line"></div>

        <!-- Total -->
        <div class="right total">
            Total: {{ __moeda($consignacao->valor_total) }}
        </div>

        <div class="line"></div>

        <!-- Rodapé -->
        <footer>
            <p>DECLARO PARA OS DEVIDOS FINS QUE EFETUEI A SAIDA CONSIGNADA DAS MERCADORIAS CONSTANTES NESTE COMPROVANTE E QUE AUTORIZO A COBRANÇA POR PARTE DO ESTABELECIMENTO DESTAS MERCADORIAS, DEVIDO A NÃO DEVOLUÇÃO DAS MESMAS, OU DEVOLUÇÃO DAS MESMAS COM PROBLEMAS NÃO CONSTANTES NO MOMENTO DA RETIRADA.</p>
            <p>Documento não fiscal</p>
            <p>Obrigado pela preferência!</p>
        </footer>
    </div>
</body>
</html>
