var DESCONTO = 0;
var VALORCREDITO = 0;
var VALORACRESCIMO = 0;
var PERCENTUALMAXDESCONTO = false;
var QUANTIDADE_DIGITADA = null;
// No início do arquivo, defina a variável global
var CREDITO_UTILIZADO = 0;
// Variável para controlar pré-venda carregada
var preVendaCarregada = null;

// Função para mostrar uma dica rápida sobre como usar a funcionalidade de quantidade
function mostrarDicaQuantidade() {
    toastr.info(
        '<b>Dicas de uso rápido:</b><br>' +
        '1. Digite a quantidade seguida de asterisco (ex: <b>5*</b>)<br>' +
        '2. Depois digite ou escaneie o código de barras<br>' +
        '3. Você também pode digitar tudo de uma vez (ex: <b>5*7899123456789</b>)<br>' +
        '4. Para adicionar com quantidade 1, apenas digite o código',
        'Como usar o PDV', 
        {
            timeOut: 5000,
            positionClass: "toast-top-right",
            closeButton: true,
            progressBar: true,
            newestOnTop: true,
            preventDuplicates: true
        }
    );
} 

$('.leitor_desativado').click(() => {
    $('.leitor_ativado').removeClass('d-none')
    $('.leitor_desativado').addClass('d-none')
    $('#codBarras').focus()
})

function ativaTef(){

    $.get(path_url + "api/tef/verifica-ativo",
    {
        empresa_id: $('#empresa_id').val(),
        usuario_id: $('#usuario_id').val(),
    })
    .done((data) => {

    })
    .fail((e) => {
        // console.log(e);
        $(".tp-pag option[value='30']").remove();
        $(".tp-pag option[value='31']").remove();
        $(".tp-pag option[value='32']").remove();
    });
}

$(function () {
    // Detectar consignacao_id na URL e carregar automaticamente
    const urlParams = new URLSearchParams(window.location.search);
    const consignacaoId = urlParams.get('consignacao_id');
    if (consignacaoId) {
        carregarConsignacao(consignacaoId);
    }
    // Foca automaticamente no campo de código de barras quando a página carregar
    setTimeout(() => {
        $('#codBarras').focus();
        
        // Mostra uma mensagem de boas-vindas com instruções básicas
        toastr.success(
            'Sistema de PDV pronto para uso!',
            '', 
            {
                timeOut: 3000,
                positionClass: "toast-top-right",
                closeButton: false,
                progressBar: true
            }
        );
        
        // Remove a exibição automática da dica de quantidade
    }, 500);

    // Mantém apenas o comportamento para o clique no ícone de código de barras
    $('.input-group-text').on('click', function() {
        $('#codBarras').focus();
    });
    
    // Adiciona uma classe de animação suave ao indicador de quantidade
    $('#quantidade_multipla').addClass('animated-badge');

    // Configurações TEF e outras inicializações
    let config_tef = $("#config_tef").val()
    if(config_tef == 1){
        ativaTef()
    }else{
        $(".tp-pag option[value='30']").remove();
        $(".tp-pag option[value='31']").remove();
        $(".tp-pag option[value='32']").remove();
    }
    $("#inp-variacao_id").val('')
    $("#lista_id").val('')

    if($('#pedido_desconto').length){
        // Se houver crédito do cliente, priorize ele
        if (typeof VALORCREDITO !== 'undefined' && VALORCREDITO > 0) {
            DESCONTO = VALORCREDITO;
        } else {
            DESCONTO = $('#pedido_desconto').val();
        }
        VALORACRESCIMO = $('#pedido_valor_entrega').val();
        $("#valor_desconto").text("R$ " + convertFloatToMoeda(DESCONTO));
        $("#valor_acrescimo").text("R$ " + convertFloatToMoeda(VALORACRESCIMO));
    }

    // Configura comportamentos dos indicadores de leitor ativado/desativado
    $('#mousetrapTitle').click(() => {
        $('#codBarras').focus()
    })
    
    $('#codBarras').focus(() => {
        $('#mousetrapTitle').css('display', 'none');
        $('.leitor_ativado').removeClass('d-none')
        $('.leitor_desativado').addClass('d-none')
    });
    
    $('#codBarras').focusout(() => {
        $('#mousetrapTitle').css('display', 'flex');
        $('.leitor_desativado').removeClass('d-none')
        $('.leitor_ativado').addClass('d-none')
    });

    validateButtonSave()
    calcTotal()

    if(!$('#venda_id').val()){
        $('#inp-tipo_pagamento').val('').change()
    }else{
        setTimeout(() => {
            DESCONTO = convertMoedaToFloat($('#valor_desconto').text())
            VALORACRESCIMO = convertMoedaToFloat($('#valor_acrescimo').text())
            validateButtonSave()
        }, 300)
    }

    $('#inp-tipo_pagamento_row').val('').change()
    $('#inp-valor_row').val('')
    $('#inp-valor_recebido').val('')
    $('#inp-troco').val('')
    $('#inp-valor_credito').val('')

    // consultaStatusTef(2075408)

    // Impedir saída do PDV com itens no carrinho
    $(document).on('click', '#btn-sair-pdv', function(e) {
        console.log('Interceptando clique no Sair');
        if ($('.table-itens tbody tr').length > 0) {
            e.preventDefault();
            swal({
                title: 'Carrinho não vazio',
                text: 'Esvazie o carrinho antes de sair do PDV!',
                icon: 'warning',
                button: 'OK'
            });
            return false;
        }
    });
})

$('.btn-gerar-fatura').click(() => {
    $('#pagamento_multiplo').modal('hide')
    $('#modal_fatura_venda').modal('show')
    $('.lbl-total_fatura').text("R$ " + convertFloatToMoeda(total_venda))
    
})

$('.btn-store-fatura').click(() => {
    console.clear()

    if(!$('#inp-parcelas_fatura').val()){
        swal("Erro", "Informe a quantidade de parcelas!", "error")
        return;
    }
    if(!$('#inp-intervalo_fatura').val()){
        swal("Erro", "Informe o intervalo!", "error")
        return;
    }
    let data = {
        entrada_fatura: $('#inp-entrada_fatura').val(),
        parcelas_fatura: $('#inp-parcelas_fatura').val(),
        intervalo_fatura: $('#inp-intervalo_fatura').val(),
        primeiro_vencimento_fatura: $('#inp-primeiro_vencimento_fatura').val(),
        tipo_pagamento_fatura: $('#inp-tipo_pagamento_fatura').val(),
        total: total_venda
    }
    console.log(data)
    $.get(path_url + "api/frenteCaixa/gerar-fatura-pdv", data)
    .done((success) => {
        // console.log(success)
        $('#pagamento_multiplo').modal('show')
        setTimeout(() => {
            $(".table-payment tbody").html(success)
            $('#modal_fatura_venda').modal('hide')
            calcTotalPayment()
            validateButtonSave()

        }, 100)
        

    })
    .fail((err) => {
        console.log(err);
    });
})

$('.btn-vendas-suspensas').click(() => {
    $.get(path_url + "api/frenteCaixa/venda-suspensas",
    {
        empresa_id: $('#empresa_id').val(),
    })
    .done((data) => {
        // console.log(data)
        $('.table-vendas-suspensas tbody').html(data)
    })
    .fail((e) => {
        console.log(e);
    });
})

$("#inp-produto_id").select2({
    minimumInputLength: 2,
    language: "pt-BR",
    placeholder: "Digite para buscar o produto",
    width: "100%",
    theme: "bootstrap4",
    ajax: {
        cache: true,
        url: path_url + "frontbox/produtos/buscar",
        dataType: "json",
        data: function (params) {
            let empresa_id = $('#empresa_id').val()
            console.clear();
            
            // Debug: verificar elementos de local
            console.log('Elemento #local_estoque_select existe:', $('#local_estoque_select').length > 0);
            console.log('Valor de #local_estoque_select:', $('#local_estoque_select').val());
            console.log('Valor de #local_estoque:', $('#local_estoque').val());
            
            var local_id_value = $('#local_estoque_select').length > 0 ? $('#local_estoque_select').val() : $('#local_estoque').val();
            console.log('Local ID final usado:', local_id_value);
            
            var query = {
                pesquisa: params.term,
                lista_id: $('#lista_id').val(),
                usuario_id: $('#usuario_id').val(),
                empresa_id: empresa_id,
                local_id: local_id_value
            };
            
            console.log('Query completa enviada:', query);
            return query;
        },
        processResults: function (response) {
            var results = [];
            let compra = 0
            if($('#is_compra') && $('#is_compra').val() == 1){
                compra = 1
            }

            $.each(response, function (i, v) {
                var o = {};
                o.id = v.id;
                if(v.codigo_variacao){
                    o.codigo_variacao = v.codigo_variacao
                }

                o.text = v.nome

                if(parseFloat(v.valor_unitario) > 0){
                    o.text += ' R$ ' + convertFloatToMoeda(v.valor_unitario);
                }

                if(v.estoque_atual > 0 && $('#estoque_view').val() == 1){
                    o.text += ' | Estoque: ' + v.estoque_atual;
                }

                if(v.codigo_barras){
                    o.text += ' [' + v.codigo_barras  + ']';
                }
                o.value = v;
                results.push(o);
            });
            return {
                results: results,
            };
        },
    },
});

// Detecta teclas numéricas e outros atalhos úteis globalmente
$(document).on('keydown', function(e) {
    // Se um modal estiver aberto, não processa os atalhos globais
    if ($('.modal.show').length > 0 || $('input:focus, select:focus, textarea:focus').length > 0) {
        return;
    }
    
    // Teclas numéricas (0-9) no teclado principal ou numérico
    if ((e.keyCode >= 48 && e.keyCode <= 57) || (e.keyCode >= 96 && e.keyCode <= 105)) {
        $('#codBarras').focus();
        return;
    }
    
    // Tecla * (asterisco) - para quantidade
    if (e.keyCode === 56 && e.shiftKey) { // * no teclado principal (shift+8)
        $('#codBarras').focus();
        return;
    }
    
    if (e.keyCode === 106) { // * no teclado numérico
        $('#codBarras').focus();
        return;
    }
    
    // Implementa atalhos de teclado úteis
    switch (e.keyCode) {
        case 112: // F1 - Ajuda
            e.preventDefault();
            mostrarDicaQuantidade();
            break;
            
        case 113: // F2 - Foca no campo de código de barras
            e.preventDefault();
            $('#codBarras').focus();
            break;
            
        case 115: // F4 - Finalizar venda (se habilitado)
            e.preventDefault();
            if (!$('#salvar_venda').prop('disabled')) {
                $('#salvar_venda').trigger('click');
            } else if (!$('#editar_venda').prop('disabled')) {
                $('#editar_venda').trigger('click');
            }
            break;
            
        case 118: // F7 - Limpar quantidade
            e.preventDefault();
            if (QUANTIDADE_DIGITADA) {
                QUANTIDADE_DIGITADA = null;
                $('#quantidade_multipla').fadeOut(300);
                toastr.info('Quantidade limpa', 'Informação', {
                    timeOut: 2000,
                    positionClass: "toast-top-right"
                });
            }
            break;
    }
});

// Função para atualizar o campo de quantidade na tela
function atualizarCampoQuantidade(quantidade) {
    // Converte para o formato de exibição (vírgula)
    const quantidadeFormatada = quantidade.toString().replace('.', ',');
    
    // Verifica se há um número após a vírgula
    const temDecimal = quantidadeFormatada.indexOf(',') !== -1;
    
    // Se não há decimal, adiciona ,000 (3 casas decimais)
    const valorExibicao = temDecimal ? quantidadeFormatada : quantidadeFormatada + ',000';
    
    // Atualiza o campo de quantidade
    $('#inp-quantidade').val(valorExibicao);
    
    // Destaca o campo com efeito visual
    $('#inp-quantidade').css('background-color', '#d4edda');
    setTimeout(() => {
        $('#inp-quantidade').css('transition', 'background-color 1.5s ease');
        $('#inp-quantidade').css('background-color', '');
    }, 200);
}

// Função para processar o código de barras quando o Enter é pressionado
$(document).on('keyup', '#codBarras', function(e) {
    if (e.keyCode === 13) { // Enter
        const inputValue = $(this).val().trim();
        
        if (!inputValue) return; // Ignore entrada vazia
        
        if (inputValue.includes('*')) {
            // Processamento de quantidade
            const parts = inputValue.split('*');
            const quantidadeTexto = parts[0].replace(',', '.').trim();
            const quantidade = parseFloat(quantidadeTexto);
            
            if (!isNaN(quantidade) && quantidade > 0) {
                QUANTIDADE_DIGITADA = quantidade;
                
                // Limpa o campo e mantém o foco
                $(this).val('');
                $(this).focus();
                
                // Exibe o indicador de quantidade com formato melhorado
                $('#quantidade_multipla').html('<strong>' + quantidade + '</strong>').fadeIn(200);
                
                // Atualiza o campo de quantidade no formulário
                atualizarCampoQuantidade(quantidade);
                
                // Adiciona feedback visual com toastr - mensagem simplificada e duração de 3 segundos
                toastr.success('Quantidade: ' + quantidade, '', {
                    timeOut: 3000,
                    positionClass: "toast-top-right",
                    closeButton: false,
                    progressBar: true
                });
                
                // Se houver uma segunda parte após o * (código do produto)
                if (parts.length > 1 && parts[1].trim() !== '') {
                    setTimeout(() => {
                        processarCodigoBarras(parts[1].trim());
                    }, 100);
                }
            } else {
                toastr.error('Quantidade inválida!', 'Erro', {
                    timeOut: 3000
                });
            }
        } else if (inputValue) {
            // Processa o código de barras
            processarCodigoBarras(inputValue);
        }
    }
});

// Função que processa o código de barras
function processarCodigoBarras(barcode) {
    // Se o código começar com 2, pode ser um código interno (para pesar)
    if (barcode.length > 8 && barcode.substring(0, 1) == '2') {
        processarCodigoInterno(barcode);
    } else {
        // Buscar produto pelo código de barras
        buscarPorCodigoBarras(barcode);
    }
}

// Função para processar código interno de pesagem
function processarCodigoInterno(barcode) {
    // Códigos de pesagem geralmente começam com 2 e têm um formato específico
    // Exemplo: 2PPPPPXXXXXQ onde:
    // 2 = prefixo para identificar pesagem
    // PPPPP = código do produto (5 dígitos)
    // XXXXX = valor/peso (5 dígitos, com 3 casas decimais)
    // Q = dígito verificador
    
    if (barcode.length >= 13) {
        try {
            // Extrai o código do produto (posições 1-5)
            const codigoProduto = barcode.substring(1, 6);
            
            // Extrai o peso/valor (posições 7-11) e converte para decimal
            const valor = barcode.substring(7, 12);
            const valorDecimal = parseFloat(valor) / 1000; // Converte para kg considerando 3 casas decimais
            
            // Busca o produto pelo código
            $.get(path_url + "api/produtos/findByCodigo", {
                codigo: codigoProduto,
                empresa_id: $('#empresa_id').val(),
                lista_id: $('#lista_id').val(),
                usuario_id: $('#usuario_id').val(),
                local_id: $('#local_estoque_select').length > 0 ? $('#local_estoque_select').val() : $('#local_estoque').val()
            })
            .done((data) => {
                if (data.id) {
                    // Atualiza o campo de quantidade com o peso automaticamente
                    atualizarCampoQuantidade(valorDecimal);
                    
                    // Adiciona o produto com o peso/valor extraído do código
                    adicionarProdutoDiretamente(data, valorDecimal);
                    
                    // Limpa a quantidade e o indicador visual
                    QUANTIDADE_DIGITADA = null;
                    $('#quantidade_multipla').fadeOut(300);
                    
                    // Notifica o usuário com mensagem simplificada e duração de 3 segundos
                    toastr.success(
                        data.nome, 
                        '', 
                        {
                            timeOut: 3000,
                            positionClass: "toast-top-right",
                            progressBar: true,
                            closeButton: false
                        }
                    );
                } else {
                    beepErro();
                    toastr.error('Produto não encontrado', '', {
                        timeOut: 3000,
                        positionClass: "toast-top-right"
                    });
                }
            })
            .fail((error) => {
                console.error(error);
                buscarPorCodigoBarras(barcode); // Tenta buscar pelo código completo
            });
        } catch (e) {
            console.error("Erro ao processar código interno:", e);
            buscarPorCodigoBarras(barcode); // Tenta buscar pelo código completo
        }
    } else {
        // Se não tiver o formato esperado, tenta como código de barras normal
        buscarPorCodigoBarras(barcode);
    }
}

// Função para buscar produto por código de barras
function buscarPorCodigoBarras(barcode) {
    // Limpa o campo e mantém o foco
    $('#codBarras').val('');
    $('#codBarras').focus();
    
    // Mostra um indicador visual de processamento
    let loadingToast = toastr.info(
        '<i class="ri-loader-4-line fa-spin"></i> Buscando produto...', 
        '', 
        {
            timeOut: 0,
            extendedTimeOut: 0,
            closeButton: false,
            progressBar: true,
            positionClass: "toast-top-right"
        }
    );
    
    $.get(path_url + "api/produtos/findByBarcode", {
        barcode: barcode,
        empresa_id: $('#empresa_id').val(),
        lista_id: $('#lista_id').val(),
        usuario_id: $('#usuario_id').val(),
        local_id: $('#local_estoque_select').length > 0 ? $('#local_estoque_select').val() : $('#local_estoque').val()
    })
    .done((data) => {
        toastr.clear(loadingToast);
        
        if (data.id) {
            let qtd = QUANTIDADE_DIGITADA ? QUANTIDADE_DIGITADA : 1;
            
            // Adiciona o produto
            adicionarProdutoDiretamente(data, qtd);
            
            // Limpa a quantidade e o indicador visual
            QUANTIDADE_DIGITADA = null;
            $('#quantidade_multipla').fadeOut(300);
            
            // Limpa o campo de quantidade para o próximo produto
            setTimeout(() => {
                atualizarCampoQuantidade(1);
            }, 300);
            
            // Notifica o usuário com mensagem simplificada e duração de 3 segundos
            toastr.success(
                data.nome, 
                '', 
                {
                    timeOut: 3000,
                    positionClass: "toast-top-right",
                    progressBar: true,
                    closeButton: false
                }
            );
        } else {
            beepErro();
            toastr.error('Produto não encontrado', '', {
                timeOut: 3000,
                positionClass: "toast-top-right"
            });
        }
    })
    .fail((error) => {
        toastr.clear(loadingToast);
        console.error(error);
        beepErro();
        toastr.error('Erro ao buscar produto AQUI 1', '', {
            timeOut: 3000,
            positionClass: "toast-top-right"
        });
        
        // Tenta buscar por referência
        buscarPorReferencia(barcode);
    });
}

function adicionarProdutoDiretamente(produto, qtd) {
    if (produto && produto.valor_unitario) {
        // Verifica se o produto já existe na tabela
        let produtoExistente = null;
        let variacaoId = produto.codigo_variacao || null;
        
        $(".table-itens tbody tr").each(function() {
            let linhaProdutoId = $(this).find('input[name="produto_id[]"]').val();
            let linhaVariacaoId = $(this).find('input[name="variacao_id[]"]').val() || null;
            
            if (linhaProdutoId == produto.id && linhaVariacaoId == variacaoId) {
                produtoExistente = $(this);
                return false; // break do loop
            }
        });
        
        if (produtoExistente) {
            // Produto já existe, atualizar quantidade
            let quantidadeAtual = parseFloat(produtoExistente.find('input[name="quantidade[]"]').val()) || 0;
            let novaQuantidade = quantidadeAtual + parseFloat(qtd);
            
            // Usar o valor do formulário se disponível, senão usar o valor do produto
            let valorFormulario = $("#inp-valor_unitario").val();
            let valorUnitario;
            
            if (valorFormulario && valorFormulario !== '' && valorFormulario !== '0,00') {
                // Converter valor do formulário para float
                valorUnitario = parseFloat(valorFormulario.replace(',', '.'));
            } else {
                valorUnitario = parseFloat(produto.valor_unitario);
            }
            
            let novoSubtotal = parseFloat((novaQuantidade * valorUnitario).toFixed(2));
            
            // Atualizar os campos
            produtoExistente.find('input[name="quantidade[]"]').val(novaQuantidade.toFixed(3));
            produtoExistente.find('.quantidade-display').text(novaQuantidade.toFixed(3));
            produtoExistente.find('input[name="subtotal[]"]').val(novoSubtotal.toFixed(2));
            produtoExistente.find('.subtotal-display').text('R$ ' + novoSubtotal.toFixed(2).replace('.', ','));
            
            // Efeito visual para destacar a atualização
            produtoExistente.css('background-color', '#fff3cd');
            setTimeout(() => {
                produtoExistente.css('transition', 'background-color 1s ease');
                produtoExistente.css('background-color', '');
            }, 100);
            
            // Som de sucesso
            beepSucesso();
            
            // Recalcula o total
            calcTotal();
            
            // Verifica se já existem produtos para habilitar o botão de finalizar
            validateButtonSave();
            
            return;
        }
        
        // Produto não existe, adicionar novo
        // Usar o valor do formulário se disponível, senão usar o valor do produto
        let valorFormulario = $("#inp-valor_unitario").val();
        let valorUnitario;
        
        if (valorFormulario && valorFormulario !== '' && valorFormulario !== '0,00') {
            // Converter valor do formulário para float
            valorUnitario = parseFloat(valorFormulario.replace(',', '.'));
        } else {
            valorUnitario = parseFloat(produto.valor_unitario);
        }
        
        let quantidade = parseFloat(qtd);
        // Garante que o cálculo seja feito com precisão de 2 casas decimais
        let subTotal = parseFloat((quantidade * valorUnitario).toFixed(2));
        
        let dataRequest = {
            qtd: qtd,
            value_unit: valorUnitario,
            sub_total: subTotal,
            product_id: produto.id,
            variacao_id: produto.codigo_variacao || null,
            local_id: $('#local_id').val(),
        };
        
        // Adiciona o produto diretamente à venda
        $.get(path_url + "api/frenteCaixa/linhaProdutoVenda", dataRequest)
        .done((e) => {
            if (e === false) {
                beepErro();
                swal("Atenção", "Produto com estoque insuficiente!", "warning");
            } else {
                // Adiciona o produto à tabela
                let novaLinha = $(e);
                $(".table-itens tbody").append(novaLinha);
                
                // Efeito visual para destacar o produto adicionado
                novaLinha.css('background-color', '#d4edda');
                setTimeout(() => {
                    novaLinha.css('transition', 'background-color 1s ease');
                    novaLinha.css('background-color', '');
                }, 100);
                
                // Som de sucesso
                beepSucesso();
                
                // Recalcula o total
                calcTotal();
                
                // Verifica se já existem produtos para habilitar o botão de finalizar
                validateButtonSave();
            }
            
            // Focar novamente no campo de código de barras após adicionar o produto
            setTimeout(() => {
                $('#codBarras').focus();
            }, 100);
        })
        .fail((e) => {
            console.log(e);
            beepErro();
            swal("Atenção", e.responseJSON || "Erro ao adicionar produto", "warning");
        });
    } else {
        beepErro();
        swal("Erro", "Produto não encontrado ou sem preço definido", "error");
    }
}

$('.cliente-venda').on('click', function() {
    // Capturar o texto completo do cliente selecionado
    let cliente_text = $('#inp-cliente_id option:selected').text();
    console.log("Cliente selecionado:", cliente_text);
    
    // Atualizar a exibição do cliente no PDV se houver texto selecionado
    if (cliente_text) {
        $('.cliente_selecionado').html(cliente_text);
    }
    
    let vl_cashback = convertMoedaToFloat($('#inp-valor_cashback').val())
    if(vl_cashback > 0){
        DESCONTO = vl_cashback
        $("#valor_desconto").html(convertFloatToMoeda(DESCONTO));
        calcTotal();
    }
})

$('.btn-selecionar_cliente').click(() => {
    $('#inp-valor_cashback').val('')
    $('#inp-permitir_credito').val('1').change()
})

function buscarPorReferencia(referencia) {
    $.get(path_url + "api/produtos/findByBarcodeReference",
    {
        referencia: referencia,
        empresa_id: $('#empresa_id').val(),
        lista_id: $('#lista_id').val(),
        usuario_id: $('#usuario_id').val(),
        local_id: $('#local_estoque_select').length > 0 ? $('#local_estoque_select').val() : $('#local_estoque').val()
    })
    .done((data) => {
        if (data.id) {
            let qtd = QUANTIDADE_DIGITADA ? QUANTIDADE_DIGITADA : 1;
            
            // Adiciona o produto
            adicionarProdutoDiretamente(data, qtd);
            
            // Limpa a quantidade e o indicador visual
            QUANTIDADE_DIGITADA = null;
            $('#quantidade_multipla').fadeOut(300);
            
            // Notifica o usuário com mensagem simplificada e duração de 3 segundos
            toastr.success(data.nome, '', {
                timeOut: 3000,
                positionClass: "toast-top-right",
                progressBar: true,
                closeButton: false
            });
        } else {
            toastr.error('Produto não encontrado', '', {
                timeOut: 3000,
                positionClass: "toast-top-right"
            });
        }
    })
    .fail((error) => {
        console.error(error);
        toastr.error('Erro ao buscar produto  AQUI 2', '', {
            timeOut: 3000,
            positionClass: "toast-top-right"
        });
    });
}

var CashBackConfig = null
var valorCashBack = 0

$(document).on("change", "#inp-cliente_id", function () {
    $('.cashback-div').addClass('d-none')
    $('#inp-valor_cashback').val('')
    $('#inp-permitir_credito').val('1').change()
    
    // Resetar estado do crédito do cliente
    resetarCreditoCliente();
    
    let cliente_id = $(this).val()
    $.get(path_url + "api/clientes/cashback/" + cliente_id)
    .done((e) => {
        if(e){
            CashBackConfig = e
            valorCashBack = e.valor_cashback

            $('.cashback-div').removeClass('d-none')
            $('.info_cash_back').text('*percentual de cashback para uso ' + e.percentual_maximo_venda + '%')

        }
        $('.valor-cashback-disponivel').text('R$ ' + convertFloatToMoeda(e.valor_cashback))
    })
    .fail((e) => {
        $('.cashback-div').addClass('d-none')
        // console.log(e);
    });

    console.clear()
    $.get(path_url + "api/clientes/find/" + cliente_id)
    .done((cliente) => {
        console.log(cliente)
        if(cliente.lista_preco){

            $('#lista_id').val(cliente.lista_preco.id)
            setTimeout(() => {
                todos()
            }, 10)
            setTimeout(() => {
                $("#codBarras").focus();
            }, 500)

        }

        if(cliente.valor_credito > 0){
            console.log("[SELEÇÃO CLIENTE] Crédito detectado:", cliente.valor_credito);
            // REMOVIDO: Aplicação automática do crédito na tela principal
            // DESCONTO = cliente.valor_credito;
            // $("#valor_desconto").text("R$ " + convertFloatToMoeda(DESCONTO));
            // $('#pedido_desconto').val(''); // Limpa desconto manual
            // console.log("[SELEÇÃO CLIENTE] DESCONTO aplicado automaticamente:", DESCONTO);
            // calcTotal();
            
            // NOVO: Apenas alerta informativo na tela principal
            swal({
                title: 'Cliente com Crédito Disponível',
                text: "O cliente possui um crédito de R$ " + convertFloatToMoeda(cliente.valor_credito) + ". Você pode aplicá-lo na tela de pagamentos.",
                icon: "info",
                button: "Entendi",
                closeOnClickOutside: false,
                closeOnEsc: true
            });
            
            // Armazenar o valor do crédito para uso posterior na tela de pagamentos
            VALORCREDITO = cliente.valor_credito;
            console.log("[SELEÇÃO CLIENTE] Crédito armazenado para uso posterior:", VALORCREDITO);
            
            // Mostrar badge informativo na tela principal
            $('#valor-credito-disponivel').text('R$ ' + convertFloatToMoeda(cliente.valor_credito));
            $('#badge-credito-cliente').removeClass('d-none').fadeIn(300);
            
            // Atualizar seção de crédito na tela de pagamentos
            atualizarSecaoCreditoPagamento();
        } else {
            // Ocultar badge se cliente não tem crédito
            $('#badge-credito-cliente').addClass('d-none');
            VALORCREDITO = 0;
            
            // Ocultar seção de crédito na tela de pagamentos
            $('#secao-credito-cliente').hide();
        }
    })
    .fail((err) => {
        console.log(err);
    });

})

// Função para atualizar a seção de crédito do cliente na tela de pagamentos
function atualizarSecaoCreditoPagamento() {
    if (VALORCREDITO > 0) {
        $('#valor-credito-cliente-pagamento').text('R$ ' + convertFloatToMoeda(VALORCREDITO));
        $('#secao-credito-cliente').show();
    } else {
        $('#secao-credito-cliente').hide();
    }
}

// Função para resetar o estado do crédito do cliente
function resetarCreditoCliente() {
    VALORCREDITO = 0;
    $('#badge-credito-cliente').addClass('d-none');
    $('#secao-credito-cliente').hide();
    $('#btn-aplicar-credito').prop('disabled', false).html('<i class="ri-check-line"></i> Aplicar Crédito');
    console.log("[RESET] Estado do crédito do cliente resetado");
}

// Evento para aplicar crédito do cliente na tela de pagamentos
$(document).on('click', '#btn-aplicar-credito', function() {
    if (VALORCREDITO <= 0) {
        swal("Erro", "Nenhum crédito disponível para aplicar", "error");
        return;
    }
    
    let descontoManual = convertMoedaToFloat($('#pedido_desconto').val());
    
    if (descontoManual > 0) {
        swal({
            title: "Desconto já existente",
            text: "Já existe um desconto manual de R$ " + convertFloatToMoeda(descontoManual) + ". Deseja aplicar o crédito do cliente junto com o desconto?",
            icon: "warning",
            buttons: ["Não, usar só o crédito", "Sim, somar os dois"]
        }).then((willSum) => {
            if (willSum) {
                DESCONTO = VALORCREDITO + descontoManual;
                console.log("[APLICAR CRÉDITO] DESCONTO somado:", DESCONTO, "VALORCREDITO:", VALORCREDITO, "descontoManual:", descontoManual);
            } else {
                $('#pedido_desconto').val('');
                DESCONTO = VALORCREDITO;
                console.log("[APLICAR CRÉDITO] DESCONTO só crédito:", DESCONTO, "VALORCREDITO:", VALORCREDITO);
            }
            $("#valor_desconto").text("R$ " + convertFloatToMoeda(DESCONTO));
            $("#valor_desconto_pdv1").text("R$ " + convertFloatToMoeda(DESCONTO));
            atualizarValorTotal(); // Trocar calcTotal() por atualizarValorTotal()
            $('#btn-aplicar-credito').prop('disabled', true).text('Crédito Aplicado');
            swal("Sucesso", "Crédito do cliente aplicado com sucesso!", "success");
        });
    } else {
        DESCONTO = VALORCREDITO;
        console.log("[APLICAR CRÉDITO] DESCONTO só crédito:", DESCONTO, "VALORCREDITO:", VALORCREDITO);
        $("#valor_desconto").text("R$ " + convertFloatToMoeda(DESCONTO));
        $("#valor_desconto_pdv1").text("R$ " + convertFloatToMoeda(DESCONTO));
        atualizarValorTotal(); // Trocar calcTotal() por atualizarValorTotal()
        $('#btn-aplicar-credito').prop('disabled', true).text('Crédito Aplicado');
        swal("Sucesso", "Crédito do cliente aplicado com sucesso!", "success");
    }
    // Ao aplicar o crédito do cliente (dentro do evento do botão aplicar crédito):
    CREDITO_UTILIZADO = VALORCREDITO;
});

$('#inp-valor_cashback').blur(() => {
    validaCashBack()
})

function validaCashBack(){

    let valor_setado = $('#inp-valor_cashback').val()
    valor_setado = valor_setado.replace(",", ".")
    valor_setado = parseFloat(valor_setado)
    let total = convertMoedaToFloat($(".total-venda").text())
    if(total == 0){
        swal("Alerta", "Informe ao menos um produto para continuar", "warning")
        return;
    }
    if(CashBackConfig){
        let percentual_maximo_venda = CashBackConfig.percentual_maximo_venda
        let valor_maximo = total * (percentual_maximo_venda/100)

        if(valor_setado > valor_maximo){
            swal("Erro", "Valor máximo permitido R$ " + convertFloatToMoeda(valor_maximo), "warning")
            $('#inp-valor_cashback').val('')
        }else if(valor_setado > valorCashBack){
            swal("Erro", "Valor ultrapassou R$ " + convertFloatToMoeda(valorCashBack), "warning")
            $('#inp-valor_cashback').val('')
        }else{

        }
    }
}

$(function () {
    setTimeout(() => {
        $('#cat_todos').first().trigger('click')

        $("#inp-conta_empresa_sangria_id").select2({
            minimumInputLength: 2,
            language: "pt-BR",
            placeholder: "Digite para buscar a conta",
            width: "100%",
            theme: "bootstrap4",
            dropdownParent: '#sangria_caixa',
            ajax: {
                cache: true,
                url: path_url + "api/contas-empresa",
                dataType: "json",
                data: function (params) {
                    console.clear();
                    let empresa_id = $('#empresa_id').val()
                    var query = {
                        pesquisa: params.term,
                        empresa_id: empresa_id
                    };
                    return query;
                },
                processResults: function (response) {
                    var results = [];

                    $.each(response, function (i, v) {
                        var o = {};
                        o.id = v.id;

                        o.text = v.nome;
                        o.value = v.id;
                        results.push(o);
                    });
                    return {
                        results: results,
                    };
                },
            },
        });

        $("#inp-conta_empresa_suprimento_id").select2({
            minimumInputLength: 2,
            language: "pt-BR",
            placeholder: "Digite para buscar a conta",
            width: "100%",
            theme: "bootstrap4",
            dropdownParent: '#suprimento_caixa',
            ajax: {
                cache: true,
                url: path_url + "api/contas-empresa",
                dataType: "json",
                data: function (params) {
                    console.clear();
                    let empresa_id = $('#empresa_id').val()
                    var query = {
                        pesquisa: params.term,
                        empresa_id: empresa_id
                    };
                    return query;
                },
                processResults: function (response) {
                    var results = [];

                    $.each(response, function (i, v) {
                        var o = {};
                        o.id = v.id;

                        o.text = v.nome;
                        o.value = v.id;
                        results.push(o);
                    });
                    return {
                        results: results,
                    };
                },
            },
        });
    }, 100)
})

function selectCat(id) {
    $('#cat_todos').removeClass('active')
    $('.btn-cat').removeClass('active')
    $('.btn_cat_' + id).addClass('active')
    $.get(path_url + "api/produtos/findByCategory",
    {
        lista_id: $('#lista_id').val(),
        usuario_id: $('#usuario_id').val(),
        empresa_id: $('#empresa_id').val(),
        id: id,
        local_id: $('#local_estoque_select').length > 0 ? $('#local_estoque_select').val() : $('#local_estoque').val()
    })
    .done((e) => {
        $('.cards-categorias').html(e)
    })
    .fail((e) => {
        console.log(e);
    });
}

function todos() {
    $('.btn_cat').removeClass('active')
    $('#cat_todos').addClass('active')

    $.get(path_url + "api/produtos/all", { 
        empresa_id: $('#empresa_id').val(),
        lista_id: $('#lista_id').val(),
        usuario_id: $('#usuario_id').val(),
        local_id: $('#local_estoque_select').length > 0 ? $('#local_estoque_select').val() : $('#local_estoque').val()
    })
    .done((e) => {

        $('.cards-categorias').html(e)
    })
    .fail((e) => {
        console.log(e);
    });
}

$(function () {
    setTimeout(() => {
        $("#inp-produto_id").change(() => {
            let product_id = $("#inp-produto_id").val();

            if (product_id) {
                let codigo_variacao = $("#inp-produto_id").select2('data')[0].codigo_variacao
                $.get(path_url + "api/produtos/findWithLista",
                { 
                    produto_id: product_id,
                    lista_id: $('#lista_id').val(),
                    local_id: $('#local_id').val(),
                })
                .done((e) => {
                    if(e.variacao_modelo_id){
                        if(!codigo_variacao){
                            buscarVariacoes(product_id)
                        }else{

                            $.get(path_url + "api/variacoes/findById", {codigo_variacao: codigo_variacao})
                            .done((e) => {
                                $("#inp-variacao_id").val(codigo_variacao);
                                $("#inp-quantidade").val("1,000");
                                $("#inp-valor_unitario").val(convertFloatToMoeda(e.valor));
                                $("#inp-subtotal").val(convertFloatToMoeda(e.valor));
                            })
                            .fail((e) => {
                                console.log(e);
                            });
                        }
                    }else{
                        const produto = $("#inp-produto_id").select2('data')[0].value;

                        $("#inp-quantidade").val("1,000");
                        $("#inp-valor_unitario").val(convertFloatToMoeda(produto.valor_unitario));
                        $("#inp-subtotal").val(convertFloatToMoeda(produto.valor_unitario));
                    }

                    setTimeout(() => {
                        // $("#inp-quantidade").focus()
                    }, 200)
                })
                .fail((e) => {
                    console.log(e);
                });
            }
        })
    }, 100)

    $("body").on("blur", ".value_unit", function () {
        let qtd = $("#inp-quantidade").val();
        let value_unit = $(this).val();
        
        // Converte os valores para formato numérico
        value_unit = convertMoedaToFloat(value_unit);
        qtd = convertMoedaToFloat(qtd);
        
        // Garante que o subtotal seja calculado com precisão de 2 casas decimais
        let subtotal = parseFloat((qtd * value_unit).toFixed(2));
        $("#inp-subtotal").val(convertFloatToMoeda(subtotal));
    })
})

function buscarVariacoes(produto_id){
    $.get(path_url + "api/variacoes/find", { produto_id: produto_id })
    .done((res) => {
        $('#modal_variacao .modal-body').html(res)
        $('#modal_variacao').modal('show')
    })
    .fail((err) => {
        console.log(err)
        swal("Algo deu errado", "Erro ao buscar variações", "error")
    })
}

function selecionarVariacao(id, descricao, valor){
    // Define a quantidade (da digitação anterior ou padrão 1)
    let qtd = QUANTIDADE_DIGITADA ? QUANTIDADE_DIGITADA : "1,000";
    $("#inp-quantidade").val(qtd.toString().replace('.', ','));
    
    $("#inp-valor_unitario").val(convertFloatToMoeda(valor));
    
    // Calcula o subtotal com precisão de 2 casas decimais
    let subtotal = parseFloat((convertMoedaToFloat(qtd) * valor).toFixed(2));
    $("#inp-subtotal").val(convertFloatToMoeda(subtotal));
    
    $("#inp-variacao_id").val(id);

    $('#modal_variacao').modal('hide')

    if(PRODUTOID != null){
        addItem()
        // Limpa o indicador de quantidade
        $('#quantidade_multipla').fadeOut(300);
        // Reseta a quantidade após usar
        QUANTIDADE_DIGITADA = null;
    }
}

function addItem(){

    $.get(path_url + "api/produtos/findId/" + PRODUTOID)
    .done((res) => {
        console.log(res)
        var newOption = new Option(res.nome, res.id, false, false);
        $('#inp-produto_id').html('')
        $('#inp-produto_id').append(newOption);
        setTimeout(() => {
            $('.btn-add-item').trigger('click')
        }, 10)
    })
    .fail((err) => {
        console.log(err)
    })
    PRODUTOID = null
}

var PRODUTOID = null
function addProdutos(id) {
    let qtd = 1; // padrão é 1
    let agrupar_itens = $('#agrupar_itens').val();

    if (QUANTIDADE_DIGITADA) {
        qtd = QUANTIDADE_DIGITADA;
        QUANTIDADE_DIGITADA = null; // Reseta após usar
        // Limpa o indicador de quantidade
        $('#quantidade_multipla').fadeOut(300);
    } else if(agrupar_itens == 1){
        $('.produto_row').each(function () {
            if(id == $(this).val()){
                qtd = $(this).next().next().next().find('input').val()
            }
        })
    }

    // LOG: Veja os parâmetros antes de enviar
    console.log('[addProdutos] Parâmetros enviados:', {
        id: id,
        qtd: qtd,
        value_unit: $("#inp-valor_unitario").val(),
        value_unit_raw: $("#inp-valor_unitario").val(),
        value_unit_convertido: convertMoedaToFloat($("#inp-valor_unitario").val()),
        lista_id: $('#lista_id').val(),
        local_id: $('#local_id').val(),
        local_estoque: $('#local_estoque_select').length > 0 ? $('#local_estoque_select').val() : $('#local_estoque').val(),
        local_id_venda: $('#local_id_venda').val()
    });

    setTimeout(() => {
        $.get(path_url + "api/frenteCaixa/linhaProdutoVendaAdd", {
            id: id,
            qtd: qtd,
            value_unit: $("#inp-valor_unitario").val(),
            lista_id: $('#lista_id').val(),
            local_id: $('#local_id_venda').val(),
        })
        .done((e) => {
            // LOG: Veja o retorno do backend
            console.log('[addProdutos] Sucesso na requisição:', e);
            if (e == false) {
                swal("Atenção", "Produto com estoque insuficiente!", "warning");
            } else {
                let idDup = 0
                if(agrupar_itens == 1){
                    $(".produto_row").each(function () {
                        if($(this).val() == id){
                            idDup = $(this).val()
                        }
                    })
                }

                setTimeout(() => {
                    if(idDup == 0){
                        $(".table-itens tbody").append(e);
                    }else{
                        $(".table-itens tbody tr").each(function(){
                            if($(this).find('.produto_row').val() == id){
                                let qtdAnt = convertMoedaToFloat($(this).find('.qtd_row').val())
                                let novaQtd = qtd > 0 ? qtd : qtdAnt + 1;
                                $(this).find('.qtd_row').val(convertFloatToMoeda(novaQtd))
                            }
                        })
                    }
                    setTimeout(() => {
                        beepSucesso()
                        calcSubTotal()
                        setTimeout(() => {
                            $('#codBarras').focus();
                        }, 10);
                    }, 20)
                }, 10)
            }
        })
        .fail((e) => {
            // LOG: Veja o erro retornado
            console.log('[addProdutos] Erro na requisição:', e);
            beepErro()
            PRODUTOID = id
            if(e.status == 401){
                swal("Atenção", "Sessão expirada ou não autenticada! Faça login novamente.", "warning");
            } else if(e.status == 402){
                buscarVariacoes(id)
            } else {
                swal("Atenção", e.responseJSON || "Erro ao adicionar produto", "warning");
            }
        });
    }, 10);
}


$(".btn-add-item").click(() => {
    console.clear()
    let qtd = $("#inp-quantidade").val();
    let value_unit = $("#inp-valor_unitario").val();
    value_unit = convertMoedaToFloat(value_unit);
    qtd = convertMoedaToFloat(qtd);
    // Garante que o subtotal seja calculado com precisão de 2 casas decimais
    let subtotal = parseFloat((qtd * value_unit).toFixed(2));
    $("#inp-subtotal").val(convertFloatToMoeda(subtotal));

    setTimeout(() => {
        let abertura = $('#abertura').val()

        if (abertura) {
            let qtd = $("#inp-quantidade").val();
            let value_unit = $("#inp-valor_unitario").val();
            let sub_total = $("#inp-subtotal").val();
            let product_id = $("#inp-produto_id").val();
            let variacao_id = $("#inp-variacao_id").val();

            // DEBUG: Logs para verificar os valores
            console.log('[PDV DEBUG] Valores antes de enviar:');
            console.log('qtd:', qtd);
            console.log('value_unit (original):', value_unit);
            console.log('value_unit (convertido):', convertMoedaToFloat(value_unit));
            console.log('sub_total:', sub_total);
            console.log('product_id:', product_id);

            // let key = $("#inp-key").val()
            $("#inp-variacao_id").val('')
            if (qtd && value_unit && product_id && sub_total) {
                // Converte os valores para garantir precisão
                let qtdFloat = convertMoedaToFloat(qtd);
                let valueUnitFloat = convertMoedaToFloat(value_unit);
                let subTotalFloat = parseFloat((qtdFloat * valueUnitFloat).toFixed(2));

                // Usar o local selecionado no combo box de estoque
                var localEstoqueSelecionado = $('#local_estoque_select').length > 0 ? $('#local_estoque_select').val() : $('#local_estoque').val();

                let dataRequest = {
                    qtd: qtd,
                    value_unit: value_unit,
                    sub_total: convertFloatToMoeda(subTotalFloat),
                    product_id: product_id,
                    variacao_id: variacao_id,
                    local_id: localEstoqueSelecionado,
                };

                console.log('[PDV DEBUG] dataRequest:', dataRequest);

                // Validar mínimo somente no momento de adicionar
                console.log('[PDV] Validação mínimo -> produto:', product_id, 'valor_unit(raw):', value_unit, 'valor_unit(float):', convertMoedaToFloat(value_unit));
                $.get(path_url + "api/orcamentos/valida-desconto", {
                    produto_id: product_id,
                    valor: convertMoedaToFloat(value_unit), // garante formato numérico
                    empresa_id: $('#empresa_id').val(),
                    pdv: 1
                })
                .done((res) => {
                    console.log('[PDV] valida-desconto OK ->', res);
                    // Depois, validar o estoque
                    $.get(path_url + "api/produtos/valida-estoque", {
                        product_id: product_id,
                        variacao_id: variacao_id,
                        local_id: localEstoqueSelecionado
                    })
                    .done((response) => {
                        if (response === "Estoque insuficiente!") {
                            swal("Atenção", "Produto com estoque insuficiente!", "warning");
                            return;
                        }
                        if (response && response.estoque && response.estoque.quantidade) {
                            let estoqueDisponivel = parseFloat(response.estoque.quantidade);
                            calcTotal();
                            $('#codBarras').focus();
                            if (qtdFloat > estoqueDisponivel) {
                                swal("Atenção", `Quantidade solicitada (${qtd}) é maior que o estoque disponível (${estoqueDisponivel})!`, "warning");
                                return;
                            }
                        }
                        // Passou nas validações, adicionar o item
                        $("#inp-quantidade").val('1,000');
                        QUANTIDADE_DIGITADA = null;
                        $.get(path_url + "api/frenteCaixa/linhaProdutoVenda", dataRequest)
                        .done((e) => {
                            console.log('[PDV DEBUG] Resposta do linhaProdutoVenda:', e);
                            if (e == false) {
                                swal("Atenção", "Erro ao adicionar produto!", "warning");
                            } else {
                                $.post(path_url + 'api/frenteCaixa/debitar-estoque', {
                                    produto_id: product_id,
                                    quantidade: qtd,
                                    variacao_id: variacao_id,
                                    local_id: localEstoqueSelecionado
                                }).done(function(data) {
                                    console.log('Estoque restaurado com sucesso:', data);
                                    $(".table-itens tbody").append(e);
                                    beepSucesso();
                                    calcTotal();
                                    setTimeout(() => { $('#codBarras').focus(); }, 100);
                                }).fail(function(xhr) {
                                    console.error('Erro ao restaurar estoque:', xhr.responseText);
                                    swal("Erro", "Erro ao restaurar estoque: " + xhr.responseText, "error");
                                });
                            }
                        })
                        .fail((e) => {
                            console.log(e);
                            swal("Atenção", e.responseJSON, "warning");
                        });
                    })
                    .fail((error) => {
                        console.log("Erro na validação de estoque:", error);
                        swal("Atenção", "Erro ao validar estoque do produto!", "warning");
                    });
                })
                .fail((err) => {
                    console.warn('[PDV] valida-desconto FAIL status=', err && err.status, 'response=', err && err.responseJSON);
                    // Tolerância: se o backend retornar 401, mas o valor digitado
                    // for >= mínimo (considerando arredondamento), seguimos normalmente.
                    let minimo = err && err.responseJSON ? err.responseJSON : null;
                    let valueUnitFloatCheck = convertMoedaToFloat(value_unit);
                    let mNorm = minimo ? parseFloat(minimo) : NaN;
                    let vNorm = parseFloat(valueUnitFloatCheck);
                    vNorm = Math.round(vNorm * 100) / 100;
                    mNorm = Math.round(mNorm * 100) / 100;
                    console.log('[PDV][valida-desconto][FAIL] recebido minimo=', minimo, ' valor=', vNorm);

                    if (!isNaN(mNorm) && vNorm + 0.00001 >= mNorm) {
                        console.warn('[PDV] Ignorando 401 de mínimo: valor >= mínimo. Prosseguindo com a adição.');
                        // Continua o fluxo como se tivesse dado .done()
                        $.get(path_url + "api/produtos/valida-estoque", {
                            product_id: product_id,
                            variacao_id: variacao_id,
                            local_id: $('#local_id').val()
                        })
                        .done((response) => {
                            if (response === "Estoque insuficiente!") {
                                swal("Atenção", "Produto com estoque insuficiente!", "warning");
                                return;
                            }
                            if (response && response.estoque && response.estoque.quantidade) {
                                let estoqueDisponivel = parseFloat(response.estoque.quantidade);
                                calcTotal();
                                $('#codBarras').focus();
                                if (qtdFloat > estoqueDisponivel) {
                                    swal("Atenção", `Quantidade solicitada (${qtd}) é maior que o estoque disponível (${estoqueDisponivel})!`, "warning");
                                    return;
                                }
                            }
                            $("#inp-quantidade").val('1,000');
                            QUANTIDADE_DIGITADA = null;
                            $.get(path_url + "api/frenteCaixa/linhaProdutoVenda", dataRequest)
                            .done((e) => {
                                if (e == false) {
                                    swal("Atenção", "Erro ao adicionar produto!", "warning");
                                } else {
                                    $(".table-itens tbody").append(e);
                                    beepSucesso();
                                    calcTotal();
                                    setTimeout(() => { $('#codBarras').focus(); }, 100);
                                }
                            })
                            .fail((e) => {
                                console.log(e);
                                swal("Atenção", e.responseJSON, "warning");
                            });
                        })
                        .fail((error) => {
                            console.log("Erro na validação de estoque:", error);
                            swal("Atenção", "Erro ao validar estoque do produto!", "warning");
                        });
                    } else {
                        swal("Erro", "Valor mínimo para este item é " + convertFloatToMoeda(minimo), "error");
                    }
                });
            } else {
                beepErro()
                swal(
                    "Atenção",
                    "Informe corretamente os campos para continuar!",
                    "warning"
                );
            }
        } else {
            beepErro()
            swal(
                "Atenção",
                "Abra o caixa para continuar!",
                "warning"
            ).then(() => {
                validaCaixa()
            })
        }
    }, 100);
});



function beepSucesso(){
    let alerta = $('#alerta_sonoro').val()
    if(alerta == 1){
        var audio = new Audio('/audio/beep.mp3');
        audio.addEventListener('canplaythrough', function() {
            audio.play();
        });
    }
}
function beepErro(){
    let alerta = $('#alerta_sonoro').val()
    if(alerta == 1){
        var audio = new Audio('/audio/beep_error.mp3');
        audio.addEventListener('canplaythrough', function() {
            audio.play();
        });
    }
}


function validaCaixa() {
    let abertura = $('#abertura').val()
    if (!abertura) {
        $('#modal-abrir_caixa').modal('show')
        return
    }
}

var total_venda = 0;
function calcTotal() {
    console.log("[CALC TOTAL] DESCONTO:", DESCONTO, "VALORCREDITO:", typeof VALORCREDITO !== 'undefined' ? VALORCREDITO : 'N/A', "VALORACRESCIMO:", VALORACRESCIMO);
    var total = 0;
    $(".subtotal-item").each(function () {
        total += convertMoedaToFloat($(this).val());
    });
    setTimeout(() => {
        let valorFinal = total + parseFloat(VALORACRESCIMO) - parseFloat(DESCONTO);
        console.log("[CALC TOTAL] total:", total, "valorFinal:", valorFinal);
        $(".total-venda").html(convertFloatToMoeda(valorFinal));
        $('#inp-valor_total').val(convertFloatToMoeda(valorFinal));
        $(".total-venda-modal").html("R$ " + convertFloatToMoeda(total + VALORACRESCIMO - DESCONTO));
        $('#inp-valor_integral').val(convertFloatToMoeda(total_venda))

        $('#inp-quantidade').val('')
        $('#inp-valor_unitario').val('')
        $('#inp-produto_id').val('').change()
    }, 100);
}

var CLIENTESEMLIMITE = 0
$(".btn-modal-multiplo").on("click", (event) => {
    // consultaDebito()
});

function consultaDebito(){
    CLIENTESEMLIMITE = 0
    let soma = 0
    let tipo_pagamento = $('#inp-tipo_pagamento').val()
    $(".data_multiplo").each(function () {
        let d1 = new Date($(this).val())
        let d2 = new Date();
        if(d1 > d2){
            $valor = $(this).closest('td').next().find('input');
            soma += convertMoedaToFloat($valor.val())
        }
    });

    if(soma == 0 && tipo_pagamento == '06') {
        soma = total_venda
    }

    setTimeout(() => {
        let cliente_id = $("#inp-cliente_id").val();

        if(cliente_id && soma > 0){
            $.get(path_url + "api/clientes/consulta-debito", {cliente_id: cliente_id, total: soma})
            .done((success) => {
                // console.log(success);
            })
            .fail((e) => {
                // console.log(e);
                swal("Erro", e.responseJSON, "error")
                CLIENTESEMLIMITE = 1
                validateButtonSave()
            });
        }
    }, 200)
}

$('#salvar_venda').click(() => {
    // consultaDebito()
    setTimeout(() => {

        let tipo_pagamento = $('#inp-tipo_pagamento').val()
        if(tipo_pagamento == 17){
            let data = {
                total_venda: total_venda,
                usuario_id: $('#usuario_id').val(),
                empresa_id: $('#empresa_id').val()
            }

            $.post(path_url + 'api/frenteCaixa/qr-code-pix', data)
            .done((success) => {
                // console.log(success)
                swal("Sucesso", "Chave PIX gerada", "success")
                .then(() => {
                    $(".qrcode").attr("src", "data:image/jpeg;base64,"+success['qrcode']);
                    $('#modal-pix').modal('show')
                    let payment_id = success['payment_id']
                    let pay = false

                    setInterval(() => {
                        if(pay == false){
                            let data = {
                                payment_id: payment_id,
                                usuario_id: $('#usuario_id').val(),
                                empresa_id: $('#empresa_id').val()
                            }

                            $.get(path_url + 'api/frenteCaixa/consulta-pix', data)
                            .done((res) => {

                                if(res == "approved"){
                                    $('#modal-pix').modal('hide')
                                    if(pay == false){
                                        swal("Sucesso", "Pagamento aprovado", "success")
                                        .then(() => {
                                            $('#finalizar_venda').modal('show')
                                        })
                                    }
                                    pay = true

                                }
                            })
                            .fail((err) => {

                            })
                        }
                    }, 4000)
                })
            })
            .fail((err) => {
                console.log(err)
                $('#finalizar_venda').modal('show')
            })
        }else{
            if(tipo_pagamento >= 30){
                let data = {
                    tipo_pagamento: tipo_pagamento,
                    total_venda: total_venda,
                    usuario_id: $('#usuario_id').val(),
                    empresa_id: $('#empresa_id').val()
                }

                $.post(path_url + 'api/tef/store', data)
                .done((hash) => {
                    console.log(hash)
                    consultaStatusTef(hash)
                })
                .fail((err) => {
                    console.log(err)
                })
            }else{
                $('#finalizar_venda').modal('show')
            }
        }
    }, 100)
})

$("#inp-valor_recebido").on("keyup", (event) => {
    let v = $("#inp-valor_recebido").val();
    v = v.replace(",", ".");

    let troco = v - (total_venda - DESCONTO + VALORACRESCIMO);
    if (troco > 0) {
        $("#valor-troco").html(convertFloatToMoeda(troco));
        $("#inp-troco").val(convertFloatToMoeda(troco));
    } else {
        $("#valor-troco").html("0,00");
        $("#inp-troco").val("0,00");
    }
});

$("body").on("click", "#btn-incrementa", function () {

    let inp = $(this).closest('div.input-group-append').prev()[0]
    let prodRow = $(this).closest('.line-product').find('.produto_row')
    let produto_id = prodRow.val()
    if (inp.value) {
        let v = convertMoedaToFloat(inp.value)
        $.get(path_url + "api/produtos/valida-estoque", { qtd: v+1, product_id: produto_id })
        .done((res) => {
            console.log(res)
            v += 1
            inp.value = convertFloatToMoeda(v)
            calcSubTotal()
        })
        .fail((err) => {
            // console.log(err);
            swal("Alerta", err.responseJSON, "warning")
        });
        
    }
})

$("body").on("click", "#btn-subtrai", function () {
    let inp = $(this).closest('.input-group').find('input')[0]
    if (inp.value) {
        let v = convertMoedaToFloat(inp.value)
        v -= 1
        inp.value = convertFloatToMoeda(v)

        calcSubTotal()
    }
})

// $(".table-itens").on('click', '.btn-delete-row', function () {
//     var row = $(this).closest('tr');
//     var produto_id = row.find('.produto_row').val();
//     var quantidade = row.find('.qtd').val();
//     quantidade = parseFloat(quantidade);
//     if (isNaN(quantidade) || quantidade <= 0) quantidade = 1;
//     var variacao_id = row.find('input[name="variacao_id[]"]').val();
    
//     // Obter o local_id correto do dropdown de estoque selecionado
//     var localEstoqueSelecionado = $('#local_estoque_select').length > 0 ? $('#local_estoque_select').val() : $('#local_estoque').val();
    
//     console.log('Removendo item do carrinho:', {
//         produto_id: produto_id,
//         quantidade: quantidade,
//         variacao_id: variacao_id,
//         local_id: localEstoqueSelecionado
//     });
    
//     // Restaurar o estoque antes de remover o item
//     $.post(path_url + 'api/frenteCaixa/restaurar-estoque', {
//         produto_id: produto_id,
//         quantidade: quantidade,
//         variacao_id: variacao_id,
//         local_id: localEstoqueSelecionado
//     }).done(function(data) {
//         console.log('Estoque restaurado com sucesso:', data);
        
//         // Remover a linha da tabela
//         row.remove();
        
//         swal({
//             title: "Sucesso",
//             text: "Produto removido e estoque restaurado!",
//             icon: "success",
//             closeOnClickOutside: false
//         });
//         CLIENTESEMLIMITE = 0;
//         calcTotal();
//     }).fail(function(xhr) {
//         console.error('Erro ao restaurar estoque:', xhr.responseText);
//         swal("Erro", "Erro ao restaurar estoque: " + xhr.responseText, "error");
//     });
// });

// Remove Produto
$(".table-itens").on('click', '.btn-delete-row', function () {
    var row = $(this).closest('tr');

    var produto_id = row.find('.produto_row').val();
    var quantidade = row.find('.qtd').val();
    var variacao_id = row.find('input[name="variacao_id[]"]').val();
    
    // Converter vírgula para ponto antes de transformar em número
    quantidade = quantidade.replace(',', '.');
    quantidade = parseFloat(quantidade);

    if (isNaN(quantidade) || quantidade <= 0) quantidade = 1;

    // Obter o local de estoque
    var localEstoqueSelecionado = $('#local_estoque_select').length > 0 
        ? $('#local_estoque_select').val() 
        : $('#local_estoque').val();

    console.log('Removendo item do carrinho:', {
        produto_id: produto_id,
        quantidade: quantidade,
        variacao_id: variacao_id,
        local_id: localEstoqueSelecionado
    });

    // Restaurar o estoque
    $.post(path_url + 'api/frenteCaixa/restaurar-estoque', {
        produto_id: produto_id,
        quantidade: quantidade,
        variacao_id: variacao_id,
        local_id: localEstoqueSelecionado
    }).done(function(data) {
        console.log('Estoque restaurado com sucesso:', data);
        
        // Remover a linha da tabela
        row.remove();

        swal({
            title: "Sucesso",
            text: "Produto removido e estoque restaurado!",
            icon: "success",
            closeOnClickOutside: false
        });

        CLIENTESEMLIMITE = 0;
        calcTotal();
    }).fail(function(xhr) {
        console.error('Erro ao restaurar estoque:', xhr.responseText);
        swal("Erro", "Erro ao restaurar estoque: " + xhr.responseText, "error");
    });
});

function calcSubTotal(e) {

    $(".line-product").each(function () {
        $qtd = $(this).find('.qtd')[0]
        $value = $(this).find('.value-unit')[0]
        $sub = $(this).find('.subtotal-item')[0]

        let qtd = convertMoedaToFloat($qtd.value)
        let value = convertMoedaToFloat($value.value)
        if (qtd <= 0) {
            $(this).remove()
        } else {
            // Garante que o subtotal seja exatamente o resultado de quantidade * valor unitário
            let subtotal = parseFloat((qtd * value).toFixed(2));
            $sub.value = convertFloatToMoeda(subtotal);
        }
    })
    setTimeout(() => {
        calcTotal()
    }, 10)
}

function setaDesconto() {
    if (total_venda == 0) {
        swal("Erro", "Total da venda é igual a zero", "warning");
    } else {
        let pass = $('#inp-senha_manipula_valor').val()

        if(pass != ''){
            swal({
                title: "Senha para desconto",
                text: "Informe a senha para continuar",
                content: "input",
                button: {
                    text: "Ok",
                    closeModal: false,
                    type: "error",
                },
            }).then((v) => {
                if(v == pass){
                    modalDesconto()
                }else{
                    swal("Erro", "Senha incorreta!", "error")
                }
            })
        }else{
            modalDesconto()
        }
    }
}

function modalDesconto(){
    swal({
        title: "Valor desconto?",
        text: "Informe o valor de desconto!",
        content: "input",
        button: {
            text: "Ok",
            closeModal: false,
            type: "error",
        },
    }).then((v) => {
        if (v) {
            let desconto = v;
            if (desconto.substring(0, 1) == "%") {
                let perc = desconto.substring(1, desconto.length);
                DESCONTO = TOTAL * (perc / 100);
                if (PERCENTUALMAXDESCONTO > 0) {
                    if (perc > PERCENTUALMAXDESCONTO) {
                        swal.close();
                        setTimeout(() => {
                            swal(
                                "Erro",
                                "Máximo de desconto permitido é de " +
                                PERCENTUALMAXDESCONTO +
                                "%",
                                "error"
                                );
                            $("#valor_desconto").html("0,00");
                        }, 500);
                    }
                }
                if (DESCONTO > 0) {
                    $("#valor_item").attr("disabled", "disabled");
                    $(".btn-mini-desconto").attr(
                        "disabled",
                        "disabled"
                        );
                } else {
                    $("#valor_item").removeAttr("disabled");
                    $(".btn-mini-desconto").removeAttr("disabled");
                }
            } else {
                desconto = desconto.replace(",", ".");
                DESCONTO = parseFloat(desconto);
                if (PERCENTUALMAXDESCONTO > 0) {
                    let tempDesc =
                    (TOTAL * PERCENTUALMAXDESCONTO) / 100;
                    if (tempDesc < DESCONTO) {
                        swal.close();

                        setTimeout(() => {
                            swal(
                                "Erro",
                                "Máximo de desconto permitido é de R$ " +
                                parseFloat(tempDesc),
                                "error"
                                );
                            $("#valor_desconto").html("0,00");
                        }, 500);
                    }
                }
                if (DESCONTO > 0) {
                    $("#valor_item").attr("disabled", "disabled");
                    $(".btn-mini-desconto").attr(
                        "disabled",
                        "disabled"
                        );
                } else {
                    $("#valor_item").removeAttr("disabled");
                    $(".btn-mini-desconto").removeAttr("disabled");
                }
            }
            if (desconto.length == 0) DESCONTO = 0;
            $("#valor_desconto").text("R$ " + convertFloatToMoeda(DESCONTO));
            calcTotal();
        }
        swal.close();
        $("#codBarras").focus();
    });
}

function setaAcrescimo() {

    if (total_venda == 0) {
        swal("Erro", "Total da venda é igual a zero", "warning");
    } else {

        let pass = $('#inp-senha_manipula_valor').val()

        if(pass != ''){
            swal({
                title: "Senha para acréscimo",
                text: "Informe a senha para continuar",
                content: "input",
                button: {
                    text: "Ok",
                    closeModal: false,
                    type: "error",
                },
            }).then((v) => {
                if(v == pass){
                    modalAcrescimo()
                }else{
                    swal("Erro", "Senha incorreta!", "error")
                }
            })
        }else{
            modalAcrescimo()
        }
    }
}

function modalAcrescimo(){
    swal({
        title: "Valor acréscimo?",
        text: "Informe o valor de acréscimo!",
        content: "input",
        button: {
            text: "Ok",
            closeModal: false,
            type: "error",
        },
    }).then((v) => {
        if (v) {
            let acrescimo = v;
            if (acrescimo > 0) {
                DESCONTO = 0;
                $("#valor_desconto").html(convertFloatToMoeda(DESCONTO));
            }
            let total = total_venda;
            if (acrescimo.substring(0, 1) == "%") {
                let perc = acrescimo.substring(1, acrescimo.length);
                VALORACRESCIMO = total * (perc / 100);
            } else {
                acrescimo = acrescimo.replace(",", ".");
                VALORACRESCIMO = parseFloat(acrescimo);
            }
            if (acrescimo.length == 0) VALORACRESCIMO = 0;
            calcTotal();
            VALORACRESCIMO = parseFloat(VALORACRESCIMO);
            $("#valor_acrescimo").text("R$ " + convertFloatToMoeda(VALORACRESCIMO));

            calcTotal();
            $("#codBarras").focus();
        }
        swal.close();
    });
}


$("#inp-tipo_pagamento").change(() => {
    $("#ipn-valor_recebido").val();
    let tipo = $("#inp-tipo_pagamento").val();
    let cliente = $("#inp-cliente_id").val();
    if (tipo == '06' && cliente == null) {
        swal("Alerta", "Informe o cliente!", "warning")
        $('#inp-tipo_pagamento').val('').change()
        $(".div-vencimento").addClass('d-none');
    }

    if (tipo == '06' && cliente != null) {
        $(".div-vencimento").removeClass('d-none');
    } else {
        $(".div-vencimento").addClass('d-none');
    }

    if (tipo == "03" || tipo == "04") {
        if($('#inp-abrir_modal_cartao').val() == 1){
            $('#cartao_credito').modal('show')
            $(".div-vencimento").addClass('d-none');
        }
    }

    if (tipo == "99") {
        $("#modal-pag-outros").modal("show");
        $(".div-vencimento").addClass('d-none');

    }
    if (tipo == "01") {
        $("#inp-valor_recebido").removeAttr("disabled");
        $("#finalizar-venda").attr("disabled", true);
        $("#finalizar-rascunho").attr("disabled", true);
        $("#finalizar-consignado").attr("disabled", true);
        $(".div-troco").removeClass('d-none');
        $(".div-vencimento").addClass('d-none');
    } else {
        $("#inp-valor_recebido").attr("disabled", "true");
        $(".div-troco").addClass('d-none');
        $("#finalizar-venda").removeAttr("disabled");
        $("#finalizar-rascunho").removeAttr("disabled");
        $("#finalizar-consignado").removeAttr("disabled");
    }

    validateButtonSave()
});

$("#inp-tipo_pagamento_row").change(() => {
    let cliente = $("#inp-cliente_id").val();
    let tipo = $("#inp-tipo_pagamento_row").val();
    if (tipo == '06') {
        if (cliente == null) {
            swal("Alerta", "Informe o cliente!", "warning")
            $('#inp-tipo_pagamento_row').val('').change()
        }
    }

})

$('#inp-valor_recebido').blur(() => {
    validateButtonSave()
})

$("#inp-quantidade").keypress(function(e){
    if(e.which == 13) {
        $('#inp-valor_unitario').focus()
        e.preventDefault();
    }
})

$("#inp-valor_unitario").keypress(function(e){
    if(e.which == 13) {
        $('.btn-add-item').trigger('click')
        e.preventDefault();
    }
})

$("body").on("keyup", "#inp-valor_unitario", function () {
    let valor = $(this).val();
    // Atualiza apenas o subtotal enquanto o usuário digita.
    let valorUnitario = convertMoedaToFloat(valor);
    let qtd = convertMoedaToFloat($("#inp-quantidade").val());
    if (!isNaN(qtd) && !isNaN(valorUnitario)) {
        let subtotal = parseFloat((qtd * valorUnitario).toFixed(2));
        $("#inp-subtotal").val(convertFloatToMoeda(subtotal));
    }
})

$("body").on("keyup", "#inp-quantidade", function () {
    let quantidade = $(this).val();
    let produto_id = $("#inp-produto_id").val();
    
    // Atualiza o subtotal ao digitar a quantidade
    let valorUnitario = convertMoedaToFloat($("#inp-valor_unitario").val());
    let qtd = convertMoedaToFloat(quantidade);
    
    // Garante que o subtotal seja calculado com precisão de 2 casas decimais
    if (!isNaN(qtd) && !isNaN(valorUnitario)) {
        let subtotal = parseFloat((qtd * valorUnitario).toFixed(2));
        $("#inp-subtotal").val(convertFloatToMoeda(subtotal));
    }
    
    // Verifica se há preço de atacado para a quantidade digitada
    $.get(path_url + "api/produtos/valida-atacado", { quantidade: quantidade, produto_id: produto_id })
    .done((success) => {
        if (success) {
            // Antes de aplicar o valor de atacado, valida se não viola o mínimo.
            $.get(path_url + "api/orcamentos/valida-desconto", {
                produto_id: produto_id,
                valor: success, // envia número (ponto) para evitar erro de parsing
                empresa_id: $('#empresa_id').val(),
                pdv: 1
            })
            .done(() => {
                // OK: aplica o preço de atacado
                $("#inp-valor_unitario").val(convertFloatToMoeda(success));
                let novoValorUnitario = convertMoedaToFloat(success);
                let novoSubtotal = parseFloat((qtd * novoValorUnitario).toFixed(2));
                $("#inp-subtotal").val(convertFloatToMoeda(novoSubtotal));
            })
            .fail((err) => {
                // Se o valor de atacado está abaixo do mínimo, não aplicar automaticamente
                // Mantém o valor atual e informa sutilmente ao operador.
                try {
                    let minimo = err && err.responseJSON ? err.responseJSON : null;
                    if (minimo) {
                        toastr.info(
                            'Preço de atacado (' + convertFloatToMoeda(success) + ') ignorado: mínimo é ' + convertFloatToMoeda(minimo),
                            '',
                            { timeOut: 2500, positionClass: 'toast-top-right', progressBar: true }
                        );
                    }
                } catch(e) {}
            });
        }
    })
    .fail((err) => {
        console.log(err);
    });
})

function validateButtonSave() {
    $('#salvar_venda').attr("disabled", 1)
    $('#editar_venda').attr("disabled", 1)

    if(CLIENTESEMLIMITE){
        return;
    }

    let total = convertMoedaToFloat($(".total-venda").text())
    var tipo = $('#inp-tipo_pagamento').val()
    var tipo_row = $('.table-payment').length ? $('.table-payment tbody tr').length : null

    var valor_recebido = convertMoedaToFloat($('#inp-valor_recebido').val())
    if (total > 0 && (tipo || tipo_row)) {
        if (Math.abs(total - (typeof DESCONTO !== 'undefined' ? parseFloat(DESCONTO) : 0)) < 0.01) {
            // Só permite salvar se for SEM PAGAMENTO
            if (tipo == '99') {
                $('#salvar_venda').removeAttr("disabled")
                $('#editar_venda').removeAttr("disabled")
            } else {
                $('#salvar_venda').attr("disabled", 1)
                $('#editar_venda').attr("disabled", 1)
            }
        } else if (tipo == '01' && valor_recebido >= total) {
            $('#salvar_venda').removeAttr("disabled")
            $('#editar_venda').removeAttr("disabled")
        }
        else if (tipo != '01') {
            $('#salvar_venda').removeAttr("disabled")
            $('#editar_venda').removeAttr("disabled")
        }
        else if (tipo_row) {
            $('#salvar_venda').removeAttr("disabled")
            $('#editar_venda').removeAttr("disabled")
        }
        else {
            $('#salvar_venda').attr("disabled", 1)
            $('#editar_venda').attr("disabled", 1)
        }
    }
}

$('#editar_venda').click(() => {
    $('#finalizar_venda').modal('show')
})

function consultaStatusTef(hash){
    $('#modal_tef_consulta').modal('show')
    $('.status-tef').text('Processando')
    $('.loading-tef').removeClass('d-none')
    let data = {
        hash: hash,
        usuario_id: $('#usuario_id').val(),
        empresa_id: $('#empresa_id').val()
    }
    $('.modal-loading').remove()
    let intervalo = null;
    intervalo = setInterval(() => {
        $.post(path_url + 'api/tef/consulta', data)
        .done((success) => {
            console.log(success)
            if(success == "Transação Aceita"){
                $('#tef_hash').val(hash)
                swal("Sucesso", "Transação Aprovada!", "success")
                .then(() => {
                    $('#modal_tef_consulta').modal('hide')
                    $('#finalizar_venda').modal('show')
                })
                clearInterval(intervalo)
            }
        })
        .fail((err) => {
            console.log(err)
            clearInterval(intervalo)
            $('.status-tef').text(err.responseJSON)
            setTimeout(() => {
                $('#modal_tef_consulta').modal('hide')
            }, 2000)
        })
    }, 3000)
}

$(".modal-funcionario select").each(function () {

    let id = $(this).prop("id");

    if (id == "inp-funcionario_id") {

        $(this).select2({
            minimumInputLength: 2,
            language: "pt-BR",
            placeholder: "Digite para buscar o funcionário",
            theme: "bootstrap4",
            dropdownParent: $(this).parent(),
            ajax: {
                cache: true,
                url: path_url + "api/funcionarios/pesquisa",
                dataType: "json",
                data: function (params) {
                    console.clear();
                    var query = {
                        pesquisa: params.term,
                        empresa_id: $("#empresa_id").val(),
                    };
                    return query;
                },
                processResults: function (response) {
                    var results = [];

                    $.each(response, function (i, v) {
                        var o = {};
                        o.id = v.id;

                        o.text = v.nome;
                        o.value = v.id;
                        results.push(o);
                    });
                    return {
                        results: results,
                    };
                },
            },
        });
    }
});

$("#lista_precos select").each(function () {

    let id = $(this).prop("id");

    if (id == "inp-lista_preco_id") {

        $(this).select2({
            minimumInputLength: 2,
            language: "pt-BR",
            placeholder: "Digite para buscar a lista de preço",
            theme: "bootstrap4",
            dropdownParent: $(this).parent(),
            ajax: {
                cache: true,
                url: path_url + "api/lista-preco/pesquisa",
                dataType: "json",
                data: function (params) {
                    console.clear();
                    var query = {
                        pesquisa: params.term,
                        empresa_id: $("#empresa_id").val(),
                        usuario_id: $("#usuario_id").val(),
                        tipo_pagamento_lista: $("#inp-tipo_pagamento_lista").val(),
                        funcionario_lista_id: $("#inp-funcionario_lista_id").val(),
                    };
                    return query;
                },
                processResults: function (response) {
                    console.log(response)
                    var results = [];

                    $.each(response, function (i, v) {
                        var o = {};
                        o.id = v.id;

                        o.text = v.nome + " " + v.percentual_alteracao + "%";
                        o.value = v.id;
                        results.push(o);
                    });
                    return {
                        results: results,
                    };
                },
            },
        });
    }
});

$("#modal-cliente select").each(function () {
    let id = $(this).prop("id");
    if (id == "inp-cliente_id") {
        $(this).select2({
            minimumInputLength: 2,
            language: "pt-BR",
            placeholder: "Digite para buscar o cliente",
            width: "100%",
            theme: "bootstrap4",
            dropdownParent: $(this).parent(),
            ajax: {
                cache: true,
                url: path_url + "api/clientes/pesquisa",
                dataType: "json",
                data: function (params) {
                    console.clear();
                    var query = {
                        pesquisa: params.term,
                        empresa_id: $("#empresa_id").val(),
                    };
                    return query;
                },
                processResults: function (response) {

                    var results = [];
                    $.each(response, function (i, v) {
                        var o = {};
                        o.id = v.id;

                        o.text = v.razao_social + " - " + v.cpf_cnpj;
                        o.value = v.id;
                        results.push(o);
                        $('.cliente_selecionado').text(v.razao_social);
                        
                    });
                    return {
                        results: results,
                    };
                },
            },
        });
    }
});

$(".btn-add-payment").click(() => {
    let tipo_pagamento_row = $("#inp-tipo_pagamento_row").val();
    let vencimento = $("#inp-data_vencimento_row").val();
    let valor_integral_row = $("#inp-valor_row").val();
    let obs_row = $("#inp-observacao_row").val();

    let v = convertMoedaToFloat(valor_integral_row);
    let totalVenda = convertMoedaToFloat($('.total-venda').text());

    // LOG PARA DEPURACAO
    console.log("tipo_pagamento_row:", tipo_pagamento_row, "totalVenda:", totalVenda, "v:", v);

    // Permitir valor 0,00 apenas se for SEM PAGAMENTO e total da venda for zero
    if (v === 0) {
        swal('Atenção', 'Só é permitido adicionar pagamento com valor maior que zero.', 'warning');
        return;
    }

    validateButtonSave();

    // Ajuste: Permitir valor_integral_row vazio ou 0,00 se for Sem Pagamento e totalVenda zero
    if (!(vencimento && valor_integral_row && tipo_pagamento_row)) {
        swal(
            "Atenção",
            "Informe corretamente os campos para continuar!",
            "warning"
        );
        return;
    }

    if (v + total_payment <= total_venda) {
        if (vencimento && valor_integral_row && tipo_pagamento_row) {
            let dataRequest = {
                data_vencimento_row: vencimento,
                valor_integral_row: valor_integral_row,
                obs_row: obs_row,
                tipo_pagamento_row: tipo_pagamento_row,
            };
            $.get(path_url + "api/frenteCaixa/linhaParcelaVenda", dataRequest)
            .done((e) => {
                $(".table-payment tbody").append(e);
                calcTotalPayment();
            })
            .fail((e) => {
                console.log(e);
            });
        } else {
            swal(
                "Atenção",
                "Informe corretamente os campos para continuar!",
                "warning"
            );
        }
    } else {
        swal(
            "Atenção",
            "A soma das parcelas não bate com o valor total da venda",
            "warning"
        );
    }
});


$(".pagamento_multiplo").click(() => {
    // let cliente = $("#inp-cliente_id").val();
    let count_itens = $(".table-itens tbody tr").length

    setTimeout(() => {
        if (count_itens == 0) {
            swal("Erro", "Adicione um produto!", "warning");
        }
        // if (cliente == null) {
        //     swal("Erro", "Adicione um cliente", "warning");
        // }
    }, 200)
})

$("body").on("click", ".btn-delete", function (e) {

    e.preventDefault();
    var form = $(this).parents("form").attr("id");
    
    swal({
        title: "Você está certo?",
        text: "Uma vez deletado, você não poderá recuperar esse item novamente!",
        icon: "warning",
        buttons: true,
        buttons: ["Cancelar", "Excluir"],
        dangerMode: true,
    }).then((isConfirm) => {
        if (isConfirm) {

            document.getElementById(form).submit();
        } else {
            swal("", "Este item está salvo!", "info");
        }
    });
});

var total_payment = 0;
function calcTotalPayment() {
    $('#btn-pag_row').attr("disabled", true)

    var total = 0;
    $(".valor_integral").each(function () {
        total += convertMoedaToFloat($(this).val());
    });
    setTimeout(() => {
        total_payment = total;
        $(".sum-payment").html("R$ " + convertFloatToMoeda(total));

        $(".sum-restante").html("R$ " + convertFloatToMoeda((total_venda - DESCONTO) - total));
    }, 100);

    let dif = total_venda - total;

    let diferenca = dif.toFixed(2);

    if (diferenca <= 10) {
        $("#btn-pag_row").removeAttr("disabled")
    }
}


$(".table-payment").on("click", ".btn-delete-row", function () {
    $(this).closest("tr").remove();
    swal("Sucesso", "Parcela removida!", "success");
    calcTotalPayment();
});


$.fn.serializeFormJSON = function () {

    var o = {};
    var a = this.serializeArray();
    
    // Campos que devem sempre ser strings, não arrays
    var stringFields = [
        'cliente_nome', 'cliente_cpf_cnpj', 'funcionario_id', 
        'observacao', 'bandeira_cartao', 'cAut_cartao', 'cnpj_cartao',
        'tipo_pagamento', 'estado', 'numero', 'numero_serie',
        'empresa_id', 'usuario_id', 'caixa_id', 'local_id'
    ];
    
    $.each(a, function () {
        if (o[this.name]) {
            // Se o campo deve ser sempre string, pegar apenas o último valor
            if (stringFields.includes(this.name)) {
                o[this.name] = this.value || '';
            } else {
                // Para outros campos, permitir arrays
                if (!o[this.name].push) {
                    o[this.name] = [o[this.name]];
                }
                o[this.name].push(this.value || '');
            }
        } else {
            o[this.name] = this.value || '';
        }
    });
    return o;
};

function selecionaLista(){
    let tipo_pagamento_lista = $('#inp-tipo_pagamento_lista').val()
    let funcionario_lista_id = $('#inp-funcionario_lista_id').val()
    let lista_preco_id = $('#inp-lista_preco_id').val()

    if(!lista_preco_id){
        swal("Alerta", "Selecione a lista", "warning")
        return;
    }

    if(tipo_pagamento_lista){
        $('#inp-tipo_pagamento').val(tipo_pagamento_lista).change()
    }
    if(funcionario_lista_id){
        $.get(path_url + "api/funcionarios/find", {id: funcionario_lista_id})
        .done((res) => {
            console.log(res)
            var newOption = new Option(res.nome, res.id, true, false);
            $('#inp-funcionario_id').append(newOption);
            $('.funcionario_selecionado').text(res.nome)

        })
        .fail((err) => {
            console.log(err);
        });
    }

    $('#lista_id').val(lista_preco_id)
    setTimeout(() => {
        todos()
    }, 10)
    setTimeout(() => {
        $("#codBarras").focus();
    }, 500)
}

$("body").on("change", "#inp-lista_preco_id", function () {
    $.get(path_url + "api/lista-preco/find", {id: $(this).val()})
    .done((res) => {
        console.log(res)
        $('#inp-tipo_pagamento_lista').val(res.tipo_pagamento).change()

        if(res.funcionario_id){
            $('#inp-funcionario_lista_id').val(res.funcionario_id).change();
        }
    })
    .fail((err) => {
        console.log(err);
    });
})

var emitirNfce = false
$('#btn_fiscal').click(() => {
    emitirNfce = true
    
    // Adiciona campo oculto para identificar o tipo de emissão
    if ($("#emitir_nfce").length) {
        $("#emitir_nfce").val('true');
    } else {
        $("<input>").attr({
            type: "hidden",
            id: "emitir_nfce",
            name: "emitir_nfce",
            value: "true"
        }).appendTo("#form-pdv");
        
        if($("#form-pdv-update").length){
            $("<input>").attr({
                type: "hidden",
                id: "emitir_nfce",
                name: "emitir_nfce",
                value: "true"
            }).appendTo("#form-pdv-update");
        }
    }
    
    // Verificar se é venda a prazo e se tem cliente selecionado
    let cliente_id = $('#inp-cliente_id').val();
    let tipo_pagamento = $('#inp-tipo_pagamento').val();
    
    // Verificar se há venda a prazo nas linhas de pagamento
    let hasVendaPrazo = false;
    
    if (tipo_pagamento == '06') {
        hasVendaPrazo = true;
    } else {
        // Se houver pagamento múltiplo, verificar nas linhas
        $('.tipo_pagamento').each(function() {
            if ($(this).val() == '06') {
                hasVendaPrazo = true;
            }
        });
    }
    
    // Se for venda a prazo e não tiver cliente selecionado
    if (hasVendaPrazo && (!cliente_id || cliente_id == '')) {
        swal("Erro", "Para vendas a prazo é necessário selecionar um cliente.", "error");
        return;
    }
    
    // Se for venda a prazo, verificar o crédito do cliente
    if (hasVendaPrazo && cliente_id) {
        var formData = {};
        var verificaCreditoUrl;
        
        if($("#form-pdv-update").length){
            formData = $("#form-pdv-update").serializeFormJSON();
            verificaCreditoUrl = path_url + 'api/frenteCaixa/verificar-credito/'+$('#venda_id').val();
        } else {
            formData = $("#form-pdv").serializeFormJSON();
            verificaCreditoUrl = path_url + 'api/frenteCaixa/verificar-credito';
        }
        
        formData.empresa_id = $('#empresa_id').val();
        formData.usuario_id = $('#usuario_id').val();
        
        // Fazer a verificação de crédito
        $.ajax({
            url: verificaCreditoUrl,
            type: 'POST',
            data: formData,
            async: false, // Requisição síncrona para garantir verificação antes de prosseguir
            success: function(creditoOk) {
                console.log("Verificação de crédito: OK");
                // Se o crédito estiver OK, prosseguir com a submissão do formulário
                if($("#form-pdv-update").length){
                    $("#form-pdv-update").submit();
                } else {
                    $("#form-pdv").submit();
                }
            },
            error: function(err) {
                console.log("Erro na verificação de crédito:", err);
                
                // Mostrar o erro de limite de crédito
                if (err.status === 401) {
                    swal({
                        title: "Limite de Crédito Excedido",
                        text: err.responseText.replace(/"/g, ''), // Remover aspas extras
                        icon: "error",
                        buttons: ["Fechar", false],
                        dangerMode: true,
                    });
                } else {
                    swal("Erro", err.responseJSON || "Erro ao verificar limite de crédito", "error");
                }
            }
        });
    } else {
        // Se não for venda a prazo, prosseguir normalmente
        if($("#form-pdv-update").length){
            $("#form-pdv-update").submit();
        } else {
            $("#form-pdv").submit();
        }
    }
})

$('#btn_nao_fiscal').click(() => {
    emitirNfce = false
    
    // Verificar se há venda a prazo
    let hasVendaPrazo = false;
    $('.pagamento-row, .payment-row').each(function() {
        let tipoPagamento = $(this).find('.payment_type').val();
        if (tipoPagamento == '05' || tipoPagamento == '06') {
            hasVendaPrazo = true;
        }
    });
    
    // Se for venda a prazo, verificar o cliente
    let cliente_id = $('#inp-cliente').val();
    if (hasVendaPrazo && !cliente_id) {
        swal("Atenção", "Para vendas a prazo é necessário informar o cliente!", "warning");
        return;
    }
    
    // Se for venda a prazo, verificar o crédito do cliente
    if (hasVendaPrazo && cliente_id) {
        var formData = {};
        var verificaCreditoUrl;
        
        if($("#form-pdv-update").length){
            formData = $("#form-pdv-update").serializeFormJSON();
            verificaCreditoUrl = path_url + 'api/frenteCaixa/verificar-credito/'+$('#venda_id').val();
        } else {
            formData = $("#form-pdv").serializeFormJSON();
            verificaCreditoUrl = path_url + 'api/frenteCaixa/verificar-credito';
        }
        
        formData.empresa_id = $('#empresa_id').val();
        formData.usuario_id = $('#usuario_id').val();
        
        // Fazer a verificação de crédito
        $.ajax({
            url: verificaCreditoUrl,
            type: 'POST',
            data: formData,
            async: false, // Requisição síncrona para garantir verificação antes de prosseguir
            success: function(creditoOk) {
                console.log("Verificação de crédito: OK");
                // Se o crédito estiver OK, prosseguir com a submissão do formulário
                if($("#form-pdv-update").length){
                    $("#form-pdv-update").submit();
                } else {
                    $("#form-pdv").submit();
                }
            },
            error: function(xhr) {
                try {
                    let response = JSON.parse(xhr.responseText);
                    if (response && response.message) {
                        swal("Atenção", response.message, "warning");
                    } else {
                        swal("Erro", "Ocorreu um erro ao verificar o crédito do cliente", "error");
                    }
                } catch (e) {
                    swal("Erro", "Ocorreu um erro ao verificar o crédito do cliente", "error");
                }
            }
        });
    } else {
        // Se não for venda a prazo, submeter o formulário diretamente
        if($("#form-pdv-update").length){
            $("#form-pdv-update").submit();
        } else {
            $("#form-pdv").submit();
        }
    }
    
    $('#finalizar_venda').modal('hide')
})

$("#form-pdv").on("submit", function (e) {
    e.preventDefault();
    const form = $(e.target);
    var json = $(this).serializeFormJSON();

    json.empresa_id = $('#empresa_id').val()
    json.usuario_id = $('#usuario_id').val()
    json.local_id = $('#local_estoque_select').length > 0 ? $('#local_estoque_select').val() : $('#local_estoque').val() // Adicionar local_id selecionado

    json.desconto = convertMoedaToFloat($('#valor_desconto').text())
    json.acrescimo = convertMoedaToFloat($('#valor_acrescimo').text())
    // Garante que o array de pagamentos será enviado corretamente
    json.pagamentos = window.pagamentosRegistradosPDV || [];
    json.valor_credito_utilizado = CREDITO_UTILIZADO;
    
    // Garantir que campos de texto sejam strings, não arrays
    console.log("Debug - cliente_nome antes:", json.cliente_nome, "tipo:", typeof json.cliente_nome, "é array:", Array.isArray(json.cliente_nome));
    console.log("Debug - cliente_cpf_cnpj antes:", json.cliente_cpf_cnpj, "tipo:", typeof json.cliente_cpf_cnpj, "é array:", Array.isArray(json.cliente_cpf_cnpj));
    console.log("Debug - funcionario_id antes:", json.funcionario_id, "tipo:", typeof json.funcionario_id, "é array:", Array.isArray(json.funcionario_id));
    
    if (json.cliente_nome && Array.isArray(json.cliente_nome)) {
        json.cliente_nome = json.cliente_nome.join(' ');
        console.log("Debug - cliente_nome convertido para:", json.cliente_nome);
    }
    if (json.cliente_cpf_cnpj && Array.isArray(json.cliente_cpf_cnpj)) {
        json.cliente_cpf_cnpj = json.cliente_cpf_cnpj.join('');
        console.log("Debug - cliente_cpf_cnpj convertido para:", json.cliente_cpf_cnpj);
    }
    if (json.funcionario_id && Array.isArray(json.funcionario_id)) {
        json.funcionario_id = json.funcionario_id[0];
        console.log("Debug - funcionario_id convertido para:", json.funcionario_id);
    }
    
    // Enviar ID da pré-venda se foi carregada
    console.log("Debug - window.preVendaCarregada:", window.preVendaCarregada);
    console.log("Debug - preVendaCarregada:", preVendaCarregada);
    
    if ((window.preVendaCarregada && window.preVendaCarregada.id) || (preVendaCarregada && preVendaCarregada.id)) {
        json.pre_venda_id = (window.preVendaCarregada && window.preVendaCarregada.id) ? window.preVendaCarregada.id : preVendaCarregada.id;
        console.log("Debug - pre_venda_id definido:", json.pre_venda_id);
    } else {
        console.log("Debug - Nenhuma pré-venda carregada");
    }
    console.log(">>>>>>>> salvando ", json);
    console.log("Debug - emitirNfce:", emitirNfce);
    console.log("Debug - emitirNfce tipo:", typeof emitirNfce);
    // return;
    $.post(path_url + 'api/frenteCaixa/store', json)
    .done((success) => {
        console.log("Debug - Venda criada com sucesso:", success);
        console.log("Debug - emitirNfce no done:", emitirNfce);
        if (emitirNfce == true) {
            console.log("Debug - Chamando gerarNfce");
            gerarNfce(success)
        } else {
            // Prompt de confirmação com fallback e compatibilidade
            (function(){
                var abrirCupom = function(vendaId){
                    var url = path_url + 'frontbox/imprimir-nao-fiscal/' + vendaId;
                    try {
                        // Tentar via window.open
                        var novaAba = window.open(url, '_blank');
                        if (!novaAba || novaAba.closed || typeof novaAba.closed === 'undefined') {
                            // Fallback: abrir via link programático
                            var a = document.createElement('a');
                            a.href = url;
                            a.target = '_blank';
                            a.rel = 'noopener';
                            document.body.appendChild(a);
                            a.click();
                            document.body.removeChild(a);
                        }
                    } catch (e) {
                        // Último fallback: redirecionar mesma aba
                        window.location.href = url;
                    }
                };

                var prosseguirRedirecionamento = function(){
                    if($('#pedido_delivery_id').length){
                        location.href = '/pedidos-delivery';
                    }else if($('#pedido_id').length){
                        location.href = '/pedidos-cardapio';
                    }else{
                        location.href = '/frontbox/create';
                    }
                };

                var vendaId = (success && (success.id || success)) ? (success.id || success) : null;

                if (typeof Swal !== 'undefined' && Swal.fire) {
                    Swal.fire({
                        title: 'Sucesso',
                        text: 'Venda finalizada com sucesso, deseja imprimir o comprovante?',
                        icon: 'success',
                        showCancelButton: true,
                        confirmButtonText: 'Sim',
                        cancelButtonText: 'Não'
                    }).then(function(result){
                        if (result.isConfirmed && vendaId) {
                            abrirCupom(vendaId);
                        }
                        prosseguirRedirecionamento();
                    });
                } else if (typeof swal !== 'undefined') {
                    swal({
                        title: 'Sucesso',
                        text: 'Venda finalizada com sucesso, deseja imprimir o comprovante?',
                        icon: 'success',
                        buttons: ["Não", "Sim"],
                        dangerMode: true,
                    }).then(function(isConfirm){
                        if (isConfirm && vendaId) {
                            abrirCupom(vendaId);
                        }
                        prosseguirRedirecionamento();
                    });
                } else {
                    // Fallback simples sem biblioteca
                    if (vendaId && window.confirm('Venda finalizada com sucesso, deseja imprimir o comprovante?')) {
                        abrirCupom(vendaId);
                    }
                    prosseguirRedirecionamento();
                }
            })();
        }
    }).fail((err) => {
        // Tratar erros, especialmente erro 401 de limite de crédito
        if (err.status === 401) {
            swal({
                title: "Limite de Crédito Excedido",
                text: err.responseText.replace(/"/g, ''), // Remover aspas extras
                icon: "error",
                buttons: ["Fechar", false],
                dangerMode: true,
            });
        } else {
            swal("Erro", err.responseJSON, "error");
        }
        console.log(err);
    })
});

$("body").on("click", "#btn-suspender", function () {
    swal({
        title: "Você esta certo?",
        text: "Deseja suspender esta venda?",
        icon: "warning",
        buttons: true,
        buttons: ["Cancelar", "Suspender"],
    }).then(confirm => {
        if (confirm) {
            console.clear()

            var json = $("#form-pdv").serializeFormJSON();
            json.empresa_id = $('#empresa_id').val()
            json.usuario_id = $('#usuario_id').val()

            console.log(json)
            $.post(path_url + 'api/frenteCaixa/suspender', json)
            .done((success) => {
                console.log(success)
                swal("Sucesso", "Venda suspensa!", "success")
                .then(() => {
                    location.reload()
                })
            })
            .fail((err) => {
                console.log(err)
                swal("Erro", "Algo deu errado", "error")
            })
        }
    });
})

var update = false
$("#form-pdv-update").on("submit", function (e) {
    update = true
    e.preventDefault();
    const form = $(e.target);
    var json = $(this).serializeFormJSON();

    json.empresa_id = $('#empresa_id').val()
    json.usuario_id = $('#usuario_id').val()

    json.desconto = convertMoedaToFloat($('#valor_desconto').text())
    json.acrescimo = convertMoedaToFloat($('#valor_acrescimo').text())
    console.log(">>>>>>>> UPDATE ", json);
    $.post(path_url + 'api/frenteCaixa/update/'+$('#venda_id').val(), json)
    .done((success) => {

        if (emitirNfce == true) {
            gerarNfce(success)
        } else {
            // Prompt de confirmação com fallback e compatibilidade
            (function(){
                var abrirCupom = function(vendaId){
                    var url = path_url + 'frontbox/imprimir-nao-fiscal/' + vendaId;
                    try {
                        var novaAba = window.open(url, '_blank');
                        if (!novaAba || novaAba.closed || typeof novaAba.closed === 'undefined') {
                            var a = document.createElement('a');
                            a.href = url;
                            a.target = '_blank';
                            a.rel = 'noopener';
                            document.body.appendChild(a);
                            a.click();
                            document.body.removeChild(a);
                        }
                    } catch (e) {
                        window.location.href = url;
                    }
                };

                var prosseguirRedirecionamento = function(){
                    if($('#pedido_delivery_id').length){
                        location.href = '/pedidos-delivery';
                    }else if($('#pedido_id').length){
                        location.href = '/pedidos-cardapio';
                    }else{
                        if(update){
                            location.href = path_url+'frontbox'
                        }else{
                            location.reload()
                        }
                    }
                };

                var vendaId = (success && (success.id || success)) ? (success.id || success) : null;

                if (typeof Swal !== 'undefined' && Swal.fire) {
                    Swal.fire({
                        title: 'Sucesso',
                        text: 'Venda finalizada com sucesso, deseja imprimir o comprovante?',
                        icon: 'success',
                        showCancelButton: true,
                        confirmButtonText: 'Sim',
                        cancelButtonText: 'Não'
                    }).then(function(result){
                        if (result.isConfirmed && vendaId) {
                            abrirCupom(vendaId);
                        }
                        prosseguirRedirecionamento();
                    });
                } else if (typeof swal !== 'undefined') {
                    swal({
                        title: 'Sucesso',
                        text: 'Venda finalizada com sucesso, deseja imprimir o comprovante?',
                        icon: 'success',
                        buttons: ["Não", "Sim"],
                        dangerMode: true,
                    }).then(function(isConfirm){
                        if (isConfirm && vendaId) {
                            abrirCupom(vendaId);
                        }
                        prosseguirRedirecionamento();
                    });
                } else {
                    if (vendaId && window.confirm('Venda finalizada com sucesso, deseja imprimir o comprovante?')) {
                        abrirCupom(vendaId);
                    }
                    prosseguirRedirecionamento();
                }
            })();
        }
    }).fail((err) => {
        // Tratar erros, especialmente erro 401 de limite de crédito
        if (err.status === 401) {
            swal({
                title: "Limite de Crédito Excedido",
                text: err.responseText.replace(/"/g, ''), // Remover aspas extras
                icon: "error",
                buttons: ["Fechar", false],
                dangerMode: true,
            });
        } else {
            swal("Erro", err.responseJSON, "error");
        }
        console.log(err);
    })
});

function gerarNfce(venda) {
    console.log("Debug - gerarNfce chamada com venda:", venda);
    console.log("Debug - window.preVendaCarregada:", window.preVendaCarregada);
    console.log("Debug - preVendaCarregada:", preVendaCarregada);
    
    let empresa_id = $("#empresa_id").val();

    // Verificar crédito do cliente novamente antes de emitir a NFCe
    console.log("Debug - Iniciando verificação de crédito para venda ID:", venda.id);
    $.ajax({
        url: path_url + "api/frenteCaixa/verificar-credito/" + venda.id,
        type: 'POST',
        data: {
            empresa_id: empresa_id,
            usuario_id: $('#usuario_id').val()
        },
        async: false, // Requisição síncrona para garantir verificação antes de prosseguir
        success: function(creditoOk) {
            console.log("Debug - Verificação de crédito para NFCe: OK");
            console.log("Debug - Iniciando emissão da NFCe...");
            
            // Emitir a NFCe
            console.log("Debug - Enviando requisição para emissão da NFCe:", {
                url: path_url + "api/nfce_painel/emitir",
                id: venda.id
            });
            
            $.post(path_url + "api/nfce_painel/emitir", {
                id: venda.id,
            })
            .done((success) => {
                console.log("Debug - NFCe emitida com sucesso:", success);
                console.log("Debug - Abrindo impressão para venda ID:", venda.id);
                
                // Abrir impressão imediatamente
                try {
                    window.open(path_url + 'nfce/imprimir/' + venda.id, "_blank");
                    console.log("Debug - Janela de impressão aberta");
                } catch (error) {
                    console.error("Debug - Erro ao abrir impressão:", error);
                }
                
                // Mostrar mensagem de sucesso
                alert("NFCe emitida com sucesso! Chave: " + success.chave);
                
                // Redirecionar após um tempo
                setTimeout(() => {
                    console.log("Debug - Redirecionando...");
                    if(!update){
                        location.reload()
                    }else{
                        location.href = path_url+'frontbox'
                    }
                }, 2000)
            })
            .fail((err) => {
                console.error("Debug - Erro na emissão da NFCe:", err);
                console.error("Debug - Status do erro:", err.status);
                console.error("Debug - Response do erro:", err.responseJSON);
                console.error("Debug - Response text:", err.responseText);
                swal("Erro ao emitir NFCe", err.responseJSON, "error");
            });
        },
        error: function(err) {
            console.log("Erro na verificação de crédito para NFCe:", err);
            
            // Mostrar o erro de limite de crédito
            if (err.status === 401) {
                swal({
                    title: "Limite de Crédito Excedido",
                    text: err.responseText.replace(/"/g, ''), // Remover aspas extras
                    icon: "error",
                    buttons: ["Fechar", false],
                    dangerMode: true,
                });
            } else {
                swal("Erro", err.responseJSON || "Erro ao verificar limite de crédito", "error");
            }
        }
    });
}

function adicionaZero(numero) {
    if (numero <= 9)
        return "0" + numero;
    else
        return numero;
}
$(function () {
    let data = new Date
    let dataFormatada = (data.getFullYear() + "-" + adicionaZero((data.getMonth() + 1)) + "-" + adicionaZero(data.getDate()));
    $('.data_atual').val(dataFormatada)
})


$('.funcionario-venda').click(() => {
    let funcionario_id = $('#inp-funcionario_id').val()
    $.get(path_url + "api/funcionarios/find/", {id: funcionario_id})
    .done((e) => {
        $('.funcionario_selecionado').text(e.nome)
    })
    .fail((e) => {
        console.log(e);
    });
})

// Função para restaurar estoque de todos os itens do carrinho
function restaurarEstoqueTodosItens() {
    var itens = $('.table-itens tbody tr');
    var promises = [];
    
    itens.each(function() {
        var row = $(this);
        var produto_id = row.find('.produto_row').val();
        var quantidade = row.find('.qtd').val();
        quantidade = parseFloat(quantidade);
        if (isNaN(quantidade) || quantidade <= 0) quantidade = 1;
        var variacao_id = row.find('input[name="variacao_id[]"]').val();
        var local_id = $('#local_estoque_select').length > 0 ? $('#local_estoque_select').val() : $('#local_estoque').val();
        
        if (produto_id && quantidade) {
            var promise = $.post(path_url + 'api/frenteCaixa/restaurar-estoque', {
                produto_id: produto_id,
                quantidade: quantidade,
                variacao_id: variacao_id,
                local_id: local_id
            });
            promises.push(promise);
        }
    });
    
    return Promise.all(promises);
}

// Capturar clique no botão "Nova Venda"
$(document).on('click', 'a[href*="frontbox.create"]', function(e) {
    e.preventDefault();
    var href = $(this).attr('href');
    
    // Verificar se há itens no carrinho
    if ($('.table-itens tbody tr').length > 0) {
        swal({
            title: "Nova Venda",
            text: "Deseja cancelar a venda atual e iniciar uma nova? O estoque será restaurado.",
            icon: "warning",
            buttons: ["Cancelar", "Sim, Nova Venda"],
            dangerMode: false,
        }).then((willProceed) => {
            if (willProceed) {
                // Mostrar loading
                swal({
                    title: "Restaurando estoque...",
                    text: "Aguarde enquanto restauramos o estoque dos produtos.",
                    icon: "info",
                    buttons: false,
                    closeOnClickOutside: false,
                    closeOnEsc: false,
                });
                
                // Restaurar estoque de todos os itens
                restaurarEstoqueTodosItens().then(function() {
                    swal.close();
                    // Limpar dados da pré-venda carregada
                    window.preVendaCarregada = null;
                    // Redirecionar para nova venda
                    window.location.href = href;
                }).catch(function(error) {
                    swal.close();
                    swal("Erro", "Erro ao restaurar estoque: " + error, "error");
                });
            }
        });
    } else {
        // Se não há itens, limpar dados da pré-venda carregada e redirecionar
        window.preVendaCarregada = null;
        window.location.href = href;
    }
});

function validarPagamentoSemPagamento() {
    let totalVenda = convertMoedaToFloat($('.total-venda').text());
    let tipoPagamento = $('#inp-tipo_pagamento').val();
    if (Math.abs(totalVenda) < 0.01) {
        // Só permite "SEM PAGAMENTO" (ex: tipo '99')
        $("#inp-tipo_pagamento option").each(function() {
            if ($(this).val() !== '99') {
                $(this).attr('disabled', true);
            } else {
                $(this).removeAttr('disabled');
            }
        });
        if (tipoPagamento !== '99') {
            $('#inp-tipo_pagamento').val('99').change();
            swal('Atenção', 'Quando o valor total da venda for zero, só é permitido a forma de pagamento SEM PAGAMENTO.', 'info');
        }
        // Força valor 0,00
        $('#inp-valor_row').val('0,00');
        // Bloqueia botão de adicionar pagamento
        $('.btn-add-payment, #btn-pag_row').attr('disabled', true);
        // Remove todos os pagamentos registrados
        if ($('.table-payment tbody tr').length > 0) {
            $('.table-payment tbody').empty();
            if (typeof window.pagamentosRegistradosPDV !== 'undefined') {
                window.pagamentosRegistradosPDV = [];
            }
        }
    } else {
        // Libera todas as opções
        $("#inp-tipo_pagamento option").removeAttr('disabled');
        $('.btn-add-payment, #btn-pag_row').removeAttr('disabled');
    }
}

// Chamar ao alterar desconto, total, tipo de pagamento ou ao recalcular pagamentos
$(document).on('change keyup', '#inp-tipo_pagamento, #valor_desconto, .total-venda, #inp-valor_row', function() {
    validarPagamentoSemPagamento();
});

// Também revalidar ao recalcular pagamentos
$(document).on('DOMSubtreeModified', '.table-payment tbody', function() {
    validarPagamentoSemPagamento();
});

// Impedir adicionar pagamentos diferentes de SEM PAGAMENTO quando total = 0
$('.btn-add-payment, #btn-pag_row').on('click', function(e) {
    let totalVenda = convertMoedaToFloat($('.total-venda').text());
    let tipoPagamento = $('#inp-tipo_pagamento').val();
    if (Math.abs(totalVenda) < 0.01 && tipoPagamento !== '99') {
        e.preventDefault();
        swal('Atenção', 'Quando o valor total da venda for zero, só é permitido a forma de pagamento SEM PAGAMENTO.', 'info');
        return false;
    }
});

// ========================================
// FUNÇÕES PARA BUSCAR E CARREGAR PRÉ-VENDA
// ========================================

// Event listener para o botão de buscar pré-venda
$(document).on('click', '#btnBuscarPreVenda', function() {
    buscarPreVenda();
});

// Event listener para Enter no campo de código da pré-venda
$(document).on('keypress', '#codigoPreVenda', function(e) {
    if (e.which === 13) { // Enter
        e.preventDefault();
        buscarPreVenda();
    }
});

// Função principal para buscar pré-venda
function buscarPreVenda() {
    const codigo = $('#codigoPreVenda').val().trim();
    
    if (!codigo) {
        swal({
            title: "Atenção",
            text: "Digite o código da pré-venda",
            icon: "warning",
            closeOnClickOutside: false
        });
        $('#codigoPreVenda').focus();
        return;
    }
    
    // Verificar se há itens no carrinho atual
    if ($('.table-itens tbody tr').length > 0) {
        swal({
            title: "Carrinho não vazio",
            text: "Deseja limpar o carrinho atual e carregar a pré-venda?",
            icon: "warning",
            buttons: ["Cancelar", "Sim, carregar pré-venda"],
            dangerMode: false,
        }).then((willLoad) => {
            if (willLoad) {
                carregarPreVenda(codigo);
            }
        });
    } else {
        carregarPreVenda(codigo);
    }
}

// Função para carregar dados da pré-venda
function carregarPreVenda(codigo) {
    // Mostrar loading
    swal({
        title: "Buscando pré-venda...",
        text: "Aguarde enquanto carregamos os dados",
        icon: "info",
        buttons: false,
        closeOnClickOutside: false,
        closeOnEsc: false,
    });
    
    $.post(path_url + 'api/buscar-pre-venda', {
        codigo: codigo,
        empresa_id: $('#empresa_id').val()
    })
    .done((data) => {
        swal.close();
        
        // Limpar carrinho atual
        $('.table-itens tbody').empty();
        
        // Armazenar dados da pré-venda carregada
        window.preVendaCarregada = data;
        
        // Carregar dados da pré-venda
        carregarDadosPreVenda(data);
        
        // Mostrar sucesso
        swal({
            title: "Pré-venda carregada!",
            text: `Código: ${data.codigo}\nCliente: ${data.cliente_nome}\nTotal: R$ ${convertFloatToMoeda(data.valor_total)}`,
            icon: "success",
            closeOnClickOutside: false
        });
        
        // Limpar campo de busca
        $('#codigoPreVenda').val('');
        
    })
    .fail((error) => {
        swal.close();
        
        let mensagem = "Erro ao buscar pré-venda";
        if (error.responseJSON) {
            mensagem = error.responseJSON;
        } else if (error.responseText) {
            mensagem = error.responseText;
        }
        
        swal("Erro", mensagem, "error");
        $('#codigoPreVenda').focus();
    });
}

// Função para carregar dados da pré-venda no PDV
function carregarDadosPreVenda(preVenda) {
    console.log("Debug - carregarDadosPreVenda - emitirNfce antes:", emitirNfce);
    
    // Definir a variável global para indicar que uma pré-venda foi carregada
    window.preVendaCarregada = preVenda;
    preVendaCarregada = preVenda;
    
    // Quando uma pré-venda é carregada, definir emitirNfce como true automaticamente
    emitirNfce = true;
    console.log("Debug - carregarDadosPreVenda - emitirNfce definido como:", emitirNfce);
    
    // Adicionar campo oculto para indicar que deve emitir NFCe
    if ($("#emitir_nfce").length) {
        $("#emitir_nfce").val('true');
    } else {
        $("<input>").attr({
            type: "hidden",
            id: "emitir_nfce",
            name: "emitir_nfce",
            value: "true"
        }).appendTo("#form-pdv");
    }
    
    // Carregar dados do cliente
    if (preVenda.cliente_id) {
        $('#inp-cliente_id').val(preVenda.cliente_id).trigger('change');
        $('#inp-cliente_nome').val(preVenda.cliente_nome);
        $('#inp-cliente_cpf_cnpj').val(preVenda.cliente_cpf_cnpj);
    }
    
    // Carregar dados do funcionário/vendedor
    if (preVenda.funcionario_id) {
        $('#inp-funcionario_id').val(preVenda.funcionario_id).trigger('change');
    }
    
    // Carregar observação
    if (preVenda.observacao) {
        $('#inp-observacao').val(preVenda.observacao);
    }
    
    // Carregar desconto e acréscimo
    if (preVenda.desconto > 0) {
        DESCONTO = preVenda.desconto;
        $('#valor_desconto').text("R$ " + convertFloatToMoeda(DESCONTO));
    }
    
    if (preVenda.acrescimo > 0) {
        VALORACRESCIMO = preVenda.acrescimo;
        $('#valor_acrescimo').text("R$ " + convertFloatToMoeda(VALORACRESCIMO));
    }
    
    // Carregar itens
    if (preVenda.itens && preVenda.itens.length > 0) {
        preVenda.itens.forEach((item, index) => {
            adicionarItemPreVenda(item, index);
        });
    }
    
    // Carregar faturas/pagamentos
    if (preVenda.faturas && preVenda.faturas.length > 0) {
        carregarFaturasPreVenda(preVenda.faturas);
    }
    
    // Recalcular total
    calcTotal();
    validateButtonSave();
}

// ========================================
// FUNÇÕES DE BUSCA DE COMANDA/MESA
// ========================================

// Função para abrir o modal de busca de comanda/mesa
function abrirBuscaComanda() {
    $('#buscar_comanda').modal('show');
    $('#numeroComanda').val('').focus();
    $('#infoComanda').hide();
    $('#btnCarregarComanda').hide();
}

// Função para buscar comanda/mesa
function buscarComanda() {
    const numeroComanda = $('#numeroComanda').val().trim();
    
    if (!numeroComanda) {
        swal({
            title: "Atenção",
            text: "Digite o número da comanda/mesa",
            icon: "warning"
        });
        return;
    }
    
    const empresaId = $('#empresa_id').val();
    
    // Mostrar loading
    $('#btnBuscarComanda').prop('disabled', true).html('<i class="ri-loader-4-line"></i> Buscando...');
    
    $.ajax({
        url: '/api/buscar-comanda',
        method: 'GET',
        data: {
            numero: numeroComanda,
            empresa_id: empresaId
        },
        success: function(response) {
            if (response.success) {
                mostrarDetalhesComanda(response.data);
            } else {
                swal({
                    title: "Comanda não encontrada",
                    text: response.message || "Comanda/mesa não encontrada ou já finalizada",
                    icon: "error"
                });
                $('#infoComanda').hide();
                $('#btnCarregarComanda').hide();
            }
        },
        error: function(xhr) {
            let message = "Erro ao buscar comanda/mesa";
            if (xhr.responseJSON && xhr.responseJSON.message) {
                message = xhr.responseJSON.message;
            }
            swal({
                title: "Erro",
                text: message,
                icon: "error"
            });
            $('#infoComanda').hide();
            $('#btnCarregarComanda').hide();
        },
        complete: function() {
            $('#btnBuscarComanda').prop('disabled', false).html('<i class="ri-search-line"></i> Buscar');
        }
    });
}

// Função para mostrar detalhes da comanda encontrada
function mostrarDetalhesComanda(comanda) {
    let detalhes = `
        <strong>Mesa/Comanda:</strong> ${comanda.numero}<br>
        <strong>Status:</strong> ${comanda.status}<br>
        <strong>Total:</strong> R$ ${parseFloat(comanda.total || 0).toFixed(2)}<br>
        <strong>Itens:</strong> ${comanda.itens ? comanda.itens.length : 0}
    `;
    
    if (comanda.itens && comanda.itens.length > 0) {
        detalhes += '<br><br><strong>Produtos:</strong><br>';
        comanda.itens.forEach(item => {
            detalhes += `• ${item.produto_nome} - Qtd: ${item.quantidade} - R$ ${parseFloat(item.valor_unitario || item.valor || 0).toFixed(2)}<br>`;
        });
    }
    
    $('#detalhesComanda').html(detalhes);
    $('#infoComanda').show();
    $('#btnCarregarComanda').show();
    
    // Armazenar dados da comanda para uso posterior
    window.comandaSelecionada = comanda;
}

// Função para carregar comanda no PDV
function carregarComandaNoPDV() {
    if (!window.comandaSelecionada) {
        swal({
            title: "Erro",
            text: "Nenhuma comanda selecionada",
            icon: "error"
        });
        return;
    }
    
    const comanda = window.comandaSelecionada;
    
    // Confirmar antes de carregar
    swal({
        title: "Carregar Comanda?",
        text: `Deseja carregar a comanda ${comanda.numero} no PDV? Isso irá limpar o carrinho atual.`,
        icon: "warning",
        buttons: {
            cancel: "Cancelar",
            confirm: "Sim, carregar"
        }
    }).then((confirmar) => {
        if (confirmar) {
            // Limpar carrinho atual
            limparCarrinho();
            
            // Definir mesa_comanda_id no formulário
            if (!$('#mesa_comanda_id').length) {
                $('#form-pdv').append('<input type="hidden" id="mesa_comanda_id" name="mesa_comanda_id" value="">');
            }
            $('#mesa_comanda_id').val(comanda.id);
            
            // Carregar itens da comanda
            if (comanda.itens && comanda.itens.length > 0) {
                comanda.itens.forEach(function(item, index) {
                    const itemParaPDV = {
                        produto_id: item.produto_id,
                        produto_nome: item.produto_nome,
                        quantidade: item.quantidade,
                        valor_unitario: item.valor_unitario,
                        subtotal: item.subtotal
                    };
                    adicionarItemComanda(itemParaPDV, index);
                });
            }
            
            // Recalcular total
            calcTotal();
            validateButtonSave();
            
            // Fechar modal
            $('#buscar_comanda').modal('hide');
            
            swal({
                title: "Sucesso",
                text: `Comanda ${comanda.numero} carregada no PDV com sucesso!`,
                icon: "success",
                timer: 2000
            });
        }
    });
}

// Função para adicionar item da comanda no PDV
function adicionarItemComanda(item, index) {
    const produto = {
        id: item.produto_id,
        nome: item.produto_nome,
        valor_venda: item.valor_unitario
    };
    
    // Adicionar produto ao carrinho
    addProduto(produto, item.quantidade);
}

// Função para limpar carrinho
function limparCarrinho() {
    // Limpar tabela de itens
    $('#produtos_selecionados tbody').empty();
    
    // Resetar totais
    VALORTOTAL = 0;
    VALORDESCONTO = 0;
    VALORACRESCIMO = 0;
    
    // Atualizar interface
    $('#valor_total').text('R$ 0,00');
    $('#valor_desconto').text('R$ 0,00');
    $('#valor_acrescimo').text('R$ 0,00');
    $('#valor_final').text('R$ 0,00');
    
    // Limpar campos de desconto e acréscimo
    $('#desconto').val('');
    $('#acrescimo').val('');
    
    // Limpar mesa_comanda_id se existir
    $('#mesa_comanda_id').val('');
    
    validateButtonSave();
}

// Função para adicionar item da pré-venda
function adicionarItemPreVenda(item, index) {
    // Calcula valores numéricos com segurança
    const qt = Number(item.quantidade) || 0;
    const vlUnit = Number(item.valor_unitario) || 0;
    const sub = parseFloat((qt * vlUnit).toFixed(2));

    // Quantidade: para itens de consignação, bloqueia edição visualmente, mas mantém o campo no form
    let quantidadeCell = '';
    if (item.de_consignacao) {
        quantidadeCell = `
            <div class="d-flex align-items-center">
                <input type="hidden" name="quantidade[]" value="${qt.toFixed(3).replace('.', ',')}">
                <span>${qt.toFixed(3).replace('.', ',')}</span>
            </div>`;
    } else {
        quantidadeCell = `
            <div class="input-group">
                <div class="input-group-prepend">
                    <button id="btn-subtrai" class="btn btn-danger btn-sm" type="button">-</button>
                </div>
                <input type="tel" readonly class="form-control qtd qtd_row" name="quantidade[]" value="${qt.toFixed(3).replace('.', ',')}">
                <div class="input-group-append">
                    <button class="btn btn-success btn-sm" id="btn-incrementa" type="button">+</button>
                </div>
            </div>`;
    }

    // Monta a linha seguindo o padrão existente no PDV (inputs readonly)
    const row = `
        <tr class="line-product">
            <input readonly type="hidden" name="key" class="form-control" value="${index}">
            <input readonly type="hidden" name="produto_id[]" class="produto_row" value="${item.produto_id}">
            <input name="variacao_id[]" type="hidden" value="${item.variacao_id || ''}">

            <td>
                <input readonly type="text" name="produto_nome[]" class="form-control" value="${item.produto_nome}">
            </td>

            <td class="datatable-cell">
                ${quantidadeCell}
            </td>

            <td>
                <input readonly type="tel" name="valor_unitario[]" class="form-control value-unit" value="${convertFloatToMoeda(vlUnit)}">
            </td>
            <td>
                <input readonly type="tel" name="subtotal_item[]" class="form-control subtotal-item" value="${convertFloatToMoeda(sub)}">
            </td>
            <td class="text-center">
                <button type="button" class="btn btn-danger btn-sm btn-delete-row"><i class="ri-delete-bin-line"></i></button>
            </td>
        </tr>`;

    $('.table-itens tbody').append(row);
}

// Função para carregar faturas da pré-venda
function carregarFaturasPreVenda(faturas) {
    // Limpar pagamentos atuais
    $('.table-payment tbody').empty();
    window.pagamentosRegistradosPDV = [];
    
    faturas.forEach((fatura, index) => {
        const tipoPagamento = fatura.tipo_pagamento;
        const valor = fatura.valor;
        const dataVencimento = fatura.data_vencimento;
        
        // Adicionar ao array de pagamentos
        window.pagamentosRegistradosPDV.push({
            tipo_pagamento: tipoPagamento,
            valor: valor,
            data_vencimento: dataVencimento,
            quantidade: 1
        });
        
        // Adicionar linha na tabela de pagamentos
        const row = `
            <tr>
                <td>${getTipoPagamentoNome(tipoPagamento)}</td>
                <td>R$ ${convertFloatToMoeda(valor)}</td>
                <td>${formatarData(dataVencimento)}</td>
                <td class="text-center">
                    <button type="button" class="btn btn-danger btn-sm btn-remove-payment">
                        <i class="ri-delete-bin-line"></i>
                    </button>
                </td>
            </tr>
        `;
        
        $('.table-payment tbody').append(row);
    });
    
    // Recalcular total dos pagamentos
    calcTotalPayment();
}

// Função auxiliar para obter nome do tipo de pagamento
function getTipoPagamentoNome(tipo) {
    const tipos = {
        '01': 'Dinheiro',
        '02': 'Cheque',
        '03': 'Cartão de Crédito',
        '04': 'Cartão de Débito',
        '05': 'Crédito Loja',
        '06': 'Crediário',
        '10': 'Vale Alimentação',
        '11': 'Vale Refeição',
        '12': 'Vale Presente',
        '13': 'Vale Combustível',
        '14': 'Duplicata Mercantil',
        '15': 'Boleto Bancário',
        '16': 'Depósito Bancário',
        '17': 'PIX',
        '90': 'Sem Pagamento',
        '99': 'Outros'
    };
    
    return tipos[tipo] || 'Não identificado';
}

// Função para formatar data (corrigindo o erro formatarData is not defined)
function formatarData(data) {
    if (!data) return '';
    
    // Se já estiver no formato dd/mm/yyyy, retorna como está
    if (typeof data === 'string' && data.includes('/')) {
        return data;
    }
    
    // Se for uma data válida, formata
    const dataObj = new Date(data);
    if (isNaN(dataObj.getTime())) {
        return data; // Retorna como está se não for uma data válida
    }
    
    const dia = String(dataObj.getDate()).padStart(2, '0');
    const mes = String(dataObj.getMonth() + 1).padStart(2, '0');
    const ano = dataObj.getFullYear();
    
    return `${dia}/${mes}/${ano}`;
}

// Função para formatar moeda (garantir que existe)
function formatarMoeda(valor) {
    if (typeof valor === 'string') {
        valor = parseFloat(valor.replace(/[^\d,.-]/g, '').replace(',', '.'));
    }
    
    if (isNaN(valor)) {
        valor = 0;
    }
    
    return valor.toLocaleString('pt-BR', {
        style: 'currency',
        currency: 'BRL',
        minimumFractionDigits: 2
    });
}

// Função convertFloatToMoeda (garantir que existe no PDV)
function convertFloatToMoeda(value) {
    if (value === null || value === undefined || value === '') {
        return '0,00';
    }
    
    // Se já for string, tenta converter
    if (typeof value === 'string') {
        // Remove caracteres não numéricos exceto vírgula e ponto
        value = value.replace(/[^\d,.-]/g, '');
        // Substitui vírgula por ponto para conversão
        value = value.replace(',', '.');
    }
    
    // Converte para float
    let floatValue = parseFloat(value);
    
    // Se não for um número válido, retorna 0,00
    if (isNaN(floatValue)) {
        return '0,00';
    }
    
    // Formata para o padrão brasileiro
    return floatValue.toLocaleString('pt-BR', {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
    });
}

// ========================================
// FUNÇÕES DE BUSCA DE PRÉ-VENDA COM SWEETALERT
// ========================================

// Função para abrir o SweetAlert de busca de pré-venda
function abrirBuscaPreVenda() {
    swal({
        title: "Buscar Pré-venda",
        text: "Digite o código da pré-venda que deseja carregar no PDV:",
        content: {
            element: "input",
            attributes: {
                placeholder: "Ex: PRV0001",
                type: "text",
                id: "codigoPreVendaSweetAlert"
            }
        },
        icon: "info",
        buttons: {
            cancel: "Cancelar",
            confirm: "Buscar"
        },
        closeOnClickOutside: false
    }).then((codigo) => {
        if (codigo) {
            buscarPreVendaSweetAlert(codigo);
        }
    });
}

// Função para buscar pré-venda usando SweetAlert
function buscarPreVendaSweetAlert(codigo) {
    if (!codigo || codigo.trim() === '') {
        swal({
            title: "Atenção",
            text: "Digite o código da pré-venda",
            icon: "warning",
            closeOnClickOutside: false
        });
        return;
    }
    
    codigo = codigo.trim();
    
    // Debug: verificar se está pegando o empresa_id
    let empresaId = $('#empresa_id').val();
    console.log('Debug - empresa_id:', empresaId);
    console.log('Debug - elemento empresa_id existe:', $('#empresa_id').length > 0);
    console.log('Debug - valor do elemento:', $('#empresa_id').val());
    
    // Se não conseguir pegar o empresa_id, tentar outras fontes
    if (!empresaId) {
        // Tentar pegar da URL
        const urlParams = new URLSearchParams(window.location.search);
        empresaId = urlParams.get('empresa_id');
        console.log('Debug - empresa_id da URL:', empresaId);
    }
    
    // Se ainda não conseguir, parar
    if (!empresaId) {
        swal({
            title: "Erro",
            text: "Não foi possível identificar a empresa. Recarregue a página e tente novamente.",
            icon: "error",
            closeOnClickOutside: false
        });
        return;
    }
    
    // Mostrar loading
    swal({
        title: "Buscando...",
        text: "Procurando pela pré-venda " + codigo,
        icon: "info",
        buttons: false,
        closeOnClickOutside: false
    });
    
    $.ajax({
        url: '/api/buscar-pre-venda',
        method: 'POST',
        data: {
            codigo: codigo,
            empresa_id: empresaId,
            _token: $('meta[name="csrf-token"]').attr('content')
        },
        success: function(response) {
            if (response.success) {
                const data = response.data;
                
                // Mostrar resultado com opção de carregar
                swal({
                    title: "Pré-venda Encontrada!",
                    text: `Código: ${data.codigo}\nCliente: ${data.cliente_nome}\nTotal: R$ ${convertFloatToMoeda(data.valor_total)}\nItens: ${data.itens.length} produtos\nData: ${formatarData(data.created_at)}`,
                    icon: "success",
                    closeOnClickOutside: false,
                    buttons: {
                        cancel: "Cancelar",
                        confirm: "Carregar no PDV"
                    }
                }).then((confirmou) => {
                    if (confirmou) {
                        carregarPreVendaSweetAlert(data);
                    }
                });
                
            } else {
                swal({
                    title: "Pré-venda não encontrada",
                    text: response.message,
                    icon: "info",
                    closeOnClickOutside: false
                });
            }
        },
        error: function(xhr) {
            let mensagem = 'Erro ao buscar pré-venda';
            if (xhr.responseJSON && xhr.responseJSON.message) {
                mensagem = xhr.responseJSON.message;
            }
            swal({
                title: "Informação",
                text: mensagem,
                icon: "info",
                closeOnClickOutside: false
            });
        }
    });
}

// Função para carregar pré-venda no PDV usando SweetAlert
function carregarPreVendaSweetAlert(data) {
    swal({
        title: "Carregar Pré-venda?",
        text: `Deseja carregar a pré-venda ${data.codigo} no PDV?\n\nIsso substituirá os dados atuais da venda.`,
        icon: "question",
        closeOnClickOutside: false,
        buttons: {
            cancel: "Cancelar",
            confirm: "Sim, Carregar"
        }
    }).then((confirmou) => {
        if (confirmou) {
            // Carregar os dados no PDV
            carregarDadosPreVenda(data);
            
            // Mostrar sucesso
            swal({
                title: "Pré-venda carregada com sucesso!",
                text: `Código: ${data.codigo}\nCliente: ${data.cliente_nome}\nTotal: R$ ${convertFloatToMoeda(data.valor_total)}`,
                icon: "success",
                closeOnClickOutside: false
            });
        }
    });
}

// Função para carregar consignação no PDV
function carregarConsignacao(codigo) {
    swal({
        title: "Buscando consignação...",
        text: "Aguarde enquanto carregamos os dados",
        icon: "info",
        buttons: false,
        closeOnClickOutside: false,
        closeOnEsc: false,
    });
    $.post(path_url + 'api/buscar-consignacao', {
        codigo: codigo,
        empresa_id: $('#empresa_id').val()
    })
    .done((data) => {
        swal.close();
        // Limpar carrinho atual
        $('.table-itens tbody').empty();
        // Carregar dados da consignação
        carregarDadosConsignacao(data);
        swal({
            title: "Consignação carregada!",
            text: `Código: ${data.codigo}\nCliente: ${data.cliente_nome}\nTotal: R$ ${convertFloatToMoeda(data.valor_total)}`,
            icon: "success",
            closeOnClickOutside: false
        });
    })
    .fail((error) => {
        swal.close();
        let mensagem = "Erro ao buscar consignação";
        if (error.responseJSON) {
            mensagem = error.responseJSON;
        } else if (error.responseText) {
            mensagem = error.responseText;
        }
        swal("Erro", mensagem, "error");
    });
}

function carregarDadosConsignacao(consignacao) {
    // Carregar dados do cliente
    if (consignacao.cliente_id) {
        $('#inp-cliente_id').val(consignacao.cliente_id).trigger('change');
        $('#inp-cliente_nome').val(consignacao.cliente_nome);
        $('#inp-cliente_cpf_cnpj').val(consignacao.cliente_cpf_cnpj);
    }
    // Carregar dados do funcionário/vendedor
    if (consignacao.funcionario_id) {
        $('#inp-funcionario_id').val(consignacao.funcionario_id).trigger('change');
    }
    // Carregar observação
    if (consignacao.observacao) {
        $('#inp-observacao').val(consignacao.observacao);
    }
    // Carregar desconto e acréscimo (se houver)
    if (consignacao.desconto > 0) {
        DESCONTO = consignacao.desconto;
        $('#valor_desconto').text("R$ " + convertFloatToMoeda(DESCONTO));
    }
    if (consignacao.acrescimo > 0) {
        VALORACRESCIMO = consignacao.acrescimo;
        $('#valor_acrescimo').text("R$ " + convertFloatToMoeda(VALORACRESCIMO));
    }
    // Carregar itens
    if (consignacao.itens && consignacao.itens.length > 0) {
        consignacao.itens.forEach((item, index) => {
            adicionarItemPreVenda(item, index);
        });
    }
    // Recalcular total
    calcTotal();
    validateButtonSave();
}


