<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\Produto;

echo "=== DEBUG PRODUTOS ===\n";

$produto = Produto::where('empresa_id', 1)->first();

if ($produto) {
    echo "Status do produto: " . $produto->status . "\n";
    echo "Nome do produto: " . $produto->nome . "\n";
    echo "Empresa ID: " . $produto->empresa_id . "\n";
    echo "ID do produto: " . $produto->id . "\n";
    
    // Testando a query da API
    echo "\n=== TESTANDO QUERY DA API ===\n";
    
    $data = Produto::orderBy('nome', 'desc')
        ->select('produtos.*')
        ->where('empresa_id', 1)
        ->where('status', 1)
        ->where('nome', 'LIKE', "%Produto%")
        ->get();
        
    echo "Produtos encontrados com 'Produto' no nome: " . $data->count() . "\n";
    
    if ($data->count() > 0) {
        foreach ($data as $p) {
            echo "- ID: {$p->id}, Nome: {$p->nome}, Status: {$p->status}\n";
        }
    }
    
    // Testando com o nome exato
    $data2 = Produto::orderBy('nome', 'desc')
        ->select('produtos.*')
        ->where('empresa_id', 1)
        ->where('status', 1)
        ->where('nome', 'LIKE', "%{$produto->nome}%")
        ->get();
        
    echo "\nProdutos encontrados com '{$produto->nome}' no nome: " . $data2->count() . "\n";
    
    if ($data2->count() > 0) {
        foreach ($data2 as $p) {
            echo "- ID: {$p->id}, Nome: {$p->nome}, Status: {$p->status}\n";
        }
    }
    
} else {
    echo "Nenhum produto encontrado para empresa_id = 1\n";
}