<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\Produto;
use App\Models\ProdutoLocalizacao;
use App\Models\Localizacao;
use App\Models\Caixa;
use App\Models\UsuarioLocalizacao;

echo "=== DEBUG API COMPLETO ===\n";

// Simular exatamente o que a API faz
$empresa_id = 1;
$usuario_id = 1;
$pesquisa = "CABO";

echo "Parâmetros: empresa_id=$empresa_id, usuario_id=$usuario_id, pesquisa=$pesquisa\n\n";

// 1. Determinar local_id
$local_id = null;

$caixa = Caixa::where('usuario_id', $usuario_id)->where('status', 1)->first();
if($caixa != null){
    echo "Caixa encontrado: Local ID {$caixa->local_id}\n";
    
    $locais = Localizacao::where('usuario_localizacaos.usuario_id', $usuario_id)
        ->select('localizacaos.*')
        ->join('usuario_localizacaos', 'usuario_localizacaos.localizacao_id', '=', 'localizacaos.id')
        ->where('localizacaos.status', 1)->get();
    
    echo "Locais do usuário: " . $locais->count() . "\n";
    foreach ($locais as $loc) {
        echo "- ID: {$loc->id}, Nome: {$loc->nome}\n";
    }
    
    // Usar o primeiro local ativo (ID 1 - LOJA) como padrão no PDV
    $primeiroLocal = Localizacao::where('empresa_id', $empresa_id)
        ->where('status', 1)->first();
    $local_id = $primeiroLocal ? $primeiroLocal->id : $caixa->local_id;
    
    echo "Primeiro local ativo: " . ($primeiroLocal ? $primeiroLocal->id : 'null') . "\n";
    echo "Local ID final: $local_id\n";
} else {
    echo "Nenhum caixa ativo para usuário $usuario_id\n";
}

echo "\n=== EXECUTANDO QUERY DA API ===\n";

// 2. Executar a query exata da API
$query = Produto::orderBy('nome', 'desc')
    ->select('produtos.*')
    ->where('empresa_id', $empresa_id)
    ->where('status', 1);

// Aplicar filtro de pesquisa
if (!is_numeric($pesquisa)) {
    $query = $query->where('nome', 'LIKE', "%$pesquisa%");
    echo "Filtro aplicado: nome LIKE '%$pesquisa%'\n";
} else {
    $query = $query->where(function($q) use ($pesquisa) {
        return $q->where('codigo_barras', 'LIKE', "%$pesquisa%")
            ->orWhere('codigo_barras2', 'LIKE', "%$pesquisa%")
            ->orWhere('codigo_barras3', 'LIKE', "%$pesquisa%");
    });
    echo "Filtro aplicado: código de barras LIKE '%$pesquisa%'\n";
}

// Aplicar filtro de localização se houver
if ($local_id != null) {
    $query = $query->join('produto_localizacaos', 'produto_localizacaos.produto_id', '=', 'produtos.id')
        ->where('produto_localizacaos.localizacao_id', $local_id);
    echo "Filtro de localização aplicado: local_id = $local_id\n";
}

$query = $query->distinct('produtos.id');

$data = $query->get();

echo "Produtos encontrados: " . $data->count() . "\n";

foreach ($data as $produto) {
    echo "- ID: {$produto->id}, Nome: {$produto->nome}, Status: {$produto->status}\n";
}

// 3. Verificar se o produto está associado ao local
if ($local_id && $data->count() == 0) {
    echo "\n=== VERIFICANDO ASSOCIAÇÃO PRODUTO-LOCAL ===\n";
    
    $produtoTeste = Produto::where('empresa_id', $empresa_id)
        ->where('status', 1)
        ->where('nome', 'LIKE', "%$pesquisa%")
        ->first();
        
    if ($produtoTeste) {
        echo "Produto encontrado sem filtro de local: {$produtoTeste->nome}\n";
        
        $associacao = ProdutoLocalizacao::where('produto_id', $produtoTeste->id)
            ->where('localizacao_id', $local_id)
            ->first();
            
        if ($associacao) {
            echo "Produto ESTÁ associado ao local $local_id\n";
        } else {
            echo "Produto NÃO está associado ao local $local_id\n";
            
            // Verificar a quais locais o produto está associado
            $associacoes = ProdutoLocalizacao::where('produto_id', $produtoTeste->id)->get();
            echo "Produto está associado aos locais: ";
            foreach ($associacoes as $assoc) {
                echo $assoc->localizacao_id . " ";
            }
            echo "\n";
        }
    }
}