<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Pais;

class PaisSeeder extends Seeder
{
    public function run(): void
    {
        foreach (Pais::getPaisesList() as $pais) {
            Pais::updateOrCreate(
                ['codigo' => $pais['codigo']],
                ['nome' => $pais['nome']]
            );
        }
        
        $this->command->info('Seeder de países executado com sucesso! ' . count(Pais::getPaisesList()) . ' países inseridos/atualizados.');
    }
}