<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\Cidade;

class CidadeExteriorSeeder extends Seeder
{
    public function run()
    {
        // Verificar se a cidade EXTERIOR já existe
        $cidadeExterior = Cidade::where('codigo', '9999999')->first();
        
        if (!$cidadeExterior) {
            Cidade::create([
                'codigo' => '9999999',
                'nome' => 'EXTERIOR',
                'uf' => 'EX'
            ]);
            
            echo "Cidade EXTERIOR criada com sucesso!\n";
        } else {
            echo "Cidade EXTERIOR já existe na base de dados.\n";
        }
    }
}