<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('conta_receber_historicos', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('conta_receber_id');
            $table->decimal('valor', 10, 2);
            $table->string('tipo_movimento'); // recebimento_integral, recebimento_parcial, reparcelamento, cancelamento, ajuste
            $table->string('tipo_pagamento')->nullable();
            $table->timestamp('data_movimento');
            $table->unsignedBigInteger('usuario_id')->nullable();
            $table->text('observacao')->nullable();
            $table->timestamps();
            
            // Referências de chaves estrangeiras
            $table->foreign('conta_receber_id')
                  ->references('id')
                  ->on('conta_recebers')
                  ->onDelete('cascade');
                  
            $table->foreign('usuario_id')
                  ->references('id')
                  ->on('users')
                  ->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('conta_receber_historicos');
    }
};
