<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Permission;
use App\Models\Role;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Adicionar permissões para aprovação de contas a pagar
        $permissions = [
            // Permissão de aprovação para coordenador
            [
                'name' => 'aprovar_conta_coordenador',
                'description' => 'Aprovar contas a pagar de nível coordenador'
            ],
            // Permissão de aprovação para gerente
            [
                'name' => 'aprovar_conta_gerente',
                'description' => 'Aprovar contas a pagar de nível gerente'
            ],
            // Permissão de aprovação para diretor
            [
                'name' => 'aprovar_conta_diretor',
                'description' => 'Aprovar contas a pagar de nível diretor'
            ],
            // Permissão para remover aprovação
            [
                'name' => 'remover_aprovacao_conta',
                'description' => 'Remover aprovação de contas a pagar'
            ]
        ];

        // Criar permissões se não existirem
        foreach ($permissions as $permission) {
            Permission::firstOrCreate(
                ['name' => $permission['name']],
                [
                    'name' => $permission['name'],
                    'description' => $permission['description'],
                    'guard_name' => 'web'
                ]
            );
        }

        // Atribuir permissões ao papel de administrador
        $adminRole = Role::where('name', 'admin')->first();
        if ($adminRole) {
            foreach ($permissions as $permission) {
                $perm = Permission::where('name', $permission['name'])->first();
                if ($perm) {
                    $adminRole->givePermissionTo($perm);
                }
            }
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Remover permissões criadas
        $permissions = [
            'aprovar_conta_coordenador',
            'aprovar_conta_gerente',
            'aprovar_conta_diretor',
            'remover_aprovacao_conta'
        ];

        foreach ($permissions as $permission) {
            $perm = Permission::where('name', $permission)->first();
            if ($perm) {
                $perm->delete();
            }
        }
    }
};
