<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pais extends Model
{
    use HasFactory;

    protected $table = 'paises';

    protected $fillable = [
        'codigo', 'nome'
    ];

    public function clientes()
    {
        return $this->hasMany(Cliente::class, 'pais_id');
    }

    public static function getPaisesList()
    {
        return [
            ['codigo' => '0132', 'nome' => "Afeganistão"],
            ['codigo' => '7560', 'nome' => "África do Sul"],
            ['codigo' => '0175', 'nome' => "Albânia, República da"],
            ['codigo' => '0230', 'nome' => "Alemanha"],
            ['codigo' => '0370', 'nome' => "Andorra"],
            ['codigo' => '0400', 'nome' => "Angola"],
            ['codigo' => '0639', 'nome' => "Argentina"],
            ['codigo' => '0698', 'nome' => "Austrália"],
            ['codigo' => '0728', 'nome' => "Áustria"],
            ['codigo' => '1058', 'nome' => "Brasil"],
            ['codigo' => '1155', 'nome' => "Canadá"],
            ['codigo' => '1279', 'nome' => "Chile"],
            ['codigo' => '1376', 'nome' => "China, República Popular"],
            ['codigo' => '1538', 'nome' => "Colômbia"],
            ['codigo' => '1589', 'nome' => "Coreia, República da"],
            ['codigo' => '1635', 'nome' => "Costa Rica"],
            ['codigo' => '1694', 'nome' => "Croácia, República da"],
            ['codigo' => '1732', 'nome' => "Cuba"],
            ['codigo' => '1775', 'nome' => "Dinamarca"],
            ['codigo' => '1830', 'nome' => "Egito"],
            ['codigo' => '1872', 'nome' => "El Salvador"],
            ['codigo' => '1902', 'nome' => "Emirados Árabes Unidos"],
            ['codigo' => '1937', 'nome' => "Equador"],
            ['codigo' => '1953', 'nome' => "Espanha"],
            ['codigo' => '2291', 'nome' => "Estados Unidos"],
            ['codigo' => '2321', 'nome' => "Estônia, República da"],
            ['codigo' => '2356', 'nome' => "Etiópia"],
            ['codigo' => '2399', 'nome' => "Filipinas"],
            ['codigo' => '2402', 'nome' => "Finlândia"],
            ['codigo' => '2437', 'nome' => "França"],
            ['codigo' => '2674', 'nome' => "Grécia"],
            ['codigo' => '2712', 'nome' => "Guatemala"],
            ['codigo' => '2755', 'nome' => "Guiana"],
            ['codigo' => '2810', 'nome' => "Haiti"],
            ['codigo' => '2852', 'nome' => "Honduras"],
            ['codigo' => '2895', 'nome' => "Hong Kong"],
            ['codigo' => '2917', 'nome' => "Hungria, República da"],
            ['codigo' => '2933', 'nome' => "Iêmen"],
            ['codigo' => '3018', 'nome' => "Índia"],
            ['codigo' => '3026', 'nome' => "Indonésia"],
            ['codigo' => '3131', 'nome' => "Iraque"],
            ['codigo' => '3149', 'nome' => "Irã, República Islâmica do"],
            ['codigo' => '3158', 'nome' => "Irlanda"],
            ['codigo' => '3166', 'nome' => "Islândia"],
            ['codigo' => '3174', 'nome' => "Israel"],
            ['codigo' => '3182', 'nome' => "Itália"],
            ['codigo' => '3298', 'nome' => "Japão"],
            ['codigo' => '3344', 'nome' => "Jordânia"],
            ['codigo' => '3379', 'nome' => "Cazaquistão, República do"],
            ['codigo' => '3387', 'nome' => "Quênia"],
            ['codigo' => '3417', 'nome' => "Kuwait"],
            ['codigo' => '3450', 'nome' => "Laos, República Democrática Popular do"],
            ['codigo' => '3514', 'nome' => "Líbano"],
            ['codigo' => '3557', 'nome' => "Libéria"],
            ['codigo' => '3573', 'nome' => "Líbia"],
            ['codigo' => '3595', 'nome' => "Liechtenstein"],
            ['codigo' => '3611', 'nome' => "Lituânia, República da"],
            ['codigo' => '3654', 'nome' => "Luxemburgo"],
            ['codigo' => '3697', 'nome' => "Macau"],
            ['codigo' => '3727', 'nome' => "Macedônia, Antiga República Iugoslava"],
            ['codigo' => '3751', 'nome' => "Madagascar"],
            ['codigo' => '3778', 'nome' => "Malásia"],
            ['codigo' => '3794', 'nome' => "Malawi"],
            ['codigo' => '3832', 'nome' => "Mali"],
            ['codigo' => '3867', 'nome' => "Malta"],
            ['codigo' => '3913', 'nome' => "Marrocos"],
            ['codigo' => '3964', 'nome' => "Maurício"],
            ['codigo' => '3972', 'nome' => "Mauritânia"],
            ['codigo' => '4030', 'nome' => "México"],
            ['codigo' => '4111', 'nome' => "Moçambique"],
            ['codigo' => '4200', 'nome' => "Mongólia"],
            ['codigo' => '4235', 'nome' => "Montenegro"],
            ['codigo' => '4260', 'nome' => "Namíbia"],
            ['codigo' => '4278', 'nome' => "Nepal"],
            ['codigo' => '4316', 'nome' => "Nicarágua"],
            ['codigo' => '4340', 'nome' => "Níger"],
            ['codigo' => '4383', 'nome' => "Nigéria"],
            ['codigo' => '4405', 'nome' => "Noruega"],
            ['codigo' => '4421', 'nome' => "Nova Zelândia"],
            ['codigo' => '4456', 'nome' => "Omã"],
            ['codigo' => '4472', 'nome' => "Países Baixos (Holanda)"],
            ['codigo' => '4499', 'nome' => "Paquistão"],
            ['codigo' => '4502', 'nome' => "Palau"],
            ['codigo' => '4525', 'nome' => "Panamá"],
            ['codigo' => '4553', 'nome' => "Papua Nova Guiné"],
            ['codigo' => '4588', 'nome' => "Paraguai"],
            ['codigo' => '4618', 'nome' => "Peru"],
            ['codigo' => '4642', 'nome' => "Polônia, República da"],
            ['codigo' => '4677', 'nome' => "Portugal"],
            ['codigo' => '4723', 'nome' => "Quatar"],
            ['codigo' => '4740', 'nome' => "Reino Unido"],
            ['codigo' => '4766', 'nome' => "República Centro-Africana"],
            ['codigo' => '4774', 'nome' => "República Tcheca"],
            ['codigo' => '4782', 'nome' => "República Dominicana"],
            ['codigo' => '4855', 'nome' => "Romênia"],
            ['codigo' => '4880', 'nome' => "Ruanda"],
            ['codigo' => '4901', 'nome' => "Rússia, Federação da"],
            ['codigo' => '4936', 'nome' => "Samoa"],
            ['codigo' => '4995', 'nome' => "São Tomé e Príncipe"],
            ['codigo' => '5053', 'nome' => "Arábia Saudita"],
            ['codigo' => '5070', 'nome' => "Senegal"],
            ['codigo' => '5088', 'nome' => "Serra Leoa"],
            ['codigo' => '5104', 'nome' => "Sérvia, República da"],
            ['codigo' => '5142', 'nome' => "Singapura"],
            ['codigo' => '5177', 'nome' => "Síria, República Árabe da"],
            ['codigo' => '5185', 'nome' => "Somália"],
            ['codigo' => '5193', 'nome' => "Sri Lanka"],
            ['codigo' => '5215', 'nome' => "Suazilândia"],
            ['codigo' => '5223', 'nome' => "Sudão"],
            ['codigo' => '5231', 'nome' => "Suécia"],
            ['codigo' => '5258', 'nome' => "Suíça"],
            ['codigo' => '5282', 'nome' => "Suriname"],
            ['codigo' => '5312', 'nome' => "Tailândia"],
            ['codigo' => '5355', 'nome' => "Taiwan (Formosa)"],
            ['codigo' => '5371', 'nome' => "Tajiquistão, República do"],
            ['codigo' => '5398', 'nome' => "Tanzânia, República Unida da"],
            ['codigo' => '5428', 'nome' => "Timor Leste"],
            ['codigo' => '5452', 'nome' => "Togo"],
            ['codigo' => '5487', 'nome' => "Tonga"],
            ['codigo' => '5495', 'nome' => "Trinidad e Tobago"],
            ['codigo' => '5517', 'nome' => "Tunísia"],
            ['codigo' => '5533', 'nome' => "Turquia"],
            ['codigo' => '5568', 'nome' => "Turcomenistão"],
            ['codigo' => '5576', 'nome' => "Tuvalu"],
            ['codigo' => '5584', 'nome' => "Ucrânia"],
            ['codigo' => '5592', 'nome' => "Uganda"],
            ['codigo' => '5611', 'nome' => "Uruguai"],
            ['codigo' => '5630', 'nome' => "Uzbequistão, República do"],
            ['codigo' => '5657', 'nome' => "Vanuatu"],
            ['codigo' => '5665', 'nome' => "Vaticano, Estado da Cidade do"],
            ['codigo' => '5681', 'nome' => "Venezuela"],
            ['codigo' => '5738', 'nome' => "Vietnã"],
            ['codigo' => '5754', 'nome' => "Zâmbia"],
            ['codigo' => '5762', 'nome' => "Zimbábue"]
        ];
    }
}