<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\Cliente;
use App\Models\User;

class OrdemProducao extends Model
{
    use HasFactory;

    protected $fillable = [
        'empresa_id', 'observacao', 'estado', 'data_prevista_entrega', 'funcionario_id',
        'situacao', 'data_producao', 'cliente_id', 'created_by', 'finished_by', 'finished_at',
        'codigo_sequencial'
    ];

    public function itens()
    {
        return $this->hasMany(ItemOrdemProducao::class, 'ordem_producao_id');
    }

    public function cliente(): BelongsTo
    {
        return $this->belongsTo(Cliente::class, 'cliente_id');
    }

    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function finisher(): BelongsTo
    {
        return $this->belongsTo(User::class, 'finished_by');
    }

    public function isFinalizada(): bool
    {
        return $this->situacao === 'finalizado';
    }

    public function isEmProducao(): bool
    {
        return $this->situacao === 'em_producao' || $this->estado === 'producao' || $this->estado === 'novo';
    }

    public function getNumeroAttribute(): string
    {
        $seq = (int)($this->codigo_sequencial ?? 0);
        return 'OP-' . str_pad((string)$seq, 5, '0', STR_PAD_LEFT);
    }

}
