<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MesaComanda extends Model
{
    use HasFactory;

    protected $table = 'mesa_comandas';

    protected $fillable = [
        'empresa_id',
        'numero',
        'status',
        'valor_total',
        'nome_cliente',
        'abertura',
        'fechamento',
    ];

    // Relacionamento com Empresa (opcional)
    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }

    // Relacionamento com itens da comanda
    public function itens()
    {
        return $this->hasMany(ItemComanda::class, 'mesa_comanda_id');
    }

    // Accessor para calcular o total baseado nos itens
    public function getTotalAttribute()
    {
        return $this->valor_total ?? $this->itens()->sum('valor_total');
    }

    // Método para atualizar o valor total baseado nos itens
    public function atualizarTotal()
    {
        $this->valor_total = $this->itens()->sum('valor_total');
        $this->save();
        return $this->valor_total;
    }
}